/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.web.internal.display.context;

import com.liferay.frontend.taglib.clay.servlet.taglib.util.CreationMenu;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.SafeConsumer;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.ViewTypeItemList;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.PortletURLUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.trash.TrashHelper;
import com.liferay.wiki.web.internal.security.permission.resource.WikiResourcePermission;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.portlet.PortletException;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class WikiNodesManagementToolbarDisplayContext {
    private final PortletURL _currentURLObj;
    private final String _displayStyle;
    private final LiferayPortletRequest _liferayPortletRequest;
    private final LiferayPortletResponse _liferayPortletResponse;
    private final HttpServletRequest _request;
    private final SearchContainer _searchContainer;
    private final ThemeDisplay _themeDisplay;
    private final TrashHelper _trashHelper;

    public WikiNodesManagementToolbarDisplayContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, String displayStyle, SearchContainer searchContainer, TrashHelper trashHelper) {
        this._liferayPortletRequest = liferayPortletRequest;
        this._liferayPortletResponse = liferayPortletResponse;
        this._displayStyle = displayStyle;
        this._searchContainer = searchContainer;
        this._trashHelper = trashHelper;
        this._currentURLObj = PortletURLUtil.getCurrent((LiferayPortletRequest)this._liferayPortletRequest, (LiferayPortletResponse)this._liferayPortletResponse);
        this._request = liferayPortletRequest.getHttpServletRequest();
        this._themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
    }

    public List<DropdownItem> getActionDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(SafeConsumer.ignore(dropdownItem -> {
                    dropdownItem.putData("action", "deleteNodes");
                    if (WikiNodesManagementToolbarDisplayContext.this._trashHelper.isTrashEnabled(WikiNodesManagementToolbarDisplayContext.this._themeDisplay.getScopeGroupId())) {
                        dropdownItem.setIcon("trash");
                        dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)WikiNodesManagementToolbarDisplayContext.this._request, (String)"move-to-recycle-bin"));
                    } else {
                        dropdownItem.setIcon("times");
                        dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)WikiNodesManagementToolbarDisplayContext.this._request, (String)"delete"));
                    }
                    dropdownItem.setQuickAction(true);
                }));
            }
        };
    }

    public CreationMenu getCreationMenu() {
        if (!WikiResourcePermission.contains(this._themeDisplay.getPermissionChecker(), this._themeDisplay.getScopeGroupId(), "ADD_NODE")) {
            return null;
        }
        return new CreationMenu(){
            {
                this.addDropdownItem(dropdownItem -> {
                    PortletURL viewNodesURL = WikiNodesManagementToolbarDisplayContext.this._liferayPortletResponse.createRenderURL();
                    viewNodesURL.setParameter("mvcRenderCommandName", "/wiki_admin/view");
                    dropdownItem.setHref(WikiNodesManagementToolbarDisplayContext.this._liferayPortletResponse.createRenderURL(), new Object[]{"mvcRenderCommandName", "/wiki/edit_node", "redirect", viewNodesURL.toString()});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)WikiNodesManagementToolbarDisplayContext.this._request, (String)"add-wiki"));
                });
            }
        };
    }

    public List<DropdownItem> getFilterDropdownItems() {
        return new DropdownItemList(){
            {
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(WikiNodesManagementToolbarDisplayContext.this._getOrderByDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)WikiNodesManagementToolbarDisplayContext.this._request, (String)"order-by"));
                });
            }
        };
    }

    public String getSortingOrder() {
        return this._getOrderByType();
    }

    public PortletURL getSortingURL() throws PortletException {
        PortletURL sortingURL = this._getPortletURL();
        sortingURL.setParameter("orderByCol", this._getOrderByCol());
        sortingURL.setParameter("orderByType", Objects.equals(this._getOrderByType(), "asc") ? "desc" : "asc");
        return sortingURL;
    }

    public int getTotalItems() {
        return this._searchContainer.getTotal();
    }

    public ViewTypeItemList getViewTypes() throws PortletException {
        return new ViewTypeItemList(this._getPortletURL(), this._displayStyle){
            {
                this.addListViewTypeItem();
                this.addTableViewTypeItem();
            }
        };
    }

    public boolean isDisabled() {
        return !this._searchContainer.hasResults();
    }

    public boolean isSelectable() {
        return true;
    }

    public boolean isShowSearch() {
        return false;
    }

    private String _getOrderByCol() {
        return this._searchContainer.getOrderByCol();
    }

    private List<DropdownItem> _getOrderByDropdownItems() {
        return new DropdownItemList(){
            {
                HashMap<String, String> orderColumns = new HashMap<String, String>();
                orderColumns.put("lastPostDate", "last-post-date");
                orderColumns.put("name", "name");
                for (Map.Entry orderByColEntry : orderColumns.entrySet()) {
                    String orderByCol = (String)orderByColEntry.getKey();
                    this.add(SafeConsumer.ignore(dropdownItem -> {
                        dropdownItem.setActive(orderByCol.equals(WikiNodesManagementToolbarDisplayContext.this._getOrderByCol()));
                        dropdownItem.setHref(WikiNodesManagementToolbarDisplayContext.this._getPortletURL(), new Object[]{"orderByCol", orderByCol});
                        dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)WikiNodesManagementToolbarDisplayContext.this._request, (String)((String)orderByColEntry.getValue())));
                    }));
                }
            }
        };
    }

    private String _getOrderByType() {
        return this._searchContainer.getOrderByType();
    }

    private PortletURL _getPortletURL() throws PortletException {
        PortletURL portletURL = PortletURLUtil.clone((PortletURL)this._currentURLObj, (LiferayPortletResponse)this._liferayPortletResponse);
        portletURL.setParameter("mvcRenderCommandName", "/wiki_admin/view");
        return portletURL;
    }
}

