/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.web.internal.display.context;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.wiki.display.context.WikiPageInfoPanelDisplayContext;
import com.liferay.wiki.model.WikiNode;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.service.WikiPageLocalServiceUtil;
import com.liferay.wiki.web.internal.display.context.util.WikiPageInfoPanelRequestHelper;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DefaultWikiPageInfoPanelDisplayContext
implements WikiPageInfoPanelDisplayContext {
    private static final UUID _UUID = UUID.fromString("7099F1F8-ED73-47D8-9CDC-ED292BF7779F");
    private final WikiPageInfoPanelRequestHelper _wikiPageInfoPanelRequestHelper;

    public DefaultWikiPageInfoPanelDisplayContext(HttpServletRequest request, HttpServletResponse response) {
        this._wikiPageInfoPanelRequestHelper = new WikiPageInfoPanelRequestHelper(request);
    }

    public WikiPage getFirstPage() {
        List<WikiPage> pages = this._wikiPageInfoPanelRequestHelper.getPages();
        if (pages.isEmpty()) {
            return this._wikiPageInfoPanelRequestHelper.getPage();
        }
        return pages.get(0);
    }

    public String getPageRSSURL(WikiPage page) {
        ThemeDisplay themeDisplay = this._wikiPageInfoPanelRequestHelper.getThemeDisplay();
        StringBundler sb = new StringBundler(5);
        sb.append(themeDisplay.getPathMain());
        sb.append("/wiki/rss?nodeId=");
        sb.append(page.getNodeId());
        sb.append("&title=");
        sb.append(page.getTitle());
        return sb.toString();
    }

    public int getPagesCount() {
        WikiNode node = this._wikiPageInfoPanelRequestHelper.getCurrentNode();
        return WikiPageLocalServiceUtil.getPagesCount((long)node.getNodeId(), (boolean)true);
    }

    public int getSelectedPagesCount() {
        List<WikiPage> items = this.getSelectedPages();
        return items.size();
    }

    public UUID getUuid() {
        return _UUID;
    }

    public boolean isMultiplePageSelection() {
        List<WikiPage> items = this.getSelectedPages();
        return items.size() > 1;
    }

    public boolean isShowSidebarHeader() {
        return this._wikiPageInfoPanelRequestHelper.isShowSidebarHeader();
    }

    public boolean isSinglePageSelection() {
        List<WikiPage> pages = this._wikiPageInfoPanelRequestHelper.getPages();
        if (pages.size() == 1) {
            return true;
        }
        WikiPage page = this._wikiPageInfoPanelRequestHelper.getPage();
        return page != null;
    }

    protected List<WikiPage> getSelectedPages() {
        return this._wikiPageInfoPanelRequestHelper.getPages();
    }
}

