/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.web.internal.display.context;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryServiceUtil;
import com.liferay.asset.kernel.service.persistence.AssetEntryQuery;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchContextFactory;
import com.liferay.portal.kernel.search.SearchResult;
import com.liferay.portal.kernel.search.SearchResultUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.servlet.taglib.ui.DeleteMenuItem;
import com.liferay.portal.kernel.servlet.taglib.ui.JavaScriptMenuItem;
import com.liferay.portal.kernel.servlet.taglib.ui.Menu;
import com.liferay.portal.kernel.servlet.taglib.ui.MenuItem;
import com.liferay.portal.kernel.servlet.taglib.ui.URLMenuItem;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.subscription.service.SubscriptionLocalServiceUtil;
import com.liferay.taglib.search.ResultRow;
import com.liferay.taglib.security.PermissionsURLTag;
import com.liferay.trash.TrashHelper;
import com.liferay.wiki.configuration.WikiGroupServiceConfiguration;
import com.liferay.wiki.configuration.WikiGroupServiceOverriddenConfiguration;
import com.liferay.wiki.display.context.WikiListPagesDisplayContext;
import com.liferay.wiki.display.context.WikiUIItemKeys;
import com.liferay.wiki.model.WikiNode;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.model.WikiPageResource;
import com.liferay.wiki.service.WikiPageLocalServiceUtil;
import com.liferay.wiki.service.WikiPageResourceLocalServiceUtil;
import com.liferay.wiki.service.WikiPageServiceUtil;
import com.liferay.wiki.util.comparator.PageVersionComparator;
import com.liferay.wiki.web.internal.display.context.util.WikiRequestHelper;
import com.liferay.wiki.web.internal.security.permission.resource.WikiNodePermission;
import com.liferay.wiki.web.internal.security.permission.resource.WikiPagePermission;
import com.liferay.wiki.web.internal.util.WikiPortletUtil;
import com.liferay.wiki.web.internal.util.WikiWebComponentProvider;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import javax.portlet.PortletURL;
import javax.portlet.WindowStateException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DefaultWikiListPagesDisplayContext
implements WikiListPagesDisplayContext {
    private static final UUID _UUID = UUID.fromString("628C435B-DB39-4E46-91DF-CEA763CF79F5");
    private static final Log _log = LogFactoryUtil.getLog(DefaultWikiListPagesDisplayContext.class);
    private final HttpServletRequest _request;
    private final TrashHelper _trashHelper;
    private final WikiNode _wikiNode;
    private final WikiRequestHelper _wikiRequestHelper;

    public DefaultWikiListPagesDisplayContext(HttpServletRequest request, HttpServletResponse response, WikiNode wikiNode, TrashHelper trashHelper) {
        this._request = request;
        this._wikiNode = wikiNode;
        this._trashHelper = trashHelper;
        this._wikiRequestHelper = new WikiRequestHelper(request);
    }

    public String getEmptyResultsMessage() {
        String keywords = ParamUtil.getString((HttpServletRequest)this._request, (String)"keywords");
        if (Validator.isNotNull((String)keywords)) {
            return LanguageUtil.format((HttpServletRequest)this._request, (String)"no-pages-were-found-that-matched-the-keywords-x", (Object)("<strong>" + HtmlUtil.escape((String)keywords) + "</strong>"), (boolean)false);
        }
        String navigation = ParamUtil.getString((HttpServletRequest)this._request, (String)"navigation");
        if (navigation.equals("categorized-pages")) {
            return "there-are-no-pages-with-this-category";
        }
        if (navigation.equals("draft-pages")) {
            return "there-are-no-drafts";
        }
        if (navigation.equals("frontpage")) {
            WikiWebComponentProvider wikiWebComponentProvider = WikiWebComponentProvider.getWikiWebComponentProvider();
            WikiGroupServiceConfiguration wikiGroupServiceConfiguration = wikiWebComponentProvider.getWikiGroupServiceConfiguration();
            return LanguageUtil.format((HttpServletRequest)this._request, (String)"there-is-no-x", (Object[])new String[]{wikiGroupServiceConfiguration.frontPageName()}, (boolean)false);
        }
        if (navigation.equals("incoming-links")) {
            return "there-are-no-pages-that-link-to-this-page";
        }
        if (navigation.equals("orphan-pages")) {
            return "there-are-no-orphan-pages";
        }
        if (navigation.equals("outgoing-links")) {
            return "this-page-has-no-links";
        }
        if (navigation.equals("pending-pages")) {
            return "there-are-no-pages-submitted-by-you-pending-approval";
        }
        if (navigation.equals("recent-changes")) {
            return "there-are-no-recent-changes";
        }
        if (navigation.equals("tagged-pages")) {
            return "there-are-no-pages-with-this-tag";
        }
        return "there-are-no-pages";
    }

    public Menu getMenu(WikiPage wikiPage) throws PortalException {
        Menu menu = new Menu();
        menu.setDirection("left-side");
        menu.setMarkupView("lexicon");
        menu.setScroll(false);
        ArrayList<MenuItem> menuItems = new ArrayList<MenuItem>();
        this.addEditMenuItem(menuItems, wikiPage);
        this.addPermissionsMenuItem(menuItems, wikiPage);
        this.addCopyMenuItem(menuItems, wikiPage);
        this.addMoveMenuItem(menuItems, wikiPage);
        this.addChildPageMenuItem(menuItems, wikiPage);
        this.addSubscriptionMenuItem(menuItems, wikiPage);
        this.addPrintPageMenuItem(menuItems, wikiPage);
        this.addDeleteMenuItem(menuItems, wikiPage);
        menu.setMenuItems(menuItems);
        return menu;
    }

    public UUID getUuid() {
        return _UUID;
    }

    public void populateResultsAndTotal(SearchContainer searchContainer) throws PortalException {
        WikiPage page = (WikiPage)this._request.getAttribute("WIKI_PAGE");
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String navigation = ParamUtil.getString((HttpServletRequest)this._request, (String)"navigation", (String)"all-pages");
        String keywords = ParamUtil.getString((HttpServletRequest)this._request, (String)"keywords");
        int total = 0;
        List<WikiPage> results = new ArrayList<WikiPage>();
        if (Validator.isNotNull((String)keywords)) {
            Indexer indexer = IndexerRegistryUtil.getIndexer(WikiPage.class);
            SearchContext searchContext = SearchContextFactory.getInstance((HttpServletRequest)this._request);
            searchContext.setAttribute("paginationType", (Serializable)((Object)"more"));
            searchContext.setEnd(searchContainer.getEnd());
            searchContext.setIncludeAttachments(true);
            searchContext.setIncludeDiscussions(true);
            searchContext.setKeywords(keywords);
            searchContext.setNodeIds(new long[]{this._wikiNode.getNodeId()});
            searchContext.setStart(searchContainer.getStart());
            Hits hits = indexer.search(searchContext);
            searchContainer.setTotal(hits.getLength());
            List searchResults = SearchResultUtil.getSearchResults((Hits)hits, (Locale)themeDisplay.getLocale());
            for (SearchResult searchResult : searchResults) {
                WikiPage wikiPage = WikiPageLocalServiceUtil.getPage((long)searchResult.getClassPK());
                results.add(wikiPage);
            }
        } else if (navigation.equals("all-pages")) {
            total = WikiPageServiceUtil.getPagesCount((long)themeDisplay.getScopeGroupId(), (long)this._wikiNode.getNodeId(), (boolean)true, (long)themeDisplay.getUserId(), (boolean)true, (int)0);
            searchContainer.setTotal(total);
            OrderByComparator<WikiPage> obc = WikiPortletUtil.getPageOrderByComparator(searchContainer.getOrderByCol(), searchContainer.getOrderByType());
            List pages = WikiPageServiceUtil.getPages((long)themeDisplay.getScopeGroupId(), (long)this._wikiNode.getNodeId(), (boolean)true, (long)themeDisplay.getUserId(), (boolean)true, (int)0, (int)searchContainer.getStart(), (int)searchContainer.getEnd(), obc);
            PermissionChecker permissionChecker = this._wikiRequestHelper.getPermissionChecker();
            results = new ArrayList(results.size());
            Iterator searchResults = pages.iterator();
            while (searchResults.hasNext()) {
                WikiPage curPage;
                WikiPage resultPage = curPage = (WikiPage)searchResults.next();
                if (permissionChecker.isContentReviewer(this._wikiRequestHelper.getCompanyId(), this._wikiRequestHelper.getScopeGroupId()) || WikiPagePermission.contains(permissionChecker, curPage, "UPDATE")) {
                    WikiPage lastPage;
                    block28: {
                        lastPage = null;
                        try {
                            lastPage = WikiPageLocalServiceUtil.getPage((long)curPage.getResourcePrimKey(), (Boolean)false);
                        }
                        catch (PortalException pe) {
                            if (!_log.isDebugEnabled()) break block28;
                            _log.debug((Object)pe, (Throwable)pe);
                        }
                    }
                    if (lastPage != null && curPage.getVersion() < lastPage.getVersion()) {
                        resultPage = lastPage;
                    }
                }
                results.add(resultPage);
            }
        } else if (navigation.equals("categorized-pages") || navigation.equals("tagged-pages")) {
            AssetEntryQuery assetEntryQuery = new AssetEntryQuery(WikiPage.class.getName(), searchContainer);
            assetEntryQuery.setEnablePermissions(true);
            total = AssetEntryServiceUtil.getEntriesCount((AssetEntryQuery)assetEntryQuery);
            searchContainer.setTotal(total);
            assetEntryQuery.setEnd(searchContainer.getEnd());
            assetEntryQuery.setStart(searchContainer.getStart());
            List assetEntries = AssetEntryServiceUtil.getEntries((AssetEntryQuery)assetEntryQuery);
            for (AssetEntry assetEntry : assetEntries) {
                WikiPageResource pageResource = WikiPageResourceLocalServiceUtil.getPageResource((long)assetEntry.getClassPK());
                WikiPage assetPage = WikiPageLocalServiceUtil.getPage((long)pageResource.getNodeId(), (String)pageResource.getTitle());
                results.add(assetPage);
            }
        } else if (navigation.equals("draft-pages") || navigation.equals("pending-pages")) {
            long draftUserId = themeDisplay.getUserId();
            PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
            if (permissionChecker.isContentReviewer(themeDisplay.getCompanyId(), themeDisplay.getScopeGroupId())) {
                draftUserId = 0L;
            }
            int status = 2;
            if (navigation.equals("pending-pages")) {
                status = 1;
            }
            total = WikiPageServiceUtil.getPagesCount((long)themeDisplay.getScopeGroupId(), (long)draftUserId, (long)this._wikiNode.getNodeId(), (int)status);
            searchContainer.setTotal(total);
            results = WikiPageServiceUtil.getPages((long)themeDisplay.getScopeGroupId(), (long)draftUserId, (long)this._wikiNode.getNodeId(), (int)status, (int)searchContainer.getStart(), (int)searchContainer.getEnd());
        } else if (navigation.equals("frontpage")) {
            WikiWebComponentProvider wikiWebComponentProvider = WikiWebComponentProvider.getWikiWebComponentProvider();
            WikiGroupServiceConfiguration wikiGroupServiceConfiguration = wikiWebComponentProvider.getWikiGroupServiceConfiguration();
            WikiPage wikiPage = WikiPageServiceUtil.getPage((long)themeDisplay.getScopeGroupId(), (long)this._wikiNode.getNodeId(), (String)wikiGroupServiceConfiguration.frontPageName());
            searchContainer.setTotal(1);
            results.add(wikiPage);
        } else if (navigation.equals("history")) {
            total = WikiPageLocalServiceUtil.getPagesCount((long)page.getNodeId(), (String)page.getTitle());
            searchContainer.setTotal(total);
            results = WikiPageLocalServiceUtil.getPages((long)page.getNodeId(), (String)page.getTitle(), (int)-1, (int)-1, (OrderByComparator)new PageVersionComparator());
        } else if (navigation.equals("incoming-links")) {
            List links = WikiPageLocalServiceUtil.getIncomingLinks((long)page.getNodeId(), (String)page.getTitle());
            total = links.size();
            searchContainer.setTotal(total);
            results = ListUtil.subList((List)links, (int)searchContainer.getStart(), (int)searchContainer.getEnd());
        } else if (navigation.equals("orphan-pages")) {
            List orphans = WikiPageServiceUtil.getOrphans((WikiNode)this._wikiNode);
            total = orphans.size();
            searchContainer.setTotal(total);
            results = ListUtil.subList((List)orphans, (int)searchContainer.getStart(), (int)searchContainer.getEnd());
        } else if (navigation.equals("outgoing-links")) {
            List links = WikiPageLocalServiceUtil.getOutgoingLinks((long)page.getNodeId(), (String)page.getTitle());
            total = links.size();
            searchContainer.setTotal(total);
            results = ListUtil.subList((List)links, (int)searchContainer.getStart(), (int)searchContainer.getEnd());
        } else if (navigation.equals("recent-changes")) {
            total = WikiPageServiceUtil.getRecentChangesCount((long)themeDisplay.getScopeGroupId(), (long)this._wikiNode.getNodeId());
            searchContainer.setTotal(total);
            results = WikiPageServiceUtil.getRecentChanges((long)themeDisplay.getScopeGroupId(), (long)this._wikiNode.getNodeId(), (int)searchContainer.getStart(), (int)searchContainer.getEnd());
        }
        searchContainer.setResults(results);
    }

    protected void addChildPageMenuItem(List<MenuItem> menuItems, WikiPage wikiPage) throws PortalException {
        if (Validator.isNull((String)wikiPage.getContent()) || !WikiNodePermission.contains(this._wikiRequestHelper.getPermissionChecker(), wikiPage.getNodeId(), "ADD_PAGE")) {
            return;
        }
        URLMenuItem urlMenuItem = new URLMenuItem();
        urlMenuItem.setKey(WikiUIItemKeys.ADD_CHILD_PAGE);
        urlMenuItem.setLabel("add-child-page");
        LiferayPortletResponse liferayPortletResponse = this._wikiRequestHelper.getLiferayPortletResponse();
        PortletURL portletURL = liferayPortletResponse.createRenderURL();
        portletURL.setParameter("mvcRenderCommandName", "/wiki/edit_page");
        portletURL.setParameter("redirect", this._wikiRequestHelper.getCurrentURL());
        portletURL.setParameter("nodeId", String.valueOf(wikiPage.getNodeId()));
        portletURL.setParameter("title", "");
        portletURL.setParameter("editTitle", "1");
        portletURL.setParameter("parentTitle", wikiPage.getTitle());
        urlMenuItem.setURL(portletURL.toString());
        menuItems.add((MenuItem)urlMenuItem);
    }

    protected void addCopyMenuItem(List<MenuItem> menuItems, WikiPage wikiPage) throws PortalException {
        if (!this.isCopyPasteEnabled(wikiPage)) {
            return;
        }
        URLMenuItem urlMenuItem = new URLMenuItem();
        urlMenuItem.setKey(WikiUIItemKeys.COPY);
        urlMenuItem.setLabel("copy");
        LiferayPortletResponse liferayPortletResponse = this._wikiRequestHelper.getLiferayPortletResponse();
        PortletURL portletURL = liferayPortletResponse.createRenderURL();
        portletURL.setParameter("mvcRenderCommandName", "/wiki/edit_page");
        portletURL.setParameter("redirect", this._wikiRequestHelper.getCurrentURL());
        portletURL.setParameter("nodeId", String.valueOf(wikiPage.getNodeId()));
        portletURL.setParameter("title", "");
        portletURL.setParameter("editTitle", "1");
        portletURL.setParameter("templateNodeId", String.valueOf(wikiPage.getNodeId()));
        portletURL.setParameter("templateTitle", HtmlUtil.unescape((String)wikiPage.getTitle()));
        urlMenuItem.setURL(portletURL.toString());
        menuItems.add((MenuItem)urlMenuItem);
    }

    protected void addDeleteMenuItem(List<MenuItem> menuItems, WikiPage wikiPage) throws PortalException {
        PortletURL portletURL;
        LiferayPortletResponse liferayPortletResponse;
        if (!wikiPage.isDraft() && WikiPagePermission.contains(this._wikiRequestHelper.getPermissionChecker(), wikiPage, "DELETE")) {
            DeleteMenuItem deleteMenuItem = new DeleteMenuItem();
            deleteMenuItem.setKey(WikiUIItemKeys.DELETE);
            deleteMenuItem.setTrash(this._trashHelper.isTrashEnabled(this._wikiRequestHelper.getScopeGroupId()));
            liferayPortletResponse = this._wikiRequestHelper.getLiferayPortletResponse();
            portletURL = liferayPortletResponse.createActionURL();
            portletURL.setParameter("javax.portlet.action", "/wiki/edit_page");
            String cmd = "delete";
            if (this._trashHelper.isTrashEnabled(this._wikiRequestHelper.getScopeGroupId())) {
                cmd = "move_to_trash";
            }
            portletURL.setParameter("cmd", cmd);
            portletURL.setParameter("redirect", this._wikiRequestHelper.getCurrentURL());
            portletURL.setParameter("nodeId", String.valueOf(wikiPage.getNodeId()));
            portletURL.setParameter("title", HtmlUtil.unescape((String)wikiPage.getTitle()));
            deleteMenuItem.setURL(portletURL.toString());
            menuItems.add((MenuItem)deleteMenuItem);
        }
        if (wikiPage.isDraft() && WikiPagePermission.contains(this._wikiRequestHelper.getPermissionChecker(), wikiPage, "DELETE")) {
            URLMenuItem urlMenuItem = new URLMenuItem();
            urlMenuItem.setKey(WikiUIItemKeys.DELETE);
            urlMenuItem.setLabel("discard-draft");
            liferayPortletResponse = this._wikiRequestHelper.getLiferayPortletResponse();
            portletURL = liferayPortletResponse.createActionURL();
            portletURL.setParameter("javax.portlet.action", "/wiki/edit_page");
            portletURL.setParameter("cmd", "delete");
            portletURL.setParameter("redirect", this._wikiRequestHelper.getCurrentURL());
            portletURL.setParameter("nodeId", String.valueOf(wikiPage.getNodeId()));
            portletURL.setParameter("title", HtmlUtil.unescape((String)wikiPage.getTitle()));
            portletURL.setParameter("version", String.valueOf(wikiPage.getVersion()));
            urlMenuItem.setURL(portletURL.toString());
            menuItems.add((MenuItem)urlMenuItem);
        }
    }

    protected void addEditMenuItem(List<MenuItem> menuItems, WikiPage wikiPage) throws PortalException {
        if (!WikiPagePermission.contains(this._wikiRequestHelper.getPermissionChecker(), wikiPage, "UPDATE")) {
            return;
        }
        URLMenuItem urlMenuItem = new URLMenuItem();
        urlMenuItem.setKey(WikiUIItemKeys.EDIT);
        urlMenuItem.setLabel("edit");
        LiferayPortletResponse liferayPortletResponse = this._wikiRequestHelper.getLiferayPortletResponse();
        PortletURL portletURL = liferayPortletResponse.createRenderURL();
        portletURL.setParameter("mvcRenderCommandName", "/wiki/edit_page");
        portletURL.setParameter("nodeId", String.valueOf(wikiPage.getNodeId()));
        portletURL.setParameter("title", HtmlUtil.unescape((String)wikiPage.getTitle()));
        urlMenuItem.setURL(portletURL.toString());
        menuItems.add((MenuItem)urlMenuItem);
    }

    protected void addMoveMenuItem(List<MenuItem> menuItems, WikiPage wikiPage) throws PortalException {
        if (!this.isCopyPasteEnabled(wikiPage)) {
            return;
        }
        URLMenuItem urlMenuItem = new URLMenuItem();
        urlMenuItem.setKey(WikiUIItemKeys.MOVE);
        urlMenuItem.setLabel("move");
        LiferayPortletResponse liferayPortletResponse = this._wikiRequestHelper.getLiferayPortletResponse();
        PortletURL portletURL = liferayPortletResponse.createRenderURL();
        portletURL.setParameter("mvcRenderCommandName", "/wiki/move_page");
        portletURL.setParameter("redirect", this._wikiRequestHelper.getCurrentURL());
        portletURL.setParameter("nodeId", String.valueOf(wikiPage.getNodeId()));
        portletURL.setParameter("title", HtmlUtil.unescape((String)wikiPage.getTitle()));
        urlMenuItem.setURL(portletURL.toString());
        menuItems.add((MenuItem)urlMenuItem);
    }

    protected void addPermissionsMenuItem(List<MenuItem> menuItems, WikiPage wikiPage) throws PortalException {
        if (!WikiPagePermission.contains(this._wikiRequestHelper.getPermissionChecker(), wikiPage, "PERMISSIONS")) {
            return;
        }
        URLMenuItem urlMenuItem = new URLMenuItem();
        urlMenuItem.setKey(WikiUIItemKeys.PERMISSIONS);
        urlMenuItem.setLabel("permissions");
        urlMenuItem.setMethod("get");
        urlMenuItem.setUseDialog(true);
        String url = null;
        try {
            url = PermissionsURLTag.doTag(null, (String)WikiPage.class.getName(), (String)wikiPage.getTitle(), null, (String)String.valueOf(wikiPage.getResourcePrimKey()), (String)LiferayWindowState.POP_UP.toString(), null, (HttpServletRequest)this._request);
        }
        catch (Exception e) {
            throw new SystemException("Unable to create permissions URL", (Throwable)e);
        }
        urlMenuItem.setURL(url);
        menuItems.add((MenuItem)urlMenuItem);
    }

    protected void addPrintPageMenuItem(List<MenuItem> menuItems, WikiPage wikiPage) throws PortalException {
        try {
            JavaScriptMenuItem javaScriptMenuItem = new JavaScriptMenuItem();
            javaScriptMenuItem.setKey(WikiUIItemKeys.PRINT);
            javaScriptMenuItem.setLabel("print");
            StringBundler sb = new StringBundler(5);
            sb.append("window.open('");
            LiferayPortletResponse liferayPortletResponse = this._wikiRequestHelper.getLiferayPortletResponse();
            PortletURL portletURL = liferayPortletResponse.createRenderURL();
            WikiNode wikiNode = wikiPage.getNode();
            portletURL.setParameter("mvcRenderCommandName", "/wiki/view");
            portletURL.setParameter("nodeName", wikiNode.getName());
            portletURL.setParameter("title", wikiPage.getTitle());
            portletURL.setParameter("viewMode", "print");
            portletURL.setWindowState(LiferayWindowState.POP_UP);
            sb.append(portletURL.toString());
            sb.append("', '', 'directories=0,height=480,left=80,location=1,");
            sb.append("menubar=1,resizable=1,scrollbars=yes,status=0,");
            sb.append("toolbar=0,top=180,width=640');");
            javaScriptMenuItem.setOnClick(sb.toString());
            menuItems.add((MenuItem)javaScriptMenuItem);
        }
        catch (WindowStateException windowStateException) {
            // empty catch block
        }
    }

    protected void addSubscriptionMenuItem(List<MenuItem> menuItems, WikiPage wikiPage) throws PortalException {
        ResultRow row = (ResultRow)this._request.getAttribute("SEARCH_CONTAINER_RESULT_ROW");
        if (row == null) {
            return;
        }
        WikiGroupServiceOverriddenConfiguration wikiGroupServiceOverriddenConfiguration = this._wikiRequestHelper.getWikiGroupServiceOverriddenConfiguration();
        if (!WikiPagePermission.contains(this._wikiRequestHelper.getPermissionChecker(), wikiPage, "SUBSCRIBE") || !wikiGroupServiceOverriddenConfiguration.emailPageAddedEnabled() && !wikiGroupServiceOverriddenConfiguration.emailPageUpdatedEnabled()) {
            return;
        }
        User user = this._wikiRequestHelper.getUser();
        if (SubscriptionLocalServiceUtil.isSubscribed((long)user.getCompanyId(), (long)user.getUserId(), (String)WikiPage.class.getName(), (long)wikiPage.getResourcePrimKey())) {
            URLMenuItem urlMenuItem = new URLMenuItem();
            urlMenuItem.setKey(WikiUIItemKeys.UNSUBSCRIBE);
            urlMenuItem.setLabel("unsubscribe");
            LiferayPortletResponse liferayPortletResponse = this._wikiRequestHelper.getLiferayPortletResponse();
            PortletURL portletURL = liferayPortletResponse.createActionURL();
            portletURL.setParameter("javax.portlet.action", "/wiki/edit_page");
            portletURL.setParameter("cmd", "unsubscribe");
            portletURL.setParameter("redirect", this._wikiRequestHelper.getCurrentURL());
            portletURL.setParameter("nodeId", String.valueOf(wikiPage.getNodeId()));
            portletURL.setParameter("title", HtmlUtil.unescape((String)wikiPage.getTitle()));
            urlMenuItem.setURL(portletURL.toString());
            menuItems.add((MenuItem)urlMenuItem);
        } else {
            URLMenuItem urlMenuItem = new URLMenuItem();
            urlMenuItem.setKey(WikiUIItemKeys.SUBSCRIBE);
            urlMenuItem.setLabel("subscribe");
            LiferayPortletResponse liferayPortletResponse = this._wikiRequestHelper.getLiferayPortletResponse();
            PortletURL portletURL = liferayPortletResponse.createActionURL();
            portletURL.setParameter("javax.portlet.action", "/wiki/edit_page");
            portletURL.setParameter("cmd", "subscribe");
            portletURL.setParameter("redirect", this._wikiRequestHelper.getCurrentURL());
            portletURL.setParameter("nodeId", String.valueOf(wikiPage.getNodeId()));
            portletURL.setParameter("title", HtmlUtil.unescape((String)wikiPage.getTitle()));
            urlMenuItem.setURL(portletURL.toString());
            menuItems.add((MenuItem)urlMenuItem);
        }
    }

    protected boolean isCopyPasteEnabled(WikiPage wikiPage) throws PortalException {
        if (!WikiPagePermission.contains(this._wikiRequestHelper.getPermissionChecker(), wikiPage, "UPDATE")) {
            return false;
        }
        return WikiNodePermission.contains(this._wikiRequestHelper.getPermissionChecker(), wikiPage.getNodeId(), "ADD_PAGE");
    }
}

