/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.web.internal.asset;

import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.model.BaseAssetRendererFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.trash.TrashHelper;
import com.liferay.wiki.engine.WikiEngineRenderer;
import com.liferay.wiki.exception.NoSuchPageException;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.service.WikiPageLocalService;
import com.liferay.wiki.service.WikiPageResourceLocalService;
import com.liferay.wiki.web.internal.asset.WikiPageAssetRenderer;
import com.liferay.wiki.web.internal.security.permission.resource.WikiPagePermission;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import javax.servlet.ServletContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_wiki_web_portlet_WikiPortlet"}, service={AssetRendererFactory.class})
public class WikiPageAssetRendererFactory
extends BaseAssetRendererFactory<WikiPage> {
    public static final String TYPE = "wiki";
    private ServletContext _servletContext;
    @Reference
    private TrashHelper _trashHelper;
    private WikiEngineRenderer _wikiEngineRenderer;
    private WikiPageLocalService _wikiPageLocalService;
    private WikiPageResourceLocalService _wikiPageResourceLocalService;

    public WikiPageAssetRendererFactory() {
        this.setClassName(WikiPage.class.getName());
        this.setLinkable(true);
        this.setPortletId("com_liferay_wiki_web_portlet_WikiPortlet");
        this.setSearchable(true);
    }

    public AssetRenderer<WikiPage> getAssetRenderer(long classPK, int type) throws PortalException {
        WikiPage page = this._wikiPageLocalService.fetchWikiPage(classPK);
        if (page == null) {
            if (type == 1) {
                try {
                    page = this._wikiPageLocalService.getPage(classPK, Boolean.TRUE);
                }
                catch (NoSuchPageException nspe) {
                    page = this._wikiPageLocalService.getPage(classPK, (Boolean)null);
                }
            } else if (type == 0) {
                page = this._wikiPageLocalService.getPage(classPK, (Boolean)null);
            } else {
                throw new IllegalArgumentException("Unknown asset renderer type " + type);
            }
        }
        WikiPageAssetRenderer wikiPageAssetRenderer = new WikiPageAssetRenderer(page, this._wikiEngineRenderer, this._trashHelper);
        wikiPageAssetRenderer.setAssetRendererType(type);
        wikiPageAssetRenderer.setServletContext(this._servletContext);
        return wikiPageAssetRenderer;
    }

    public String getClassName() {
        return WikiPage.class.getName();
    }

    public String getIconCssClass() {
        return TYPE;
    }

    public String getType() {
        return TYPE;
    }

    public PortletURL getURLView(LiferayPortletResponse liferayPortletResponse, WindowState windowState) {
        LiferayPortletURL liferayPortletURL = liferayPortletResponse.createLiferayPortletURL("com_liferay_wiki_web_portlet_WikiPortlet", "RENDER_PHASE");
        try {
            liferayPortletURL.setWindowState(windowState);
        }
        catch (WindowStateException windowStateException) {
            // empty catch block
        }
        return liferayPortletURL;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws Exception {
        return WikiPagePermission.contains(permissionChecker, classPK, actionId);
    }

    @Reference(target="(osgi.web.symbolicname=com.liferay.wiki.web)", unbind="-")
    public void setServletContext(ServletContext servletContext) {
        this._servletContext = servletContext;
    }

    @Reference(unbind="-")
    protected void setWikiEngineRenderer(WikiEngineRenderer wikiEngineRenderer) {
        this._wikiEngineRenderer = wikiEngineRenderer;
    }

    @Reference(unbind="-")
    protected void setWikiPageLocalService(WikiPageLocalService wikiPageLocalService) {
        this._wikiPageLocalService = wikiPageLocalService;
    }

    @Reference(unbind="-")
    protected void setWikiPageResourceLocalService(WikiPageResourceLocalService wikiPageResourceLocalService) {
        this._wikiPageResourceLocalService = wikiPageResourceLocalService;
    }
}

