/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.web.internal;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.TrashedModel;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.trash.service.TrashEntryService;
import com.liferay.wiki.service.WikiPageService;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.portlet.ActionRequest;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={WikiAttachmentsHelper.class})
public class WikiAttachmentsHelper {
    private static final Log _log = LogFactoryUtil.getLog(WikiAttachmentsHelper.class);
    @Reference
    private Portal _portal;
    private TrashEntryService _trashEntryService;
    private WikiPageService _wikiPageService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAttachments(ActionRequest actionRequest) throws Exception {
        InputStream inputStream;
        UploadPortletRequest uploadPortletRequest = this._portal.getUploadPortletRequest((PortletRequest)actionRequest);
        long nodeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"nodeId");
        String title = ParamUtil.getString((PortletRequest)actionRequest, (String)"title");
        int numOfFiles = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"numOfFiles");
        ArrayList<ObjectValuePair> inputStreamOVPs = new ArrayList<ObjectValuePair>();
        try {
            String fileName;
            if (numOfFiles == 0) {
                InputStream inputStream2 = uploadPortletRequest.getFileAsStream("file");
                if (inputStream2 != null) {
                    fileName = uploadPortletRequest.getFileName("file");
                    ObjectValuePair inputStreamOVP = new ObjectValuePair((Object)fileName, (Object)inputStream2);
                    inputStreamOVPs.add(inputStreamOVP);
                }
            } else {
                for (int i = 1; i <= numOfFiles; ++i) {
                    fileName = uploadPortletRequest.getFileName("file" + i);
                    inputStream = uploadPortletRequest.getFileAsStream("file" + i);
                    if (inputStream == null) continue;
                    ObjectValuePair inputStreamOVP = new ObjectValuePair((Object)fileName, (Object)inputStream);
                    inputStreamOVPs.add(inputStreamOVP);
                }
            }
            if (ListUtil.isNotEmpty(inputStreamOVPs)) {
                this._wikiPageService.addPageAttachments(nodeId, title, inputStreamOVPs);
            }
        }
        finally {
            for (ObjectValuePair inputStreamOVP : inputStreamOVPs) {
                try {
                    inputStream = (InputStream)inputStreamOVP.getValue();
                    Throwable throwable = null;
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        continue;
                    }
                    inputStream.close();
                }
                catch (IOException ioe) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)ioe, (Throwable)ioe);
                }
            }
        }
    }

    public TrashedModel deleteAttachment(ActionRequest actionRequest, boolean moveToTrash) throws Exception {
        long nodeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"nodeId");
        String title = ParamUtil.getString((PortletRequest)actionRequest, (String)"title");
        String attachment = ParamUtil.getString((PortletRequest)actionRequest, (String)"fileName");
        DLFileEntry trashedModel = null;
        if (moveToTrash) {
            FileEntry fileEntry = this._wikiPageService.movePageAttachmentToTrash(nodeId, title, attachment);
            if (fileEntry.getModel() instanceof DLFileEntry) {
                trashedModel = (DLFileEntry)fileEntry.getModel();
            }
        } else {
            this._wikiPageService.deletePageAttachment(nodeId, title, attachment);
        }
        return trashedModel;
    }

    public void emptyTrash(ActionRequest actionRequest) throws Exception {
        long nodeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"nodeId");
        String title = ParamUtil.getString((PortletRequest)actionRequest, (String)"title");
        this._wikiPageService.deleteTrashPageAttachments(nodeId, title);
    }

    public void restoreEntries(ActionRequest actionRequest) throws Exception {
        long nodeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"nodeId");
        String title = ParamUtil.getString((PortletRequest)actionRequest, (String)"title");
        String fileName = ParamUtil.getString((PortletRequest)actionRequest, (String)"fileName");
        this._wikiPageService.restorePageAttachmentFromTrash(nodeId, title, fileName);
    }

    @Reference(unbind="-")
    protected void setTrashEntryService(TrashEntryService trashEntryService) {
        this._trashEntryService = trashEntryService;
    }

    @Reference(unbind="-")
    protected void setWikiPageService(WikiPageService wikiPageService) {
        this._wikiPageService = wikiPageService;
    }
}

