/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jrcs.diff;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.jrcs.diff.Delta;
import org.apache.commons.jrcs.diff.Diff;
import org.apache.commons.jrcs.diff.PatchFailedException;
import org.apache.commons.jrcs.diff.RevisionVisitor;
import org.apache.commons.jrcs.util.ToString;

public class Revision
extends ToString {
    List deltas_ = new LinkedList();

    public synchronized void addDelta(Delta delta) {
        if (delta == null) {
            throw new IllegalArgumentException("new delta is null");
        }
        this.deltas_.add(delta);
    }

    public synchronized void insertDelta(Delta delta) {
        if (delta == null) {
            throw new IllegalArgumentException("new delta is null");
        }
        this.deltas_.add(0, delta);
    }

    public Delta getDelta(int i2) {
        return (Delta)this.deltas_.get(i2);
    }

    public int size() {
        return this.deltas_.size();
    }

    public Object[] patch(Object[] src) throws PatchFailedException {
        ArrayList<Object> target = new ArrayList<Object>(Arrays.asList(src));
        this.applyTo(target);
        return target.toArray();
    }

    public synchronized void applyTo(List target) throws PatchFailedException {
        ListIterator i2 = this.deltas_.listIterator(this.deltas_.size());
        while (i2.hasPrevious()) {
            Delta delta = (Delta)i2.previous();
            delta.patch(target);
        }
    }

    public synchronized void toString(StringBuffer s2) {
        Iterator i2 = this.deltas_.iterator();
        while (i2.hasNext()) {
            ((Delta)i2.next()).toString(s2);
        }
    }

    public synchronized void toRCSString(StringBuffer s2, String EOL) {
        Iterator i2 = this.deltas_.iterator();
        while (i2.hasNext()) {
            ((Delta)i2.next()).toRCSString(s2, EOL);
        }
    }

    public void toRCSString(StringBuffer s2) {
        this.toRCSString(s2, Diff.NL);
    }

    public String toRCSString(String EOL) {
        StringBuffer s2 = new StringBuffer();
        this.toRCSString(s2, EOL);
        return s2.toString();
    }

    public String toRCSString() {
        return this.toRCSString(Diff.NL);
    }

    public void accept(RevisionVisitor visitor) {
        visitor.visit(this);
        Iterator iter = this.deltas_.iterator();
        while (iter.hasNext()) {
            ((Delta)iter.next()).accept(visitor);
        }
    }
}

