/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jrcs.diff;

import java.util.List;
import org.apache.commons.jrcs.diff.Chunk;
import org.apache.commons.jrcs.diff.Diff;
import org.apache.commons.jrcs.diff.PatchFailedException;
import org.apache.commons.jrcs.diff.RevisionVisitor;
import org.apache.commons.jrcs.util.ToString;

public abstract class Delta
extends ToString {
    protected Chunk original;
    protected Chunk revised;
    static Class[][] DeltaClass = new Class[2][2];
    static /* synthetic */ Class class$org$apache$commons$jrcs$diff$ChangeDelta;
    static /* synthetic */ Class class$org$apache$commons$jrcs$diff$AddDelta;
    static /* synthetic */ Class class$org$apache$commons$jrcs$diff$DeleteDelta;

    public static Delta newDelta(Chunk orig, Chunk rev) {
        Delta result;
        Class c = DeltaClass[orig.size() > 0 ? 1 : 0][rev.size() > 0 ? 1 : 0];
        try {
            result = (Delta)c.newInstance();
        }
        catch (Throwable e) {
            return null;
        }
        result.init(orig, rev);
        return result;
    }

    protected Delta() {
    }

    protected Delta(Chunk orig, Chunk rev) {
        this.init(orig, rev);
    }

    protected void init(Chunk orig, Chunk rev) {
        this.original = orig;
        this.revised = rev;
    }

    public abstract void verify(List var1) throws PatchFailedException;

    public final void patch(List target) throws PatchFailedException {
        this.verify(target);
        try {
            this.applyTo(target);
        }
        catch (Exception e) {
            throw new PatchFailedException(e.getMessage());
        }
    }

    public abstract void applyTo(List var1);

    public void toString(StringBuffer s2) {
        this.original.rangeString(s2);
        s2.append("x");
        this.revised.rangeString(s2);
        s2.append(Diff.NL);
        this.original.toString(s2, "> ", "\n");
        s2.append("---");
        s2.append(Diff.NL);
        this.revised.toString(s2, "< ", "\n");
    }

    public abstract void toRCSString(StringBuffer var1, String var2);

    public String toRCSString(String EOL) {
        StringBuffer s2 = new StringBuffer();
        this.toRCSString(s2, EOL);
        return s2.toString();
    }

    public Chunk getOriginal() {
        return this.original;
    }

    public Chunk getRevised() {
        return this.revised;
    }

    public abstract void accept(RevisionVisitor var1);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            Delta.DeltaClass[0][0] = class$org$apache$commons$jrcs$diff$ChangeDelta == null ? (class$org$apache$commons$jrcs$diff$ChangeDelta = Delta.class$("org.apache.commons.jrcs.diff.ChangeDelta")) : class$org$apache$commons$jrcs$diff$ChangeDelta;
            Delta.DeltaClass[0][1] = class$org$apache$commons$jrcs$diff$AddDelta == null ? (class$org$apache$commons$jrcs$diff$AddDelta = Delta.class$("org.apache.commons.jrcs.diff.AddDelta")) : class$org$apache$commons$jrcs$diff$AddDelta;
            Delta.DeltaClass[1][0] = class$org$apache$commons$jrcs$diff$DeleteDelta == null ? (class$org$apache$commons$jrcs$diff$DeleteDelta = Delta.class$("org.apache.commons.jrcs.diff.DeleteDelta")) : class$org$apache$commons$jrcs$diff$DeleteDelta;
            Delta.DeltaClass[1][1] = class$org$apache$commons$jrcs$diff$ChangeDelta == null ? (class$org$apache$commons$jrcs$diff$ChangeDelta = Delta.class$("org.apache.commons.jrcs.diff.ChangeDelta")) : class$org$apache$commons$jrcs$diff$ChangeDelta;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

