/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.tool;

import antlr.RecognitionException;
import antlr.Token;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.antlr.Tool;
import org.antlr.analysis.DFAState;
import org.antlr.analysis.DecisionProbe;
import org.antlr.misc.BitSet;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateErrorListener;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.language.AngleBracketTemplateLexer;
import org.antlr.tool.ANTLRErrorListener;
import org.antlr.tool.Grammar;
import org.antlr.tool.GrammarAnalysisAbortedMessage;
import org.antlr.tool.GrammarDanglingStateMessage;
import org.antlr.tool.GrammarInsufficientPredicatesMessage;
import org.antlr.tool.GrammarNonDeterminismMessage;
import org.antlr.tool.GrammarSemanticsMessage;
import org.antlr.tool.GrammarSyntaxMessage;
import org.antlr.tool.GrammarUnreachableAltsMessage;
import org.antlr.tool.LeftRecursionCyclesMessage;
import org.antlr.tool.Message;
import org.antlr.tool.NonRegularDecisionMessage;
import org.antlr.tool.RecursionOverflowMessage;
import org.antlr.tool.ToolMessage;

public class ErrorManager {
    public static final int MSG_CANNOT_WRITE_FILE = 1;
    public static final int MSG_CANNOT_CLOSE_FILE = 2;
    public static final int MSG_CANNOT_FIND_TOKENS_FILE = 3;
    public static final int MSG_ERROR_READING_TOKENS_FILE = 4;
    public static final int MSG_DIR_NOT_FOUND = 5;
    public static final int MSG_OUTPUT_DIR_IS_FILE = 6;
    public static final int MSG_CANNOT_OPEN_FILE = 7;
    public static final int MSG_FILE_AND_GRAMMAR_NAME_DIFFER = 8;
    public static final int MSG_FILENAME_EXTENSION_ERROR = 9;
    public static final int MSG_INTERNAL_ERROR = 10;
    public static final int MSG_INTERNAL_WARNING = 11;
    public static final int MSG_ERROR_CREATING_ARTIFICIAL_RULE = 12;
    public static final int MSG_TOKENS_FILE_SYNTAX_ERROR = 13;
    public static final int MSG_CANNOT_GEN_DOT_FILE = 14;
    public static final int MSG_BAD_AST_STRUCTURE = 15;
    public static final int MSG_BAD_ACTION_AST_STRUCTURE = 16;
    public static final int MSG_MISSING_CODE_GEN_TEMPLATES = 20;
    public static final int MSG_MISSING_CYCLIC_DFA_CODE_GEN_TEMPLATES = 21;
    public static final int MSG_CODE_GEN_TEMPLATES_INCOMPLETE = 22;
    public static final int MSG_CANNOT_CREATE_TARGET_GENERATOR = 23;
    public static final int MSG_SYNTAX_ERROR = 100;
    public static final int MSG_RULE_REDEFINITION = 101;
    public static final int MSG_LEXER_RULES_NOT_ALLOWED = 102;
    public static final int MSG_PARSER_RULES_NOT_ALLOWED = 103;
    public static final int MSG_CANNOT_FIND_ATTRIBUTE_NAME_IN_DECL = 104;
    public static final int MSG_NO_TOKEN_DEFINITION = 105;
    public static final int MSG_UNDEFINED_RULE_REF = 106;
    public static final int MSG_LITERAL_NOT_ASSOCIATED_WITH_LEXER_RULE = 107;
    public static final int MSG_CANNOT_ALIAS_TOKENS_IN_LEXER = 108;
    public static final int MSG_ATTRIBUTE_REF_NOT_IN_RULE = 111;
    public static final int MSG_INVALID_RULE_SCOPE_ATTRIBUTE_REF = 112;
    public static final int MSG_UNKNOWN_ATTRIBUTE_IN_SCOPE = 113;
    public static final int MSG_UNKNOWN_SIMPLE_ATTRIBUTE = 114;
    public static final int MSG_INVALID_RULE_PARAMETER_REF = 115;
    public static final int MSG_UNKNOWN_RULE_ATTRIBUTE = 116;
    public static final int MSG_ISOLATED_RULE_SCOPE = 117;
    public static final int MSG_SYMBOL_CONFLICTS_WITH_GLOBAL_SCOPE = 118;
    public static final int MSG_LABEL_CONFLICTS_WITH_RULE = 119;
    public static final int MSG_LABEL_CONFLICTS_WITH_TOKEN = 120;
    public static final int MSG_LABEL_CONFLICTS_WITH_RULE_SCOPE_ATTRIBUTE = 121;
    public static final int MSG_LABEL_CONFLICTS_WITH_RULE_ARG_RETVAL = 122;
    public static final int MSG_ATTRIBUTE_CONFLICTS_WITH_RULE = 123;
    public static final int MSG_ATTRIBUTE_CONFLICTS_WITH_RULE_ARG_RETVAL = 124;
    public static final int MSG_LABEL_TYPE_CONFLICT = 125;
    public static final int MSG_ARG_RETVAL_CONFLICT = 126;
    public static final int MSG_NONUNIQUE_REF = 127;
    public static final int MSG_FORWARD_ELEMENT_REF = 128;
    public static final int MSG_MISSING_RULE_ARGS = 129;
    public static final int MSG_RULE_HAS_NO_ARGS = 130;
    public static final int MSG_ARGS_ON_TOKEN_REF = 131;
    public static final int MSG_AMBIGUOUS_RULE_SCOPE = 132;
    public static final int MSG_ILLEGAL_OPTION = 133;
    public static final int MSG_LIST_LABEL_INVALID_UNLESS_RETVAL_STRUCT = 134;
    public static final int MSG_UNDEFINED_TOKEN_REF_IN_REWRITE = 135;
    public static final int MSG_REWRITE_ELEMENT_NOT_PRESENT_ON_LHS = 136;
    public static final int MSG_UNDEFINED_LABEL_REF_IN_REWRITE = 137;
    public static final int MSG_NO_GRAMMAR_START_RULE = 138;
    public static final int MSG_EMPTY_COMPLEMENT = 139;
    public static final int MSG_UNKNOWN_DYNAMIC_SCOPE = 140;
    public static final int MSG_UNKNOWN_DYNAMIC_SCOPE_ATTRIBUTE = 141;
    public static final int MSG_ISOLATED_RULE_ATTRIBUTE = 142;
    public static final int MSG_INVALID_ACTION_SCOPE = 143;
    public static final int MSG_ACTION_REDEFINITION = 144;
    public static final int MSG_DOUBLE_QUOTES_ILLEGAL = 145;
    public static final int MSG_INVALID_TEMPLATE_ACTION = 146;
    public static final int MSG_MISSING_ATTRIBUTE_NAME = 147;
    public static final int MSG_ARG_INIT_VALUES_ILLEGAL = 148;
    public static final int MSG_REWRITE_OR_OP_WITH_NO_OUTPUT_OPTION = 149;
    public static final int MSG_NO_RULES = 150;
    public static final int MSG_WRITE_TO_READONLY_ATTR = 151;
    public static final int MSG_MISSING_AST_TYPE_IN_TREE_GRAMMAR = 152;
    public static final int MSG_REWRITE_FOR_MULTI_ELEMENT_ALT = 153;
    public static final int MSG_RULE_INVALID_SET = 154;
    public static final int MSG_GRAMMAR_NONDETERMINISM = 200;
    public static final int MSG_UNREACHABLE_ALTS = 201;
    public static final int MSG_DANGLING_STATE = 202;
    public static final int MSG_INSUFFICIENT_PREDICATES = 203;
    public static final int MSG_DUPLICATE_SET_ENTRY = 204;
    public static final int MSG_ANALYSIS_ABORTED = 205;
    public static final int MSG_RECURSION_OVERLOW = 206;
    public static final int MSG_LEFT_RECURSION = 207;
    public static final int MSG_UNREACHABLE_TOKENS = 208;
    public static final int MSG_TOKEN_NONDETERMINISM = 209;
    public static final int MSG_LEFT_RECURSION_CYCLES = 210;
    public static final int MSG_NONREGULAR_DECISION = 211;
    public static final int MAX_MESSAGE_NUMBER = 211;
    public static final BitSet ERRORS_FORCING_NO_ANALYSIS = new BitSet(){
        {
            this.add(101);
            this.add(106);
            this.add(210);
            this.add(149);
            this.add(150);
        }
    };
    public static final BitSet ERRORS_FORCING_NO_CODEGEN = new BitSet(){
        {
            this.add(211);
            this.add(8);
        }
    };
    public static final Map emitSingleError = new HashMap(){
        {
            this.put("danglingState", new HashSet());
        }
    };
    private static Locale locale;
    private static String formatName;
    private static Map threadToListenerMap;
    private static Map threadToErrorCountMap;
    private static Map threadToToolMap;
    private static StringTemplateGroup messages;
    private static StringTemplateGroup format;
    private static String[] idToMessageTemplateName;
    static ANTLRErrorListener theDefaultErrorListener;
    static StringTemplateErrorListener initSTListener;
    static StringTemplateErrorListener blankSTListener;
    static StringTemplateErrorListener theDefaultSTListener;

    public static StringTemplateErrorListener getStringTemplateErrorListener() {
        return theDefaultSTListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLocale(Locale locale) {
        ErrorManager.locale = locale;
        String string = locale.getLanguage();
        String string2 = "org/antlr/tool/templates/messages/languages/" + string + ".stg";
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(string2);
        if (inputStream == null) {
            classLoader = ErrorManager.class.getClassLoader();
            inputStream = classLoader.getResourceAsStream(string2);
        }
        if (inputStream == null && string.equals(Locale.US.getLanguage())) {
            ErrorManager.rawError("ANTLR installation corrupted; cannot find English messages file " + string2);
            ErrorManager.panic();
        } else if (inputStream == null) {
            ErrorManager.setLocale(Locale.US);
            return;
        }
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            messages = new StringTemplateGroup(bufferedReader, AngleBracketTemplateLexer.class, initSTListener);
            bufferedReader.close();
        }
        catch (IOException iOException) {
            ErrorManager.rawError("error reading message file " + string2, iOException);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    ErrorManager.rawError("cannot close message file " + string2, iOException);
                }
            }
        }
        messages.setErrorListener(blankSTListener);
        boolean bl = ErrorManager.verifyMessages();
        if (!bl && string.equals(Locale.US.getLanguage())) {
            ErrorManager.rawError("ANTLR installation corrupted; English messages file " + string + ".stg incomplete");
            ErrorManager.panic();
        } else if (!bl) {
            ErrorManager.setLocale(Locale.US);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setFormat(String string) {
        formatName = string;
        String string2 = "org/antlr/tool/templates/messages/formats/" + string + ".stg";
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(string2);
        if (inputStream == null) {
            classLoader = ErrorManager.class.getClassLoader();
            inputStream = classLoader.getResourceAsStream(string2);
        }
        if (inputStream == null && string.equals("antlr")) {
            ErrorManager.rawError("ANTLR installation corrupted; cannot find ANTLR messages format file " + string2);
            ErrorManager.panic();
        } else if (inputStream == null) {
            ErrorManager.rawError("no such message format file " + string2 + " retrying with default ANTLR format");
            ErrorManager.setFormat("antlr");
            return;
        }
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            format = new StringTemplateGroup(bufferedReader, AngleBracketTemplateLexer.class, initSTListener);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                ErrorManager.rawError("cannot close message format file " + string2, iOException);
            }
        }
        format.setErrorListener(blankSTListener);
        boolean bl = ErrorManager.verifyFormat();
        if (!bl && string.equals("antlr")) {
            ErrorManager.rawError("ANTLR installation corrupted; ANTLR messages format file " + string + ".stg incomplete");
            ErrorManager.panic();
        } else if (!bl) {
            ErrorManager.setFormat("antlr");
        }
    }

    public static void setErrorListener(ANTLRErrorListener aNTLRErrorListener) {
        threadToListenerMap.put(Thread.currentThread(), aNTLRErrorListener);
    }

    public static void setTool(Tool tool) {
        threadToToolMap.put(Thread.currentThread(), tool);
    }

    public static StringTemplate getMessage(int n) {
        String string = idToMessageTemplateName[n];
        return messages.getInstanceOf(string);
    }

    public static String getMessageType(int n) {
        if (ErrorManager.getErrorState().warningMsgIDs.member(n)) {
            return messages.getInstanceOf("warning").toString();
        }
        if (ErrorManager.getErrorState().errorMsgIDs.member(n)) {
            return messages.getInstanceOf("error").toString();
        }
        ErrorManager.assertTrue(false, "Assertion failed! Message ID " + n + " created but is not present in errorMsgIDs or warningMsgIDs.");
        return "";
    }

    public static StringTemplate getLocationFormat() {
        return format.getInstanceOf("location");
    }

    public static StringTemplate getReportFormat() {
        return format.getInstanceOf("report");
    }

    public static StringTemplate getMessageFormat() {
        return format.getInstanceOf("message");
    }

    public static boolean formatWantsSingleLineMessage() {
        return format.getInstanceOf("wantsSingleLineMessage").toString().equals("true");
    }

    public static ANTLRErrorListener getErrorListener() {
        ANTLRErrorListener aNTLRErrorListener = (ANTLRErrorListener)threadToListenerMap.get(Thread.currentThread());
        if (aNTLRErrorListener == null) {
            return theDefaultErrorListener;
        }
        return aNTLRErrorListener;
    }

    public static ErrorState getErrorState() {
        ErrorState errorState = (ErrorState)threadToErrorCountMap.get(Thread.currentThread());
        if (errorState == null) {
            errorState = new ErrorState();
            threadToErrorCountMap.put(Thread.currentThread(), errorState);
        }
        return errorState;
    }

    public static void resetErrorState() {
        ErrorState errorState = new ErrorState();
        threadToErrorCountMap.put(Thread.currentThread(), errorState);
    }

    public static void info(String string) {
        ++ErrorManager.getErrorState().infos;
        ErrorManager.getErrorListener().info(string);
    }

    public static void error(int n) {
        ++ErrorManager.getErrorState().errors;
        ErrorManager.getErrorState().errorMsgIDs.add(n);
        ErrorManager.getErrorListener().error(new ToolMessage(n));
    }

    public static void error(int n, Throwable throwable) {
        ++ErrorManager.getErrorState().errors;
        ErrorManager.getErrorState().errorMsgIDs.add(n);
        ErrorManager.getErrorListener().error(new ToolMessage(n, throwable));
    }

    public static void error(int n, Object object2) {
        ++ErrorManager.getErrorState().errors;
        ErrorManager.getErrorState().errorMsgIDs.add(n);
        ErrorManager.getErrorListener().error(new ToolMessage(n, object2));
    }

    public static void error(int n, Object object2, Object object3) {
        ++ErrorManager.getErrorState().errors;
        ErrorManager.getErrorState().errorMsgIDs.add(n);
        ErrorManager.getErrorListener().error(new ToolMessage(n, object2, object3));
    }

    public static void error(int n, Object object2, Throwable throwable) {
        ++ErrorManager.getErrorState().errors;
        ErrorManager.getErrorState().errorMsgIDs.add(n);
        ErrorManager.getErrorListener().error(new ToolMessage(n, object2, throwable));
    }

    public static void warning(int n, Object object2) {
        ++ErrorManager.getErrorState().warnings;
        ErrorManager.getErrorState().warningMsgIDs.add(n);
        ErrorManager.getErrorListener().warning(new ToolMessage(n, object2));
    }

    public static void nondeterminism(DecisionProbe decisionProbe, DFAState dFAState) {
        ++ErrorManager.getErrorState().warnings;
        GrammarNonDeterminismMessage grammarNonDeterminismMessage = new GrammarNonDeterminismMessage(decisionProbe, dFAState);
        ErrorManager.getErrorState().warningMsgIDs.add(grammarNonDeterminismMessage.msgID);
        ErrorManager.getErrorListener().warning(grammarNonDeterminismMessage);
    }

    public static void danglingState(DecisionProbe decisionProbe, DFAState dFAState) {
        ++ErrorManager.getErrorState().warnings;
        GrammarDanglingStateMessage grammarDanglingStateMessage = new GrammarDanglingStateMessage(decisionProbe, dFAState);
        ErrorManager.getErrorState().warningMsgIDs.add(grammarDanglingStateMessage.msgID);
        Set set = (Set)emitSingleError.get("danglingState");
        if (!set.contains(dFAState.dfa.decisionNumber + "|" + dFAState.getAltSet())) {
            ErrorManager.getErrorListener().warning(grammarDanglingStateMessage);
            set.add(dFAState.dfa.decisionNumber + "|" + dFAState.getAltSet());
        }
    }

    public static void analysisAborted(DecisionProbe decisionProbe) {
        ++ErrorManager.getErrorState().warnings;
        GrammarAnalysisAbortedMessage grammarAnalysisAbortedMessage = new GrammarAnalysisAbortedMessage(decisionProbe);
        ErrorManager.getErrorState().warningMsgIDs.add(grammarAnalysisAbortedMessage.msgID);
        ErrorManager.getErrorListener().warning(grammarAnalysisAbortedMessage);
    }

    public static void unreachableAlts(DecisionProbe decisionProbe, List list) {
        ++ErrorManager.getErrorState().warnings;
        GrammarUnreachableAltsMessage grammarUnreachableAltsMessage = new GrammarUnreachableAltsMessage(decisionProbe, list);
        ErrorManager.getErrorState().warningMsgIDs.add(grammarUnreachableAltsMessage.msgID);
        ErrorManager.getErrorListener().warning(grammarUnreachableAltsMessage);
    }

    public static void insufficientPredicates(DecisionProbe decisionProbe, List list) {
        ++ErrorManager.getErrorState().warnings;
        GrammarInsufficientPredicatesMessage grammarInsufficientPredicatesMessage = new GrammarInsufficientPredicatesMessage(decisionProbe, list);
        ErrorManager.getErrorState().warningMsgIDs.add(grammarInsufficientPredicatesMessage.msgID);
        ErrorManager.getErrorListener().warning(grammarInsufficientPredicatesMessage);
    }

    public static void nonLLStarDecision(DecisionProbe decisionProbe) {
        ++ErrorManager.getErrorState().errors;
        NonRegularDecisionMessage nonRegularDecisionMessage = new NonRegularDecisionMessage(decisionProbe, decisionProbe.getNonDeterministicAlts());
        ErrorManager.getErrorState().errorMsgIDs.add(nonRegularDecisionMessage.msgID);
        ErrorManager.getErrorListener().error(nonRegularDecisionMessage);
    }

    public static void recursionOverflow(DecisionProbe decisionProbe, DFAState dFAState, int n, Collection collection, Collection collection2) {
        ++ErrorManager.getErrorState().warnings;
        RecursionOverflowMessage recursionOverflowMessage = new RecursionOverflowMessage(decisionProbe, dFAState, n, collection, collection2);
        ErrorManager.getErrorState().warningMsgIDs.add(recursionOverflowMessage.msgID);
        ErrorManager.getErrorListener().warning(recursionOverflowMessage);
    }

    public static void leftRecursionCycles(Collection collection) {
        ++ErrorManager.getErrorState().errors;
        LeftRecursionCyclesMessage leftRecursionCyclesMessage = new LeftRecursionCyclesMessage(collection);
        ErrorManager.getErrorState().errorMsgIDs.add(leftRecursionCyclesMessage.msgID);
        ErrorManager.getErrorListener().warning(leftRecursionCyclesMessage);
    }

    public static void grammarError(int n, Grammar grammar, Token token, Object object2, Object object3) {
        ++ErrorManager.getErrorState().errors;
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, token, object2, object3);
        ErrorManager.getErrorState().errorMsgIDs.add(n);
        ErrorManager.getErrorListener().error(grammarSemanticsMessage);
    }

    public static void grammarError(int n, Grammar grammar, Token token, Object object2) {
        ErrorManager.grammarError(n, grammar, token, object2, null);
    }

    public static void grammarError(int n, Grammar grammar, Token token) {
        ErrorManager.grammarError(n, grammar, token, null, null);
    }

    public static void grammarWarning(int n, Grammar grammar, Token token, Object object2, Object object3) {
        ++ErrorManager.getErrorState().errors;
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, token, object2, object3);
        ErrorManager.getErrorState().warningMsgIDs.add(n);
        ErrorManager.getErrorListener().warning(grammarSemanticsMessage);
    }

    public static void grammarWarning(int n, Grammar grammar, Token token, Object object2) {
        ErrorManager.grammarWarning(n, grammar, token, object2, null);
    }

    public static void grammarWarning(int n, Grammar grammar, Token token) {
        ErrorManager.grammarWarning(n, grammar, token, null, null);
    }

    public static void syntaxError(int n, Grammar grammar, Token token, Object object2, RecognitionException recognitionException) {
        ++ErrorManager.getErrorState().errors;
        ErrorManager.getErrorState().errorMsgIDs.add(n);
        ErrorManager.getErrorListener().error(new GrammarSyntaxMessage(n, grammar, token, object2, recognitionException));
    }

    public static void internalError(Object object2, Throwable throwable) {
        StackTraceElement stackTraceElement = ErrorManager.getLastNonErrorManagerCodeLocation(throwable);
        String string = "Exception " + throwable + "@" + stackTraceElement + ": " + object2;
        ErrorManager.error(10, string);
    }

    public static void internalError(Object object2) {
        StackTraceElement stackTraceElement = ErrorManager.getLastNonErrorManagerCodeLocation(new Exception());
        String string = stackTraceElement + ": " + object2;
        ErrorManager.error(10, string);
    }

    public static boolean doNotAttemptAnalysis() {
        return !ErrorManager.getErrorState().errorMsgIDs.and(ERRORS_FORCING_NO_ANALYSIS).isNil();
    }

    public static boolean doNotAttemptCodeGen() {
        return !ErrorManager.getErrorState().errorMsgIDs.and(ERRORS_FORCING_NO_CODEGEN).isNil();
    }

    private static StackTraceElement getLastNonErrorManagerCodeLocation(Throwable throwable) {
        StackTraceElement stackTraceElement;
        int n;
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        for (n = 0; n < stackTraceElementArray.length && (stackTraceElement = stackTraceElementArray[n]).toString().indexOf("ErrorManager") >= 0; ++n) {
        }
        stackTraceElement = stackTraceElementArray[n];
        return stackTraceElement;
    }

    public static void assertTrue(boolean bl, String string) {
        if (!bl) {
            ErrorManager.internalError(string);
        }
    }

    protected static boolean initIdToMessageNameMapping() {
        for (int j = 0; j < idToMessageTemplateName.length; ++j) {
            ErrorManager.idToMessageTemplateName[j] = "INVALID MESSAGE ID: " + j;
        }
        Field[] fieldArray = ErrorManager.class.getFields();
        for (int j = 0; j < fieldArray.length; ++j) {
            Field field = fieldArray[j];
            String string = field.getName();
            if (!string.startsWith("MSG_")) continue;
            String string2 = string.substring("MSG_".length(), string.length());
            int n = 0;
            try {
                n = field.getInt(class$org$antlr$tool$ErrorManager == null ? ErrorManager.class$("org.antlr.tool.ErrorManager") : class$org$antlr$tool$ErrorManager);
            }
            catch (IllegalAccessException illegalAccessException) {
                System.err.println("cannot get const value for " + field.getName());
                continue;
            }
            if (!string.startsWith("MSG_")) continue;
            ErrorManager.idToMessageTemplateName[n] = string2;
        }
        return true;
    }

    protected static boolean verifyMessages() {
        boolean bl = true;
        Field[] fieldArray = ErrorManager.class.getFields();
        for (int j = 0; j < fieldArray.length; ++j) {
            Field field = fieldArray[j];
            String string = field.getName();
            String string2 = string.substring("MSG_".length(), string.length());
            if (!string.startsWith("MSG_") || messages.isDefined(string2)) continue;
            System.err.println("Message " + string2 + " in locale " + locale + " not found");
            bl = false;
        }
        if (!messages.isDefined("warning")) {
            System.err.println("Message template 'warning' not found in locale " + locale);
            bl = false;
        }
        if (!messages.isDefined("error")) {
            System.err.println("Message template 'error' not found in locale " + locale);
            bl = false;
        }
        return bl;
    }

    protected static boolean verifyFormat() {
        boolean bl = true;
        if (!format.isDefined("location")) {
            System.err.println("Format template 'location' not found in " + formatName);
            bl = false;
        }
        if (!format.isDefined("message")) {
            System.err.println("Format template 'message' not found in " + formatName);
            bl = false;
        }
        if (!format.isDefined("report")) {
            System.err.println("Format template 'report' not found in " + formatName);
            bl = false;
        }
        return bl;
    }

    static void rawError(String string) {
        System.err.println(string);
    }

    static void rawError(String string, Throwable throwable) {
        ErrorManager.rawError(string);
        throwable.printStackTrace(System.err);
    }

    public static void panic() {
        Tool tool = (Tool)threadToToolMap.get(Thread.currentThread());
        if (tool == null) {
            throw new Error("ANTLR ErrorManager panic");
        }
        tool.panic();
    }

    static {
        threadToListenerMap = new HashMap();
        threadToErrorCountMap = new HashMap();
        threadToToolMap = new HashMap();
        idToMessageTemplateName = new String[212];
        theDefaultErrorListener = new ANTLRErrorListener(){

            public void info(String string) {
                if (ErrorManager.formatWantsSingleLineMessage()) {
                    string = string.replaceAll("\n", " ");
                }
                System.err.println(string);
            }

            public void error(Message message) {
                String string = message.toString();
                if (ErrorManager.formatWantsSingleLineMessage()) {
                    string = string.replaceAll("\n", " ");
                }
                System.err.println(string);
            }

            public void warning(Message message) {
                String string = message.toString();
                if (ErrorManager.formatWantsSingleLineMessage()) {
                    string = string.replaceAll("\n", " ");
                }
                System.err.println(string);
            }

            public void error(ToolMessage toolMessage) {
                String string = toolMessage.toString();
                if (ErrorManager.formatWantsSingleLineMessage()) {
                    string = string.replaceAll("\n", " ");
                }
                System.err.println(string);
            }
        };
        initSTListener = new StringTemplateErrorListener(){

            public void error(String string, Throwable throwable) {
                System.err.println("ErrorManager init error: " + string);
                if (throwable != null) {
                    System.err.println("exception: " + throwable);
                }
            }

            public void warning(String string) {
                System.err.println("ErrorManager init warning: " + string);
            }

            public void debug(String string) {
            }
        };
        blankSTListener = new StringTemplateErrorListener(){

            public void error(String string, Throwable throwable) {
            }

            public void warning(String string) {
            }

            public void debug(String string) {
            }
        };
        theDefaultSTListener = new StringTemplateErrorListener(){

            public void error(String string, Throwable throwable) {
                if (throwable instanceof InvocationTargetException) {
                    throwable = ((InvocationTargetException)throwable).getTargetException();
                }
                ErrorManager.error(10, (Object)string, throwable);
            }

            public void warning(String string) {
                ErrorManager.warning(11, string);
            }

            public void debug(String string) {
            }
        };
        ErrorManager.initIdToMessageNameMapping();
        ErrorManager.setLocale(Locale.getDefault());
        ErrorManager.setFormat("antlr");
    }

    static class ErrorState {
        public int errors;
        public int warnings;
        public int infos;
        public BitSet errorMsgIDs = new BitSet();
        public BitSet warningMsgIDs = new BitSet();

        ErrorState() {
        }
    }
}

