/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime.tree;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTreeAdaptor;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.runtime.tree.Tree;
import org.antlr.runtime.tree.TreeAdaptor;
import org.antlr.runtime.tree.TreeNodeStream;

public class UnBufferedTreeNodeStream
implements TreeNodeStream {
    public static final int INITIAL_LOOKAHEAD_BUFFER_SIZE = 5;
    protected boolean uniqueNavigationNodes = false;
    protected Object root;
    protected TokenStream tokens;
    TreeAdaptor adaptor;
    protected Stack nodeStack = new Stack();
    protected Stack indexStack = new Stack();
    protected Object currentNode;
    protected Object previousNode;
    protected int currentChildIndex;
    protected int absoluteNodeIndex;
    protected Object[] lookahead = new Object[5];
    protected int head;
    protected int tail;
    protected List markers;
    protected int markDepth = 0;
    protected int lastMarker;
    protected Object down;
    protected Object up;
    protected Object eof;

    public UnBufferedTreeNodeStream(Object object2) {
        this(new CommonTreeAdaptor(), object2);
    }

    public UnBufferedTreeNodeStream(TreeAdaptor treeAdaptor, Object object2) {
        this.root = object2;
        this.adaptor = treeAdaptor;
        this.reset();
        this.down = treeAdaptor.create(2, "DOWN");
        this.up = treeAdaptor.create(3, "UP");
        this.eof = treeAdaptor.create(-1, "EOF");
    }

    public void reset() {
        this.currentNode = this.root;
        this.previousNode = null;
        this.currentChildIndex = -1;
        this.absoluteNodeIndex = -1;
        this.tail = 0;
        this.head = 0;
    }

    public Object get(int n) {
        throw new UnsupportedOperationException("stream is unbuffered");
    }

    public Object LT(int n) {
        if (n == -1) {
            return this.previousNode;
        }
        if (n < 0) {
            throw new IllegalArgumentException("tree node streams cannot look backwards more than 1 node");
        }
        if (n == 0) {
            return Tree.INVALID_NODE;
        }
        this.fill(n);
        return this.lookahead[(this.head + n - 1) % this.lookahead.length];
    }

    public Object getTreeSource() {
        return this.root;
    }

    public TokenStream getTokenStream() {
        return this.tokens;
    }

    public void setTokenStream(TokenStream tokenStream) {
        this.tokens = tokenStream;
    }

    protected void fill(int n) {
        int n2 = this.getLookaheadSize();
        for (int j = 1; j <= n - n2; ++j) {
            this.next();
        }
    }

    protected void addLookahead(Object object2) {
        this.lookahead[this.tail] = object2;
        this.tail = (this.tail + 1) % this.lookahead.length;
        if (this.tail == this.head) {
            Object[] objectArray = new Object[2 * this.lookahead.length];
            int n = this.lookahead.length - this.head;
            System.arraycopy(this.lookahead, this.head, objectArray, 0, n);
            System.arraycopy(this.lookahead, 0, objectArray, n, this.tail);
            this.lookahead = objectArray;
            this.head = 0;
            this.tail += n;
        }
    }

    public void consume() {
        this.fill(1);
        ++this.absoluteNodeIndex;
        this.previousNode = this.lookahead[this.head];
        this.head = (this.head + 1) % this.lookahead.length;
    }

    public int LA(int n) {
        Object object2 = this.LT(n);
        if (object2 == null) {
            return 0;
        }
        return this.adaptor.getType(object2);
    }

    public int mark() {
        if (this.markers == null) {
            this.markers = new ArrayList();
            this.markers.add(null);
        }
        ++this.markDepth;
        TreeWalkState treeWalkState = null;
        if (this.markDepth >= this.markers.size()) {
            treeWalkState = new TreeWalkState();
            this.markers.add(treeWalkState);
        } else {
            treeWalkState = (TreeWalkState)this.markers.get(this.markDepth);
        }
        treeWalkState.absoluteNodeIndex = this.absoluteNodeIndex;
        treeWalkState.currentChildIndex = this.currentChildIndex;
        treeWalkState.currentNode = this.currentNode;
        treeWalkState.previousNode = this.previousNode;
        treeWalkState.nodeStackSize = this.nodeStack.size();
        treeWalkState.indexStackSize = this.indexStack.size();
        int n = this.getLookaheadSize();
        int n2 = 0;
        treeWalkState.lookahead = new Object[n];
        int n3 = 1;
        while (n3 <= n) {
            treeWalkState.lookahead[n2] = this.LT(n3);
            ++n3;
            ++n2;
        }
        this.lastMarker = this.markDepth;
        return this.markDepth;
    }

    public void release(int n) {
        this.markDepth = n;
        --this.markDepth;
    }

    public void rewind(int n) {
        if (this.markers == null) {
            return;
        }
        TreeWalkState treeWalkState = (TreeWalkState)this.markers.get(n);
        this.absoluteNodeIndex = treeWalkState.absoluteNodeIndex;
        this.currentChildIndex = treeWalkState.currentChildIndex;
        this.currentNode = treeWalkState.currentNode;
        this.previousNode = treeWalkState.previousNode;
        this.nodeStack.setSize(treeWalkState.nodeStackSize);
        this.indexStack.setSize(treeWalkState.indexStackSize);
        this.tail = 0;
        this.head = 0;
        while (this.tail < treeWalkState.lookahead.length) {
            this.lookahead[this.tail] = treeWalkState.lookahead[this.tail];
            ++this.tail;
        }
        this.release(n);
    }

    public void rewind() {
        this.rewind(this.lastMarker);
    }

    public void seek(int n) {
        if (n < this.index()) {
            throw new IllegalArgumentException("can't seek backwards in node stream");
        }
        while (this.index() < n) {
            this.consume();
        }
    }

    public int index() {
        return this.absoluteNodeIndex + 1;
    }

    public int size() {
        CommonTreeNodeStream commonTreeNodeStream = new CommonTreeNodeStream(this.root);
        return commonTreeNodeStream.size();
    }

    public Object next() {
        if (this.currentNode == null) {
            this.addLookahead(this.eof);
            return null;
        }
        if (this.currentChildIndex == -1) {
            return this.handleRootNode();
        }
        if (this.currentChildIndex < this.adaptor.getChildCount(this.currentNode)) {
            return this.visitChild(this.currentChildIndex);
        }
        this.walkBackToMostRecentNodeWithUnvisitedChildren();
        if (this.currentNode != null) {
            return this.visitChild(this.currentChildIndex);
        }
        return null;
    }

    protected Object handleRootNode() {
        Object object2 = this.currentNode;
        this.currentChildIndex = 0;
        if (this.adaptor.isNil(object2)) {
            object2 = this.visitChild(this.currentChildIndex);
        } else {
            this.addLookahead(object2);
            if (this.adaptor.getChildCount(this.currentNode) == 0) {
                this.currentNode = null;
            }
        }
        return object2;
    }

    protected Object visitChild(int n) {
        Object object2 = null;
        this.nodeStack.push(this.currentNode);
        this.indexStack.push(new Integer(n));
        if (n == 0 && !this.adaptor.isNil(this.currentNode)) {
            this.addNavigationNode(2);
        }
        this.currentNode = this.adaptor.getChild(this.currentNode, n);
        this.currentChildIndex = 0;
        object2 = this.currentNode;
        this.addLookahead(object2);
        this.walkBackToMostRecentNodeWithUnvisitedChildren();
        return object2;
    }

    protected void addNavigationNode(int n) {
        Object object2 = null;
        object2 = n == 2 ? (this.hasUniqueNavigationNodes() ? this.adaptor.create(2, "DOWN") : this.down) : (this.hasUniqueNavigationNodes() ? this.adaptor.create(3, "UP") : this.up);
        this.addLookahead(object2);
    }

    protected void walkBackToMostRecentNodeWithUnvisitedChildren() {
        while (this.currentNode != null && this.currentChildIndex >= this.adaptor.getChildCount(this.currentNode)) {
            this.currentNode = this.nodeStack.pop();
            if (this.currentNode == null) {
                return;
            }
            this.currentChildIndex = (Integer)this.indexStack.pop();
            ++this.currentChildIndex;
            if (this.currentChildIndex < this.adaptor.getChildCount(this.currentNode)) continue;
            if (!this.adaptor.isNil(this.currentNode)) {
                this.addNavigationNode(3);
            }
            if (this.currentNode != this.root) continue;
            this.currentNode = null;
        }
    }

    public TreeAdaptor getTreeAdaptor() {
        return this.adaptor;
    }

    public boolean hasUniqueNavigationNodes() {
        return this.uniqueNavigationNodes;
    }

    public void setUniqueNavigationNodes(boolean bl) {
        this.uniqueNavigationNodes = bl;
    }

    public String toString() {
        return this.toString(this.root, null);
    }

    protected int getLookaheadSize() {
        return this.tail < this.head ? this.lookahead.length - this.head + this.tail : this.tail - this.head;
    }

    public String toString(Object object2, Object object3) {
        if (object2 == null) {
            return null;
        }
        if (this.tokens != null) {
            int n = this.adaptor.getTokenStartIndex(object2);
            int n2 = this.adaptor.getTokenStopIndex(object3);
            n2 = object3 != null && this.adaptor.getType(object3) == 3 ? this.adaptor.getTokenStopIndex(object2) : this.size() - 1;
            return this.tokens.toString(n, n2);
        }
        StringBuffer stringBuffer = new StringBuffer();
        this.toStringWork(object2, object3, stringBuffer);
        return stringBuffer.toString();
    }

    protected void toStringWork(Object object2, Object object3, StringBuffer stringBuffer) {
        if (!this.adaptor.isNil(object2)) {
            String string = this.adaptor.getText(object2);
            if (string == null) {
                string = " " + String.valueOf(this.adaptor.getType(object2));
            }
            stringBuffer.append(string);
        }
        if (object2 == object3) {
            return;
        }
        int n = this.adaptor.getChildCount(object2);
        if (n > 0 && !this.adaptor.isNil(object2)) {
            stringBuffer.append(" ");
            stringBuffer.append(2);
        }
        for (int j = 0; j < n; ++j) {
            Object object4 = this.adaptor.getChild(object2, j);
            this.toStringWork(object4, object3, stringBuffer);
        }
        if (n > 0 && !this.adaptor.isNil(object2)) {
            stringBuffer.append(" ");
            stringBuffer.append(3);
        }
    }

    protected class TreeWalkState {
        int currentChildIndex;
        int absoluteNodeIndex;
        Object currentNode;
        Object previousNode;
        int nodeStackSize;
        int indexStackSize;
        Object[] lookahead;

        protected TreeWalkState() {
        }
    }
}

