/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime.tree;

import java.util.ArrayList;
import java.util.List;
import org.antlr.runtime.tree.Tree;

public abstract class BaseTree
implements Tree {
    protected List children;

    public BaseTree() {
    }

    public BaseTree(Tree tree) {
    }

    public Tree getChild(int n) {
        if (this.children == null || n >= this.children.size()) {
            return null;
        }
        return (BaseTree)this.children.get(n);
    }

    public Tree getFirstChildWithType(int n) {
        for (int j = 0; this.children != null && j < this.children.size(); ++j) {
            Tree tree = (Tree)this.children.get(j);
            if (tree.getType() != n) continue;
            return tree;
        }
        return null;
    }

    public int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public void addChild(Tree tree) {
        if (tree == null) {
            return;
        }
        BaseTree baseTree = (BaseTree)tree;
        if (baseTree.isNil()) {
            if (this.children != null && this.children == baseTree.children) {
                throw new RuntimeException("attempt to add child list to itself");
            }
            if (baseTree.children != null) {
                if (this.children != null) {
                    int n = baseTree.children.size();
                    for (int j = 0; j < n; ++j) {
                        this.children.add(baseTree.children.get(j));
                    }
                } else {
                    this.children = baseTree.children;
                }
            }
        } else {
            if (this.children == null) {
                this.children = this.createChildrenList();
            }
            this.children.add(tree);
        }
    }

    public void addChildren(List list) {
        for (int j = 0; j < list.size(); ++j) {
            Tree tree = (Tree)list.get(j);
            this.addChild(tree);
        }
    }

    public void setChild(int n, BaseTree baseTree) {
        if (this.children == null) {
            this.children = this.createChildrenList();
        }
        this.children.set(n, baseTree);
    }

    public BaseTree deleteChild(int n) {
        if (this.children == null) {
            return null;
        }
        return (BaseTree)this.children.remove(n);
    }

    protected List createChildrenList() {
        return new ArrayList();
    }

    public boolean isNil() {
        return false;
    }

    public Tree dupTree() {
        Tree tree = this.dupNode();
        for (int j = 0; this.children != null && j < this.children.size(); ++j) {
            Tree tree2 = (Tree)this.children.get(j);
            Tree tree3 = tree2.dupTree();
            tree.addChild(tree3);
        }
        return tree;
    }

    public String toStringTree() {
        if (this.children == null || this.children.size() == 0) {
            return this.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.isNil()) {
            stringBuffer.append("(");
            stringBuffer.append(this.toString());
            stringBuffer.append(' ');
        }
        for (int j = 0; this.children != null && j < this.children.size(); ++j) {
            BaseTree baseTree = (BaseTree)this.children.get(j);
            if (j > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(baseTree.toStringTree());
        }
        if (!this.isNil()) {
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    public int getLine() {
        return 0;
    }

    public int getCharPositionInLine() {
        return 0;
    }

    public abstract String toString();
}

