/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime;

import java.util.List;

public class BitSet
implements Cloneable {
    protected static final int BITS = 64;
    protected static final int LOG_BITS = 6;
    protected static final int MOD_MASK = 63;
    protected long[] bits;

    public BitSet() {
        this(64);
    }

    public BitSet(long[] lArray) {
        this.bits = lArray;
    }

    public BitSet(List list) {
        for (int j = 0; j < list.size(); ++j) {
            Integer n = (Integer)list.get(j);
            this.add(n);
        }
    }

    public BitSet(int n) {
        this.bits = new long[(n - 1 >> 6) + 1];
    }

    public static BitSet of(int n) {
        BitSet bitSet = new BitSet(n + 1);
        bitSet.add(n);
        return bitSet;
    }

    public static BitSet of(int n, int n2) {
        BitSet bitSet = new BitSet(Math.max(n, n2) + 1);
        bitSet.add(n);
        bitSet.add(n2);
        return bitSet;
    }

    public static BitSet of(int n, int n2, int n3) {
        BitSet bitSet = new BitSet();
        bitSet.add(n);
        bitSet.add(n2);
        bitSet.add(n3);
        return bitSet;
    }

    public static BitSet of(int n, int n2, int n3, int n4) {
        BitSet bitSet = new BitSet();
        bitSet.add(n);
        bitSet.add(n2);
        bitSet.add(n3);
        bitSet.add(n4);
        return bitSet;
    }

    public BitSet or(BitSet bitSet) {
        if (bitSet == null) {
            return this;
        }
        BitSet bitSet2 = (BitSet)this.clone();
        bitSet2.orInPlace(bitSet);
        return bitSet2;
    }

    public void add(int n) {
        int n2 = BitSet.wordNumber(n);
        if (n2 >= this.bits.length) {
            this.growToInclude(n);
        }
        int n3 = n2;
        this.bits[n3] = this.bits[n3] | BitSet.bitMask(n);
    }

    public void growToInclude(int n) {
        int n2 = Math.max(this.bits.length << 1, this.numWordsToHold(n));
        long[] lArray = new long[n2];
        System.arraycopy(this.bits, 0, lArray, 0, this.bits.length);
        this.bits = lArray;
    }

    public void orInPlace(BitSet bitSet) {
        if (bitSet == null) {
            return;
        }
        if (bitSet.bits.length > this.bits.length) {
            this.setSize(bitSet.bits.length);
        }
        int n = Math.min(this.bits.length, bitSet.bits.length);
        for (int j = n - 1; j >= 0; --j) {
            int n2 = j;
            this.bits[n2] = this.bits[n2] | bitSet.bits[j];
        }
    }

    private void setSize(int n) {
        long[] lArray = new long[n];
        int n2 = Math.min(n, this.bits.length);
        System.arraycopy(this.bits, 0, lArray, 0, n2);
        this.bits = lArray;
    }

    private static final long bitMask(int n) {
        int n2 = n & 0x3F;
        return 1L << n2;
    }

    public Object clone() {
        BitSet bitSet;
        try {
            bitSet = (BitSet)super.clone();
            bitSet.bits = new long[this.bits.length];
            System.arraycopy(this.bits, 0, bitSet.bits, 0, this.bits.length);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        return bitSet;
    }

    public int size() {
        int n = 0;
        for (int j = this.bits.length - 1; j >= 0; --j) {
            long l = this.bits[j];
            if (l == 0L) continue;
            for (int k = 63; k >= 0; --k) {
                if ((l & 1L << k) == 0L) continue;
                ++n;
            }
        }
        return n;
    }

    public boolean equals(Object object2) {
        block5: {
            int n;
            int n2;
            BitSet bitSet;
            block4: {
                if (object2 == null || !(object2 instanceof BitSet)) {
                    return false;
                }
                bitSet = (BitSet)object2;
                n2 = Math.min(this.bits.length, bitSet.bits.length);
                for (n = 0; n < n2; ++n) {
                    if (this.bits[n] == bitSet.bits[n]) continue;
                    return false;
                }
                if (this.bits.length <= n2) break block4;
                for (n = n2 + 1; n < this.bits.length; ++n) {
                    if (this.bits[n] == 0L) continue;
                    return false;
                }
                break block5;
            }
            if (bitSet.bits.length <= n2) break block5;
            for (n = n2 + 1; n < bitSet.bits.length; ++n) {
                if (bitSet.bits[n] == 0L) continue;
                return false;
            }
        }
        return true;
    }

    public boolean member(int n) {
        if (n < 0) {
            return false;
        }
        int n2 = BitSet.wordNumber(n);
        if (n2 >= this.bits.length) {
            return false;
        }
        return (this.bits[n2] & BitSet.bitMask(n)) != 0L;
    }

    public void remove(int n) {
        int n2 = BitSet.wordNumber(n);
        if (n2 < this.bits.length) {
            int n3 = n2;
            this.bits[n3] = this.bits[n3] & (BitSet.bitMask(n) ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public boolean isNil() {
        for (int j = this.bits.length - 1; j >= 0; --j) {
            if (this.bits[j] == 0L) continue;
            return false;
        }
        return true;
    }

    private final int numWordsToHold(int n) {
        return (n >> 6) + 1;
    }

    public int numBits() {
        return this.bits.length << 6;
    }

    public int lengthInLongWords() {
        return this.bits.length;
    }

    public int[] toArray() {
        int[] nArray = new int[this.size()];
        int n = 0;
        for (int j = 0; j < this.bits.length << 6; ++j) {
            if (!this.member(j)) continue;
            nArray[n++] = j;
        }
        return nArray;
    }

    public long[] toPackedArray() {
        return this.bits;
    }

    private static final int wordNumber(int n) {
        return n >> 6;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = ",";
        boolean bl = false;
        stringBuffer.append('{');
        for (int j = 0; j < this.bits.length << 6; ++j) {
            if (!this.member(j)) continue;
            if (j > 0 && bl) {
                stringBuffer.append(string);
            }
            if (stringArray != null) {
                stringBuffer.append(stringArray[j]);
            } else {
                stringBuffer.append(j);
            }
            bl = true;
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }
}

