/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.analysis;

import org.antlr.analysis.SemanticContext;
import org.antlr.misc.IntSet;
import org.antlr.misc.IntervalSet;
import org.antlr.tool.Grammar;
import org.antlr.tool.GrammarAST;

public class Label
implements Comparable,
Cloneable {
    public static final int INVALID = -6;
    public static final int EPSILON = -5;
    public static final String EPSILON_STR = "<EPSILON>";
    public static final int SEMPRED = -4;
    public static final int SET = -3;
    public static final int EOT = -2;
    public static final int EOF = -1;
    public static final int NUM_FAUX_LABELS = 6;
    public static final int MIN_ATOM_VALUE = -2;
    public static final int MIN_CHAR_VALUE = 0;
    public static final int MAX_CHAR_VALUE = 65534;
    public static final int EOR_TOKEN_TYPE = 1;
    public static final int DOWN = 2;
    public static final int UP = 3;
    public static final int MIN_TOKEN_TYPE = 4;
    protected int label;
    protected SemanticContext semanticContext;
    protected IntSet labelSet;

    public Label(int n) {
        this.label = n;
    }

    public Label(GrammarAST grammarAST) {
        this(-4);
        this.semanticContext = new SemanticContext.Predicate(grammarAST);
    }

    public Label(SemanticContext semanticContext) {
        this(-4);
        this.semanticContext = semanticContext;
    }

    public Label(IntSet intSet) {
        if (intSet == null) {
            this.label = -3;
            this.labelSet = IntervalSet.of(-6);
            return;
        }
        int n = intSet.getSingleElement();
        if (n != -6) {
            this.label = n;
            return;
        }
        this.label = -3;
        this.labelSet = intSet;
    }

    public Object clone() {
        Label label2;
        try {
            label2 = (Label)super.clone();
            label2.label = this.label;
            label2.labelSet = new IntervalSet();
            label2.labelSet.addAll(this.labelSet);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        return label2;
    }

    public void add(Label label2) {
        if (this.isAtom()) {
            this.labelSet = IntervalSet.of(this.label);
            this.label = -3;
            if (label2.isAtom()) {
                this.labelSet.add(label2.getAtom());
            } else if (label2.isSet()) {
                this.labelSet.addAll(label2.getSet());
            } else {
                throw new IllegalStateException("can't add element to Label of type " + this.label);
            }
            return;
        }
        if (this.isSet()) {
            if (label2.isAtom()) {
                this.labelSet.add(label2.getAtom());
            } else if (label2.isSet()) {
                this.labelSet.addAll(label2.getSet());
            } else {
                throw new IllegalStateException("can't add element to Label of type " + this.label);
            }
            return;
        }
        throw new IllegalStateException("can't add element to Label of type " + this.label);
    }

    public boolean isAtom() {
        return this.label >= -2;
    }

    public boolean isEpsilon() {
        return this.label == -5;
    }

    public boolean isSemanticPredicate() {
        return this.label == -4;
    }

    public boolean isSet() {
        return this.label == -3;
    }

    public int getAtom() {
        if (this.isAtom()) {
            return this.label;
        }
        return -6;
    }

    public IntSet getSet() {
        if (this.label != -3) {
            return IntervalSet.of(this.label);
        }
        return this.labelSet;
    }

    public void setSet(IntSet intSet) {
        this.label = -3;
        this.labelSet = intSet;
    }

    public SemanticContext getSemanticContext() {
        return this.semanticContext;
    }

    public boolean matches(int n) {
        if (this.label == n) {
            return true;
        }
        if (this.isSet()) {
            return this.labelSet.member(n);
        }
        return false;
    }

    public boolean matches(IntSet intSet) {
        if (this.isAtom()) {
            return intSet.member(this.getAtom());
        }
        if (this.isSet()) {
            return !this.getSet().and(intSet).isNil();
        }
        return false;
    }

    public boolean matches(Label label2) {
        if (label2.isSet()) {
            return this.matches(label2.getSet());
        }
        if (label2.isAtom()) {
            return this.matches(label2.getAtom());
        }
        return false;
    }

    public int hashCode() {
        switch (this.label) {
            case -3: {
                return this.labelSet.hashCode();
            }
            case -4: {
                return this.semanticContext.hashCode();
            }
        }
        return this.label;
    }

    public boolean equals(Object object2) {
        if (object2 == null) {
            return false;
        }
        if (this.label != ((Label)object2).label) {
            return false;
        }
        if (this.label == -3) {
            return ((Object)this.labelSet).equals(((Label)object2).labelSet);
        }
        return true;
    }

    public int compareTo(Object object2) {
        return this.label - ((Label)object2).label;
    }

    public String toString() {
        switch (this.label) {
            case -3: {
                return ((Object)this.labelSet).toString();
            }
            case -4: {
                return "{" + this.semanticContext + "}?";
            }
        }
        return String.valueOf(this.label);
    }

    public String toString(Grammar grammar) {
        switch (this.label) {
            case -3: {
                return this.labelSet.toString(grammar);
            }
            case -4: {
                return "{" + this.semanticContext + "}?";
            }
        }
        return grammar.getTokenDisplayName(this.label);
    }
}

