/*
 * Decompiled with CFR 0.152.
 */
package org.antlr;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import org.antlr.analysis.DFA;
import org.antlr.analysis.DFAOptimizer;
import org.antlr.analysis.DecisionProbe;
import org.antlr.analysis.NFAContext;
import org.antlr.analysis.NFAToDFAConverter;
import org.antlr.codegen.CodeGenerator;
import org.antlr.runtime.misc.Stats;
import org.antlr.tool.BuildDependencyGenerator;
import org.antlr.tool.DOTGenerator;
import org.antlr.tool.ErrorManager;
import org.antlr.tool.Grammar;
import org.antlr.tool.GrammarReport;
import org.antlr.tool.Rule;

public class Tool {
    public static final String VERSION = "3.0.1";
    public static final String UNINITIALIZED_DIR = "<unset-dir>";
    protected List grammarFileNames = new ArrayList();
    protected boolean generate_NFA_dot = false;
    protected boolean generate_DFA_dot = false;
    protected String outputDirectory = "<unset-dir>";
    protected String libDirectory = ".";
    protected boolean debug = false;
    protected boolean trace = false;
    protected boolean profile = false;
    protected boolean report = false;
    protected boolean printGrammar = false;
    protected boolean depend = false;
    protected boolean forceAllFilesToOutputDir = false;
    public static boolean internalOption_PrintGrammarTree = false;
    public static boolean internalOption_PrintDFA = false;
    public static boolean internalOption_ShowNFConfigsInDFA = false;
    public static boolean internalOption_watchNFAConversion = false;

    public static void main(String[] stringArray) {
        ErrorManager.info("ANTLR Parser Generator  Version 3.0.1 (August 13, 2007)  1989-2007");
        Tool tool = new Tool(stringArray);
        tool.process();
        System.exit(0);
    }

    public Tool() {
    }

    public Tool(String[] stringArray) {
        this.processArgs(stringArray);
    }

    public void processArgs(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            Tool.help();
            return;
        }
        for (int j = 0; j < stringArray.length; ++j) {
            File file;
            if (stringArray[j].equals("-o") || stringArray[j].equals("-fo")) {
                if (j + 1 >= stringArray.length) {
                    System.err.println("missing output directory with -fo/-o option; ignoring");
                    continue;
                }
                if (stringArray[j].equals("-fo")) {
                    this.forceAllFilesToOutputDir = true;
                }
                this.outputDirectory = stringArray[++j];
                if (this.outputDirectory.endsWith("/") || this.outputDirectory.endsWith("\\")) {
                    this.outputDirectory = this.outputDirectory.substring(0, this.outputDirectory.length() - 1);
                }
                if (!(file = new File(this.outputDirectory)).exists() || file.isDirectory()) continue;
                ErrorManager.error(6, this.outputDirectory);
                this.libDirectory = ".";
                continue;
            }
            if (stringArray[j].equals("-lib")) {
                if (j + 1 >= stringArray.length) {
                    System.err.println("missing library directory with -lib option; ignoring");
                    continue;
                }
                this.libDirectory = stringArray[++j];
                if (this.libDirectory.endsWith("/") || this.libDirectory.endsWith("\\")) {
                    this.libDirectory = this.libDirectory.substring(0, this.libDirectory.length() - 1);
                }
                if ((file = new File(this.libDirectory)).exists()) continue;
                ErrorManager.error(5, this.libDirectory);
                this.libDirectory = ".";
                continue;
            }
            if (stringArray[j].equals("-nfa")) {
                this.generate_NFA_dot = true;
                continue;
            }
            if (stringArray[j].equals("-dfa")) {
                this.generate_DFA_dot = true;
                continue;
            }
            if (stringArray[j].equals("-debug")) {
                this.debug = true;
                continue;
            }
            if (stringArray[j].equals("-trace")) {
                this.trace = true;
                continue;
            }
            if (stringArray[j].equals("-report")) {
                this.report = true;
                continue;
            }
            if (stringArray[j].equals("-profile")) {
                this.profile = true;
                continue;
            }
            if (stringArray[j].equals("-print")) {
                this.printGrammar = true;
                continue;
            }
            if (stringArray[j].equals("-depend")) {
                this.depend = true;
                continue;
            }
            if (stringArray[j].equals("-message-format")) {
                if (j + 1 >= stringArray.length) {
                    System.err.println("missing output format with -message-format option; using default");
                    continue;
                }
                ErrorManager.setFormat(stringArray[++j]);
                continue;
            }
            if (stringArray[j].equals("-Xgrtree")) {
                internalOption_PrintGrammarTree = true;
                continue;
            }
            if (stringArray[j].equals("-Xdfa")) {
                internalOption_PrintDFA = true;
                continue;
            }
            if (stringArray[j].equals("-Xnoprune")) {
                DFAOptimizer.PRUNE_EBNF_EXIT_BRANCHES = false;
                continue;
            }
            if (stringArray[j].equals("-Xnocollapse")) {
                DFAOptimizer.COLLAPSE_ALL_PARALLEL_EDGES = false;
                continue;
            }
            if (stringArray[j].equals("-Xdbgconversion")) {
                NFAToDFAConverter.debug = true;
                continue;
            }
            if (stringArray[j].equals("-Xmultithreaded")) {
                NFAToDFAConverter.SINGLE_THREADED_NFA_CONVERSION = false;
                continue;
            }
            if (stringArray[j].equals("-Xnomergestopstates")) {
                DFAOptimizer.MERGE_STOP_STATES = false;
                continue;
            }
            if (stringArray[j].equals("-Xdfaverbose")) {
                internalOption_ShowNFConfigsInDFA = true;
                continue;
            }
            if (stringArray[j].equals("-Xwatchconversion")) {
                internalOption_watchNFAConversion = true;
                continue;
            }
            if (stringArray[j].equals("-XdbgST")) {
                CodeGenerator.EMIT_TEMPLATE_DELIMITERS = true;
                continue;
            }
            if (stringArray[j].equals("-Xnoinlinedfa")) {
                CodeGenerator.GEN_ACYCLIC_DFA_INLINE = false;
                continue;
            }
            if (stringArray[j].equals("-Xm")) {
                if (j + 1 >= stringArray.length) {
                    System.err.println("missing max recursion with -Xm option; ignoring");
                    continue;
                }
                NFAContext.MAX_SAME_RULE_INVOCATIONS_PER_NFA_CONFIG_STACK = Integer.parseInt(stringArray[++j]);
                continue;
            }
            if (stringArray[j].equals("-Xmaxdfaedges")) {
                if (j + 1 >= stringArray.length) {
                    System.err.println("missing max number of edges with -Xmaxdfaedges option; ignoring");
                    continue;
                }
                DFA.MAX_STATE_TRANSITIONS_FOR_TABLE = Integer.parseInt(stringArray[++j]);
                continue;
            }
            if (stringArray[j].equals("-Xconversiontimeout")) {
                if (j + 1 >= stringArray.length) {
                    System.err.println("missing max time in ms -Xconversiontimeout option; ignoring");
                    continue;
                }
                DFA.MAX_TIME_PER_DFA_CREATION = Integer.parseInt(stringArray[++j]);
                continue;
            }
            if (stringArray[j].equals("-Xnfastates")) {
                DecisionProbe.verbose = true;
                continue;
            }
            if (stringArray[j].equals("-X")) {
                Tool.Xhelp();
                continue;
            }
            if (stringArray[j].charAt(0) == '-') continue;
            this.grammarFileNames.add(stringArray[j]);
        }
    }

    public void process() {
        int n = this.grammarFileNames.size();
        for (int j = 0; j < n; ++j) {
            String string = (String)this.grammarFileNames.get(j);
            if (n > 1 && !this.depend) {
                System.out.println(string);
            }
            try {
                Object object2;
                Object object3;
                Object object4;
                if (this.depend) {
                    object4 = new BuildDependencyGenerator(this, string);
                    object3 = ((BuildDependencyGenerator)object4).getGeneratedFileList();
                    object2 = ((BuildDependencyGenerator)object4).getDependenciesFileList();
                    System.out.println(((BuildDependencyGenerator)object4).getDependencies());
                    continue;
                }
                object4 = this.getGrammar(string);
                this.processGrammar((Grammar)object4);
                if (this.printGrammar) {
                    ((Grammar)object4).printGrammar(System.out);
                }
                if (this.generate_NFA_dot) {
                    this.generateNFAs((Grammar)object4);
                }
                if (this.generate_DFA_dot) {
                    this.generateDFAs((Grammar)object4);
                }
                if (this.report) {
                    object3 = new GrammarReport((Grammar)object4);
                    System.out.println(((GrammarReport)object3).toString());
                    System.out.println(((GrammarReport)object3).getBacktrackingReport());
                    System.out.println(((GrammarReport)object3).getEarlyTerminationReport());
                }
                if (this.profile) {
                    object3 = new GrammarReport((Grammar)object4);
                    Stats.writeReport("grammar.stats", ((GrammarReport)object3).toNotifyString());
                }
                object3 = ((Grammar)object4).getLexerGrammar();
                if (((Grammar)object4).type != 4 || object3 == null) continue;
                object2 = ((Grammar)object4).getImplicitlyGeneratedLexerFileName();
                Writer writer = this.getOutputFile((Grammar)object4, (String)object2);
                writer.write((String)object3);
                writer.close();
                StringReader stringReader = new StringReader((String)object3);
                Grammar grammar = new Grammar();
                grammar.setTool(this);
                File file = new File(this.getFileDirectory((String)object2), (String)object2);
                grammar.setFileName(file.toString());
                grammar.importTokenVocabulary((Grammar)object4);
                grammar.setGrammarContent(stringReader);
                stringReader.close();
                this.processGrammar(grammar);
                continue;
            }
            catch (IOException iOException) {
                ErrorManager.error(7, string);
                continue;
            }
            catch (Exception exception) {
                ErrorManager.error(10, (Object)string, exception);
            }
        }
    }

    public Grammar getGrammar(String string) throws IOException, TokenStreamException, RecognitionException {
        FileReader fileReader = null;
        fileReader = new FileReader(string);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        Grammar grammar = new Grammar(this, string, bufferedReader);
        grammar.setWatchNFAConversion(internalOption_watchNFAConversion);
        bufferedReader.close();
        fileReader.close();
        return grammar;
    }

    protected void processGrammar(Grammar grammar) {
        String string = (String)grammar.getOption("language");
        if (string != null) {
            CodeGenerator codeGenerator = new CodeGenerator(this, grammar, string);
            grammar.setCodeGenerator(codeGenerator);
            codeGenerator.setDebug(this.debug);
            codeGenerator.setProfile(this.profile);
            codeGenerator.setTrace(this.trace);
            codeGenerator.genRecognizer();
        }
    }

    protected void generateDFAs(Grammar grammar) {
        for (int j = 1; j <= grammar.getNumberOfDecisions(); ++j) {
            DFA dFA = grammar.getLookaheadDFA(j);
            if (dFA == null) continue;
            DOTGenerator dOTGenerator = new DOTGenerator(grammar);
            String string = dOTGenerator.getDOT(dFA.startState);
            String string2 = grammar.name + "_dec-" + j;
            try {
                this.writeDOTFile(grammar, string2, string);
                continue;
            }
            catch (IOException iOException) {
                ErrorManager.error(14, (Object)string2, iOException);
            }
        }
    }

    protected void generateNFAs(Grammar grammar) {
        DOTGenerator dOTGenerator = new DOTGenerator(grammar);
        Collection collection = grammar.getRules();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Rule rule = (Rule)iterator.next();
            String string = rule.name;
            try {
                this.writeDOTFile(grammar, string, dOTGenerator.getDOT(grammar.getRuleStartState(string)));
            }
            catch (IOException iOException) {
                ErrorManager.error(1, iOException);
            }
        }
    }

    protected void writeDOTFile(Grammar grammar, String string, String string2) throws IOException {
        Writer writer = this.getOutputFile(grammar, string + ".dot");
        writer.write(string2);
        writer.close();
    }

    private static void help() {
        System.err.println("usage: java org.antlr.Tool [args] file.g [file2.g file3.g ...]");
        System.err.println("  -o outputDir          specify output directory where all output is generated");
        System.err.println("  -fo outputDir         same as -o but force even files with relative paths to dir");
        System.err.println("  -lib dir              specify location of token files");
        System.err.println("  -depend               generate file dependencies");
        System.err.println("  -report               print out a report about the grammar(s) processed");
        System.err.println("  -print                print out the grammar without actions");
        System.err.println("  -debug                generate a parser that emits debugging events");
        System.err.println("  -profile              generate a parser that computes profiling information");
        System.err.println("  -nfa                  generate an NFA for each rule");
        System.err.println("  -dfa                  generate a DFA for each decision point");
        System.err.println("  -message-format name  specify output style for messages");
        System.err.println("  -X                    display extended argument list");
    }

    private static void Xhelp() {
        System.err.println("  -Xgrtree               print the grammar AST");
        System.err.println("  -Xdfa                  print DFA as text ");
        System.err.println("  -Xnoprune              test lookahead against EBNF block exit branches");
        System.err.println("  -Xnocollapse           collapse incident edges into DFA states");
        System.err.println("  -Xdbgconversion        dump lots of info during NFA conversion");
        System.err.println("  -Xmultithreaded        run the analysis in 2 threads");
        System.err.println("  -Xnomergestopstates    do not merge stop states");
        System.err.println("  -Xdfaverbose           generate DFA states in DOT with NFA configs");
        System.err.println("  -Xwatchconversion      print a message for each NFA before converting");
        System.err.println("  -XdbgST                put tags at start/stop of all templates in output");
        System.err.println("  -Xm m                  max number of rule invocations during conversion");
        System.err.println("  -Xmaxdfaedges m        max \"comfortable\" number of edges for single DFA state");
        System.err.println("  -Xconversiontimeout t  set NFA conversion timeout for each decision");
        System.err.println("  -Xnoinlinedfa          make all DFA with tables; no inline prediction with IFs");
        System.err.println("  -Xnfastates            for nondeterminisms, list NFA states for each path");
    }

    public void setOutputDirectory(String string) {
        this.outputDirectory = string;
    }

    public Writer getOutputFile(Grammar grammar, String string) throws IOException {
        if (this.outputDirectory == null) {
            return new StringWriter();
        }
        File file = this.getOutputDirectory(grammar.getFileName());
        File file2 = new File(file, string);
        if (!file.exists()) {
            file.mkdirs();
        }
        FileWriter fileWriter = new FileWriter(file2);
        return new BufferedWriter(fileWriter);
    }

    public File getOutputDirectory(String string) {
        File file = new File(this.outputDirectory);
        String string2 = this.getFileDirectory(string);
        if (this.outputDirectory != UNINITIALIZED_DIR) {
            file = string2 != null && (new File(string2).isAbsolute() || string2.startsWith("~")) || this.forceAllFilesToOutputDir ? new File(this.outputDirectory) : (string2 != null ? new File(this.outputDirectory, string2) : new File(this.outputDirectory));
        } else {
            String string3 = ".";
            if (string2 != null) {
                string3 = string2;
            }
            file = new File(string3);
        }
        return file;
    }

    public BufferedReader getLibraryFile(String string) throws IOException {
        String string2 = this.libDirectory + File.separator + string;
        FileReader fileReader = new FileReader(string2);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        return bufferedReader;
    }

    public String getLibraryDirectory() {
        return this.libDirectory;
    }

    public String getFileDirectory(String string) {
        File file = new File(string);
        return file.getParent();
    }

    public void panic() {
        throw new Error("ANTLR panic");
    }

    public static String getCurrentTimeStamp() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        int n = gregorianCalendar.get(1);
        int n2 = gregorianCalendar.get(2) + 1;
        int n3 = gregorianCalendar.get(5);
        int n4 = gregorianCalendar.get(11);
        int n5 = gregorianCalendar.get(12);
        int n6 = gregorianCalendar.get(13);
        String string = String.valueOf(n);
        String string2 = n2 < 10 ? "0" + n2 : String.valueOf(n2);
        String string3 = n3 < 10 ? "0" + n3 : String.valueOf(n3);
        String string4 = n4 < 10 ? "0" + n4 : String.valueOf(n4);
        String string5 = n5 < 10 ? "0" + n5 : String.valueOf(n5);
        String string6 = n6 < 10 ? "0" + n6 : String.valueOf(n6);
        return string + "-" + string2 + "-" + string3 + " " + string4 + ":" + string5 + ":" + string6;
    }
}

