/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.service.impl;

import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.cache.MultiVMPool;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.NotificationThreadLocal;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import com.liferay.subscription.service.SubscriptionLocalService;
import com.liferay.trash.TrashHelper;
import com.liferay.trash.exception.RestoreEntryException;
import com.liferay.trash.exception.TrashEntryException;
import com.liferay.trash.model.TrashEntry;
import com.liferay.trash.service.TrashEntryLocalService;
import com.liferay.wiki.configuration.WikiGroupServiceConfiguration;
import com.liferay.wiki.exception.DuplicateNodeNameException;
import com.liferay.wiki.exception.NodeNameException;
import com.liferay.wiki.importer.WikiImporter;
import com.liferay.wiki.internal.util.WikiCacheThreadLocal;
import com.liferay.wiki.model.WikiNode;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.model.WikiPageDisplay;
import com.liferay.wiki.service.base.WikiNodeLocalServiceBaseImpl;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class WikiNodeLocalServiceImpl
extends WikiNodeLocalServiceBaseImpl {
    @ServiceReference(type=MultiVMPool.class)
    protected MultiVMPool multiVMPool;
    @ServiceReference(type=SubscriptionLocalService.class)
    protected SubscriptionLocalService subscriptionLocalService;
    @ServiceReference(type=TrashEntryLocalService.class)
    protected TrashEntryLocalService trashEntryLocalService;
    @ServiceReference(type=TrashHelper.class)
    protected TrashHelper trashHelper;
    @ServiceReference(type=WikiGroupServiceConfiguration.class)
    protected WikiGroupServiceConfiguration wikiGroupServiceConfiguration;
    private static final Log _log = LogFactoryUtil.getLog(WikiNodeLocalServiceImpl.class);
    private PortalCache<?, ?> _portalCache;
    private ServiceTrackerMap<String, WikiImporter> _wikiImporterServiceTrackerMap;

    public WikiNode addDefaultNode(long userId, ServiceContext serviceContext) throws PortalException {
        return this.addNode(userId, this.wikiGroupServiceConfiguration.initialNodeName(), "", serviceContext);
    }

    public WikiNode addNode(long userId, String name, String description, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        long groupId = serviceContext.getScopeGroupId();
        this.validate(groupId, name);
        long nodeId = this.counterLocalService.increment();
        WikiNode node = this.wikiNodePersistence.create(nodeId);
        node.setUuid(serviceContext.getUuid());
        node.setGroupId(groupId);
        node.setCompanyId(user.getCompanyId());
        node.setUserId(user.getUserId());
        node.setUserName(user.getFullName());
        node.setName(name);
        node.setDescription(description);
        try {
            this.wikiNodePersistence.update((BaseModel)node);
        }
        catch (SystemException se) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((String[])new String[]{"Add failed, fetch {groupId=", String.valueOf(groupId), ", name=", name, "}"}));
            }
            if ((node = this.wikiNodePersistence.fetchByG_N(groupId, name, false)) == null) {
                throw se;
            }
            return node;
        }
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addNodeResources(node, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addNodeResources(node, serviceContext.getGroupPermissions(), serviceContext.getGuestPermissions());
        }
        return node;
    }

    public void addNodeResources(long nodeId, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        WikiNode node = this.wikiNodePersistence.findByPrimaryKey(nodeId);
        this.addNodeResources(node, addGroupPermissions, addGuestPermissions);
    }

    public void addNodeResources(long nodeId, String[] groupPermissions, String[] guestPermissions) throws PortalException {
        WikiNode node = this.wikiNodePersistence.findByPrimaryKey(nodeId);
        this.addNodeResources(node, groupPermissions, guestPermissions);
    }

    public void addNodeResources(WikiNode node, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        this.resourceLocalService.addResources(node.getCompanyId(), node.getGroupId(), node.getUserId(), WikiNode.class.getName(), node.getNodeId(), false, addGroupPermissions, addGuestPermissions);
    }

    public void addNodeResources(WikiNode node, String[] groupPermissions, String[] guestPermissions) throws PortalException {
        this.resourceLocalService.addModelResources(node.getCompanyId(), node.getGroupId(), node.getUserId(), WikiNode.class.getName(), node.getNodeId(), groupPermissions, guestPermissions);
    }

    @Override
    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Bundle bundle = FrameworkUtil.getBundle(WikiNodeLocalServiceImpl.class);
        this._wikiImporterServiceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundle.getBundleContext(), WikiImporter.class, (String)"importer");
        this._portalCache = this.multiVMPool.getPortalCache(WikiPageDisplay.class.getName());
    }

    public void deleteNode(long nodeId) throws PortalException {
        WikiNode node = this.wikiNodePersistence.findByPrimaryKey(nodeId);
        this.wikiNodeLocalService.deleteNode(node);
    }

    @SystemEvent(action=1, type=1)
    public void deleteNode(WikiNode node) throws PortalException {
        boolean clearCache = WikiCacheThreadLocal.isClearCache();
        try {
            WikiCacheThreadLocal.setClearCache(false);
            this.wikiPageLocalService.deletePages(node.getNodeId());
        }
        finally {
            WikiCacheThreadLocal.setClearCache(clearCache);
            this._portalCache.removeAll();
        }
        this.wikiNodePersistence.remove((BaseModel)node);
        this.resourceLocalService.deleteResource(node.getCompanyId(), WikiNode.class.getName(), 4, node.getNodeId());
        long folderId = node.getAttachmentsFolderId();
        if (folderId != 0L) {
            PortletFileRepositoryUtil.deletePortletFolder((long)folderId);
        }
        this.subscriptionLocalService.deleteSubscriptions(node.getCompanyId(), WikiNode.class.getName(), node.getNodeId());
        if (node.isInTrash()) {
            node.setName(this.trashHelper.getOriginalTitle(node.getName()));
            this.trashEntryLocalService.deleteEntry(WikiNode.class.getName(), node.getNodeId());
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(WikiNode.class);
            indexer.delete((Object)node);
        }
    }

    public void deleteNodes(long groupId) throws PortalException {
        List nodes = this.wikiNodePersistence.findByGroupId(groupId);
        for (WikiNode node : nodes) {
            this.wikiNodeLocalService.deleteNode(node);
        }
        PortletFileRepositoryUtil.deletePortletRepository((long)groupId, (String)"com.liferay.wiki");
    }

    public WikiNode fetchNode(long groupId, String name) {
        return this.wikiNodePersistence.fetchByG_N(groupId, name);
    }

    public WikiNode fetchNodeByUuidAndGroupId(String uuid, long groupId) {
        return this.wikiNodePersistence.fetchByUUID_G(uuid, groupId);
    }

    public List<WikiNode> getCompanyNodes(long companyId, int start, int end) {
        return this.wikiNodePersistence.findByC_S(companyId, 0, start, end);
    }

    public List<WikiNode> getCompanyNodes(long companyId, int status, int start, int end) {
        return this.wikiNodePersistence.findByC_S(companyId, status, start, end);
    }

    public int getCompanyNodesCount(long companyId) {
        return this.wikiNodePersistence.countByC_S(companyId, 0);
    }

    public int getCompanyNodesCount(long companyId, int status) {
        return this.wikiNodePersistence.countByC_S(companyId, status);
    }

    public WikiNode getNode(long nodeId) throws PortalException {
        return this.wikiNodePersistence.findByPrimaryKey(nodeId);
    }

    public WikiNode getNode(long groupId, String nodeName) throws PortalException {
        return this.wikiNodePersistence.findByG_N(groupId, nodeName);
    }

    public List<WikiNode> getNodes(long groupId) throws PortalException {
        return this.getNodes(groupId, 0);
    }

    public List<WikiNode> getNodes(long groupId, int status) throws PortalException {
        List<WikiNode> nodes = this.wikiNodePersistence.findByG_S(groupId, status);
        if (nodes.isEmpty()) {
            nodes = this.addDefaultNode(groupId);
        }
        return nodes;
    }

    public List<WikiNode> getNodes(long groupId, int start, int end) throws PortalException {
        return this.getNodes(groupId, 0, start, end);
    }

    public List<WikiNode> getNodes(long groupId, int status, int start, int end) throws PortalException {
        List<WikiNode> nodes = this.wikiNodePersistence.findByG_S(groupId, status, start, end);
        if (nodes.isEmpty()) {
            nodes = this.addDefaultNode(groupId);
        }
        return nodes;
    }

    public int getNodesCount(long groupId) {
        return this.wikiNodePersistence.countByG_S(groupId, 0);
    }

    public int getNodesCount(long groupId, int status) {
        return this.wikiNodePersistence.countByG_S(groupId, status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importPages(long userId, long nodeId, String importer, InputStream[] inputStreams, Map<String, String[]> options) throws PortalException {
        WikiNode node = this.getNode(nodeId);
        WikiImporter wikiImporter = (WikiImporter)this._wikiImporterServiceTrackerMap.getService((Object)importer);
        if (wikiImporter == null) {
            throw new SystemException("Unable to instantiate wiki importer with name " + importer);
        }
        boolean notificationsEnabled = NotificationThreadLocal.isEnabled();
        boolean clearCache = WikiCacheThreadLocal.isClearCache();
        try {
            NotificationThreadLocal.setEnabled((boolean)false);
            WikiCacheThreadLocal.setClearCache(false);
            wikiImporter.importPages(userId, node, inputStreams, options);
        }
        finally {
            NotificationThreadLocal.setEnabled((boolean)notificationsEnabled);
            WikiCacheThreadLocal.setClearCache(clearCache);
            this._portalCache.removeAll();
        }
    }

    public WikiNode moveNodeToTrash(long userId, long nodeId) throws PortalException {
        WikiNode node = this.wikiNodePersistence.findByPrimaryKey(nodeId);
        return this.moveNodeToTrash(userId, node);
    }

    public WikiNode moveNodeToTrash(long userId, WikiNode node) throws PortalException {
        if (node.isInTrash()) {
            throw new TrashEntryException();
        }
        int oldStatus = node.getStatus();
        node = this.updateStatus(userId, node, 8, new ServiceContext());
        UnicodeProperties typeSettingsProperties = new UnicodeProperties();
        typeSettingsProperties.put("title", node.getName());
        TrashEntry trashEntry = this.trashEntryLocalService.addTrashEntry(userId, node.getGroupId(), WikiNode.class.getName(), node.getNodeId(), node.getUuid(), null, oldStatus, null, typeSettingsProperties);
        node.setName(this.trashHelper.getTrashTitle(trashEntry.getEntryId()));
        this.wikiNodePersistence.update((BaseModel)node);
        this.moveDependentsToTrash(node.getNodeId(), trashEntry.getEntryId());
        return node;
    }

    public void restoreNodeFromTrash(long userId, WikiNode node) throws PortalException {
        if (!node.isInTrash()) {
            throw new RestoreEntryException(4);
        }
        node.setName(this.trashHelper.getOriginalTitle(node.getName()));
        this.wikiNodePersistence.update((BaseModel)node);
        TrashEntry trashEntry = this.trashEntryLocalService.getEntry(WikiNode.class.getName(), node.getNodeId());
        this.updateStatus(userId, node, trashEntry.getStatus(), new ServiceContext());
        this.restoreDependentsFromTrash(userId, node.getNodeId());
        this.trashEntryLocalService.deleteEntry(trashEntry);
    }

    public void subscribeNode(long userId, long nodeId) throws PortalException {
        WikiNode node = this.getNode(nodeId);
        this.subscriptionLocalService.addSubscription(userId, node.getGroupId(), WikiNode.class.getName(), nodeId);
    }

    public void unsubscribeNode(long userId, long nodeId) throws PortalException {
        this.subscriptionLocalService.deleteSubscription(userId, WikiNode.class.getName(), nodeId);
    }

    public WikiNode updateNode(long nodeId, String name, String description, ServiceContext serviceContext) throws PortalException {
        WikiNode node = this.wikiNodePersistence.findByPrimaryKey(nodeId);
        this.validate(nodeId, node.getGroupId(), name);
        node.setName(name);
        node.setDescription(description);
        this.wikiNodePersistence.update((BaseModel)node);
        return node;
    }

    public WikiNode updateStatus(long userId, WikiNode node, int status, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        node.setStatus(status);
        node.setStatusByUserId(userId);
        node.setStatusByUserName(user.getFullName());
        node.setStatusDate(new Date());
        this.wikiNodePersistence.update((BaseModel)node);
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(WikiNode.class);
        indexer.reindex((Object)node);
        return node;
    }

    protected List<WikiNode> addDefaultNode(long groupId) throws PortalException {
        Group group = this.groupLocalService.getGroup(groupId);
        long defaultUserId = this.userLocalService.getDefaultUserId(group.getCompanyId());
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setScopeGroupId(groupId);
        WikiNode node = this.wikiNodeLocalService.addDefaultNode(defaultUserId, serviceContext);
        ArrayList<WikiNode> nodes = new ArrayList<WikiNode>(1);
        nodes.add(node);
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void moveDependentsToTrash(long nodeId, long trashEntryId) throws PortalException {
        boolean clearCache = WikiCacheThreadLocal.isClearCache();
        try {
            WikiCacheThreadLocal.setClearCache(false);
            List pages = this.wikiPagePersistence.findByN_H(nodeId, true);
            for (WikiPage page : pages) {
                this.wikiPageLocalService.moveDependentToTrash(page, trashEntryId);
            }
        }
        finally {
            WikiCacheThreadLocal.setClearCache(clearCache);
            this._portalCache.removeAll();
        }
    }

    protected void restoreDependentsFromTrash(long userId, long nodeId) throws PortalException {
        List pages = this.wikiPagePersistence.findByN_H(nodeId, true);
        for (WikiPage page : pages) {
            if (!page.isInTrashImplicitly()) continue;
            this.wikiPageLocalService.restorePageFromTrash(userId, page);
        }
    }

    protected void validate(long nodeId, long groupId, String name) throws PortalException {
        if (StringUtil.equalsIgnoreCase((String)name, (String)"tag")) {
            throw new NodeNameException(name + " is reserved");
        }
        if (Validator.isNull((String)name)) {
            throw new NodeNameException();
        }
        if (Validator.isNumber((String)name)) {
            throw new NodeNameException("Node name cannot be a number");
        }
        WikiNode node = this.wikiNodePersistence.fetchByG_N(groupId, name);
        if (node != null && node.getNodeId() != nodeId) {
            throw new DuplicateNodeNameException("{nodeId=" + nodeId + "}");
        }
    }

    protected void validate(long groupId, String name) throws PortalException {
        this.validate(0L, groupId, name);
    }
}

