/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.internal.upgrade.v1_0_0;

import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringBundler;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class UpgradeWikiPageResource
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        this.updateWikiPageResources();
    }

    protected long getGroupId(long resourcePrimKey) throws Exception {
        long groupId = 0L;
        try (PreparedStatement ps = this.connection.prepareStatement("select groupId from WikiPage where resourcePrimKey = ?");){
            ps.setLong(1, resourcePrimKey);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    groupId = rs.getLong("groupId");
                }
            }
        }
        return groupId;
    }

    protected void updateWikiPageResources() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps = this.connection.prepareStatement("select resourcePrimKey from WikiPageResource");
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                long resourcePrimKey = rs.getLong("resourcePrimKey");
                long groupId = this.getGroupId(resourcePrimKey);
                this.runSQL(StringBundler.concat((String[])new String[]{"update WikiPageResource set groupId = ", String.valueOf(groupId), " where resourcePrimKey = ", String.valueOf(resourcePrimKey)}));
            }
        }
    }
}

