/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.internal.exportimport.portlet.preferences.processor;

import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.portlet.preferences.processor.Capability;
import com.liferay.exportimport.portlet.preferences.processor.ExportImportPortletPreferencesProcessor;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.wiki.model.WikiNode;
import com.liferay.wiki.service.WikiNodeLocalService;
import java.util.List;
import javax.portlet.PortletPreferences;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_wiki_web_portlet_WikiPortlet"}, service={ExportImportPortletPreferencesProcessor.class})
public class WikiExportImportPortletPreferencesProcessor
implements ExportImportPortletPreferencesProcessor {
    private static final Log _log = LogFactoryUtil.getLog(WikiExportImportPortletPreferencesProcessor.class);
    @Reference(target="(name=ReferencedStagedModelImporter)")
    private Capability _capability;
    @Reference(target="(name=PortletDisplayTemplateExporter)")
    private Capability _exportCapability;
    private GroupLocalService _groupLocalService;
    @Reference(target="(name=PortletDisplayTemplateImporter)")
    private Capability _importCapability;
    private WikiNodeLocalService _wikiNodeLocalService;

    public List<Capability> getExportCapabilities() {
        return ListUtil.toList((Object[])new Capability[]{this._exportCapability});
    }

    public List<Capability> getImportCapabilities() {
        return ListUtil.toList((Object[])new Capability[]{this._importCapability, this._capability});
    }

    public PortletPreferences processExportPortletPreferences(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws PortletDataException {
        Group group = this._groupLocalService.fetchGroup(portletDataContext.getGroupId());
        String hiddenNodeNames = portletPreferences.getValue("hiddenNodes", null);
        for (String hiddenNodeName : StringUtil.split((String)hiddenNodeNames)) {
            this.exportNode(portletDataContext, group, hiddenNodeName);
        }
        String visibleNodeNames = portletPreferences.getValue("visibleNodes", null);
        for (String visibleNodeName : StringUtil.split((String)visibleNodeNames)) {
            this.exportNode(portletDataContext, group, visibleNodeName);
        }
        return portletPreferences;
    }

    public PortletPreferences processImportPortletPreferences(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws PortletDataException {
        return portletPreferences;
    }

    protected void exportNode(PortletDataContext portletDataContext, Group group, String nodeName) throws PortletDataException {
        if (ExportImportThreadLocal.isStagingInProcess() && !group.isStagedPortlet(portletDataContext.getPortletId())) {
            return;
        }
        WikiNode node = this._wikiNodeLocalService.fetchNode(portletDataContext.getScopeGroupId(), nodeName);
        if (node == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to export referenced wiki node " + nodeName));
            }
            return;
        }
        String portletId = portletDataContext.getPortletId();
        StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (String)portletId, (StagedModel)node);
    }

    @Reference(unbind="-")
    protected void setGroupLocalService(GroupLocalService groupLocalService) {
        this._groupLocalService = groupLocalService;
    }

    @Reference(unbind="-")
    protected void setWikiNodeLocalService(WikiNodeLocalService wikiNodeLocalService) {
        this._wikiNodeLocalService = wikiNodeLocalService;
    }
}

