/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.internal.exportimport.portlet.preferences.processor;

import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.portlet.preferences.processor.Capability;
import com.liferay.exportimport.portlet.preferences.processor.ExportImportPortletPreferencesProcessor;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.wiki.model.WikiNode;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.service.WikiPageLocalService;
import com.liferay.wiki.service.persistence.WikiNodeUtil;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.portlet.ReadOnlyException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_wiki_web_portlet_WikiDisplayPortlet"}, service={ExportImportPortletPreferencesProcessor.class})
public class WikiDisplayExportImportPortletPreferencesProcessor
implements ExportImportPortletPreferencesProcessor {
    private static final Log _log = LogFactoryUtil.getLog(WikiDisplayExportImportPortletPreferencesProcessor.class);
    @Reference(target="(name=ReferencedStagedModelImporter)")
    private Capability _capability;
    private WikiPageLocalService _wikiPageLocalService;

    public List<Capability> getExportCapabilities() {
        return null;
    }

    public List<Capability> getImportCapabilities() {
        return ListUtil.toList((Object[])new Capability[]{this._capability});
    }

    public PortletPreferences processExportPortletPreferences(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws PortletDataException {
        String portletId = portletDataContext.getPortletId();
        long nodeId = GetterUtil.getLong((String)portletPreferences.getValue("nodeId", ""));
        if (nodeId <= 0L) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Node ID is not set for preferences of portlet " + portletId));
            }
            return portletPreferences;
        }
        String title2 = portletPreferences.getValue("title", null);
        if (title2 == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Title is not set for preferences of portlet " + portletId));
            }
            return portletPreferences;
        }
        WikiNode node = WikiNodeUtil.fetchByPrimaryKey((long)nodeId);
        if (node == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Unable to find wiki node");
            }
            return portletPreferences;
        }
        try {
            portletDataContext.addPortletPermissions("com.liferay.wiki");
        }
        catch (PortalException pe) {
            throw new PortletDataException("Unable to export portlet permissions", (Throwable)pe);
        }
        StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (String)portletId, (StagedModel)node);
        ActionableDynamicQuery actionableDynamicQuery = this.getPageActionableDynamicQuery(portletDataContext, node.getNodeId(), portletId);
        try {
            actionableDynamicQuery.performActions();
        }
        catch (PortalException pe) {
            throw new PortletDataException("Unable to export referenced pages", (Throwable)pe);
        }
        return portletPreferences;
    }

    public PortletPreferences processImportPortletPreferences(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws PortletDataException {
        try {
            portletDataContext.importPortletPermissions("com.liferay.wiki");
        }
        catch (PortalException pe) {
            throw new PortletDataException("Unable to import portlet permissions", (Throwable)pe);
        }
        long nodeId = GetterUtil.getLong((String)portletPreferences.getValue("nodeId", ""));
        if (nodeId > 0L) {
            Map nodeIds = portletDataContext.getNewPrimaryKeysMap(WikiNode.class);
            nodeId = MapUtil.getLong((Map)nodeIds, (long)nodeId, (long)nodeId);
            try {
                portletPreferences.setValue("nodeId", String.valueOf(nodeId));
            }
            catch (ReadOnlyException roe) {
                throw new PortletDataException("Unable to update portlet preferences during import", (Throwable)roe);
            }
        }
        return portletPreferences;
    }

    protected ActionableDynamicQuery getPageActionableDynamicQuery(final PortletDataContext portletDataContext, final long nodeId, final String portletId) {
        ExportActionableDynamicQuery actionableDynamicQuery = this._wikiPageLocalService.getExportActionableDynamicQuery(portletDataContext);
        final ActionableDynamicQuery.AddCriteriaMethod addCriteriaMethod = actionableDynamicQuery.getAddCriteriaMethod();
        actionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                addCriteriaMethod.addCriteria(dynamicQuery);
                Property property = PropertyFactoryUtil.forName((String)"nodeId");
                dynamicQuery.add(property.eq((Object)nodeId));
            }
        });
        actionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<WikiPage>(){

            public void performAction(WikiPage page) throws PortalException {
                StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (String)portletId, (StagedModel)page);
            }
        });
        return actionableDynamicQuery;
    }

    @Reference(unbind="-")
    protected void setWikiPageLocalService(WikiPageLocalService wikiPageLocalService) {
        this._wikiPageLocalService = wikiPageLocalService;
    }
}

