/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.navigation.web.internal.util;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.wiki.model.WikiNode;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.service.WikiPageServiceUtil;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.PortletURL;

public class MenuItem
implements Serializable {
    private static final Pattern _pattern = Pattern.compile("(?:(?:==\\s(.*?)\\s==)*(?:\\Q[[\\E(.*?)\\Q]]\\E)*)*");
    private List<MenuItem> _children = new LinkedList<MenuItem>();
    private boolean _externalURL;
    private String _label;
    private String _url;

    public static List<MenuItem> fromWikiNode(long nodeId, int depth, PortletURL portletURL) {
        List wikiPages = null;
        try {
            wikiPages = WikiPageServiceUtil.getNodePages((long)nodeId, (int)1000);
        }
        catch (Exception e) {
            return new LinkedList<MenuItem>();
        }
        return MenuItem._fromWikiNode(wikiPages, 1, depth, portletURL);
    }

    public static List<MenuItem> fromWikiPage(WikiPage wikiPage, PortletURL portletURL) {
        return MenuItem._fromWikiPage(wikiPage, portletURL);
    }

    public void addChild(MenuItem child) {
        this._children.add(child);
    }

    public void addChildren(List<MenuItem> children) {
        this._children.addAll(children);
    }

    public List<MenuItem> getChildren() {
        return this._children;
    }

    public boolean getExternalURL() {
        return this._externalURL;
    }

    public String getLabel() {
        return this._label;
    }

    public String getURL() {
        return this._url;
    }

    public void setChildren(List<MenuItem> children) {
        this._children = children;
    }

    public void setExternalURL(boolean externalURL) {
        this._externalURL = externalURL;
    }

    public void setLabel(String label) {
        this._label = label;
    }

    public void setURL(String url) {
        this._url = url;
    }

    private static List<MenuItem> _fromWikiNode(List<WikiPage> wikiPages, int curDepth, int depth, PortletURL portletURL) {
        LinkedList<MenuItem> menuItems = new LinkedList<MenuItem>();
        for (WikiPage wikiPage : wikiPages) {
            if (wikiPage.fetchParentPage() != null && curDepth == 1) continue;
            String title = wikiPage.getTitle();
            WikiNode wikiNode = wikiPage.getNode();
            portletURL.setParameter("nodeId", String.valueOf(wikiNode.getNodeId()));
            portletURL.setParameter("title", title);
            MenuItem menuItem = new MenuItem();
            menuItem.setLabel(title);
            menuItem.setURL(portletURL.toString());
            if (depth >= curDepth || depth == -1) {
                List<MenuItem> children = MenuItem._fromWikiNode(wikiPage.getViewableChildPages(), curDepth + 1, depth, portletURL);
                menuItem.addChildren(children);
            }
            menuItems.add(menuItem);
        }
        return menuItems;
    }

    private static List<MenuItem> _fromWikiPage(WikiPage wikiPage, PortletURL portletURL) {
        LinkedList<MenuItem> menuItems = new LinkedList<MenuItem>();
        Matcher matcher = _pattern.matcher(wikiPage.getContent());
        while (matcher.find()) {
            String title = GetterUtil.getString((String)matcher.group(1));
            MenuItem menuItem = new MenuItem();
            menuItem.setLabel(title);
            menuItems.add(menuItem);
            String s = matcher.group(2);
            if (s == null) continue;
            MenuItem childMenuItem = new MenuItem();
            int index = s.indexOf("|");
            String label = null;
            String url = null;
            if (index != -1) {
                label = s.substring(index + 1);
                url = s.substring(0, index);
            } else {
                label = s;
                url = s;
            }
            if (!url.startsWith("http")) {
                long nodeId = wikiPage.getNodeId();
                portletURL.setParameter("title", url);
                portletURL.setParameter("nodeId", String.valueOf(nodeId));
                url = portletURL.toString();
            } else {
                childMenuItem.setExternalURL(true);
            }
            childMenuItem.setLabel(label);
            childMenuItem.setURL(url);
            menuItem.addChild(childMenuItem);
        }
        return menuItems;
    }
}

