/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.editor.link.browse.web.internal.editor.configuration;

import com.liferay.item.selector.ItemSelector;
import com.liferay.item.selector.ItemSelectorCriterion;
import com.liferay.item.selector.ItemSelectorReturnType;
import com.liferay.item.selector.criteria.URLItemSelectorReturnType;
import com.liferay.portal.kernel.editor.configuration.BaseEditorConfigContributor;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.portlet.RequestBackedPortletURLFactory;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.wiki.item.selector.criterion.WikiAttachmentItemSelectorCriterion;
import com.liferay.wiki.item.selector.criterion.WikiPageItemSelectorCriterion;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletURL;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseWikiContentAlloyEditorLinkBrowseConfigContributor
extends BaseEditorConfigContributor {
    @Reference
    protected ItemSelector itemSelector;

    public void populateConfigJSONObject(JSONObject jsonObject, Map<String, Object> inputEditorTaglibAttributes, ThemeDisplay themeDisplay, RequestBackedPortletURLFactory requestBackedPortletURLFactory) {
        Map fileBrowserParamsMap = (Map)inputEditorTaglibAttributes.get("liferay-ui:input-editor:fileBrowserParams");
        if (fileBrowserParamsMap == null) {
            return;
        }
        long nodeId = GetterUtil.getLong((String)((String)fileBrowserParamsMap.get("nodeId")));
        long wikiPageResourcePrimKey = GetterUtil.getLong((String)((String)fileBrowserParamsMap.get("wikiPageResourcePrimKey")));
        String documentBrowseLinkUrl = jsonObject.getString("documentBrowseLinkUrl");
        List<ItemSelectorCriterion> itemSelectorCriteria = new ArrayList<ItemSelectorCriterion>();
        String itemSelectedEventName = null;
        if (documentBrowseLinkUrl == null) {
            if (nodeId != 0L) {
                itemSelectorCriteria.add(this.getWikiPageItemSelectorCriterion(nodeId));
            }
            if (wikiPageResourcePrimKey == 0L) {
                itemSelectorCriteria.add(this.getWikiAttachmentItemSelectorCriterion(wikiPageResourcePrimKey));
            }
            if (itemSelectorCriteria.isEmpty()) {
                return;
            }
            String name = GetterUtil.getString((Object)inputEditorTaglibAttributes.get("liferay-ui:input-editor:name"));
            boolean inlineEdit = GetterUtil.getBoolean((Object)inputEditorTaglibAttributes.get("liferay-ui:input-editor:inlineEdit"));
            if (!inlineEdit) {
                String namespace = GetterUtil.getString((Object)inputEditorTaglibAttributes.get("liferay-ui:input-editor:namespace"));
                name = namespace + name;
            }
            itemSelectedEventName = name + "selectItem";
        } else {
            itemSelectorCriteria = this.itemSelector.getItemSelectorCriteria(documentBrowseLinkUrl);
            itemSelectedEventName = this.itemSelector.getItemSelectedEventName(documentBrowseLinkUrl);
            if (wikiPageResourcePrimKey != 0L) {
                itemSelectorCriteria.add(0, this.getWikiAttachmentItemSelectorCriterion(wikiPageResourcePrimKey));
            }
            if (nodeId != 0L) {
                itemSelectorCriteria.add(0, this.getWikiPageItemSelectorCriterion(nodeId));
            }
        }
        PortletURL itemSelectorURL = this.itemSelector.getItemSelectorURL(requestBackedPortletURLFactory, itemSelectedEventName, itemSelectorCriteria.toArray(new ItemSelectorCriterion[0]));
        jsonObject.put("documentBrowseLinkUrl", itemSelectorURL.toString());
    }

    protected abstract ItemSelectorReturnType getItemSelectorReturnType();

    protected ItemSelectorCriterion getWikiAttachmentItemSelectorCriterion(long wikiPageResourcePrimKey) {
        WikiAttachmentItemSelectorCriterion itemSelectorCriterion = new WikiAttachmentItemSelectorCriterion(wikiPageResourcePrimKey);
        itemSelectorCriterion.setDesiredItemSelectorReturnTypes(new ItemSelectorReturnType[]{new URLItemSelectorReturnType()});
        return itemSelectorCriterion;
    }

    protected ItemSelectorCriterion getWikiPageItemSelectorCriterion(long nodeId) {
        WikiPageItemSelectorCriterion itemSelectorCriterion = new WikiPageItemSelectorCriterion(nodeId, 0);
        itemSelectorCriterion.setDesiredItemSelectorReturnTypes(new ItemSelectorReturnType[]{this.getItemSelectorReturnType()});
        return itemSelectorCriterion;
    }
}

