/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.web.proxy.web.internal.servlet.request;

import com.liferay.portal.upload.LiferayServletRequest;

import java.io.IOException;
import java.io.InputStream;

import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

/**
 * @author Daniel Couso
 */
public class WebProxyServletRequest extends HttpServletRequestWrapper {

	public WebProxyServletRequest(HttpServletRequest httpServletRequest)
		throws IOException {

		super(httpServletRequest);

		_liferayServletRequest = new LiferayServletRequest(httpServletRequest);

		_readInputStream(_liferayServletRequest.getInputStream());

		_liferayServletRequest.setFinishedReadingOriginalStream(true);
	}

	@Override
	public ServletInputStream getInputStream() throws IOException {
		if (_liferayServletRequest != null) {
			return _liferayServletRequest.getInputStream();
		}

		return super.getInputStream();
	}

	private void _readInputStream(InputStream inputStream) throws IOException {
		byte[] buffer = new byte[4096];

		while (inputStream.read(buffer, 0, 4096) > 0) {
		}
	}

	private final LiferayServletRequest _liferayServletRequest;

}