/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.web.proxy.web.internal.portlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.servlet.BufferCacheServletResponse;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.LiferayPortletUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Dictionary;
import javax.portlet.Portlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.Servlet;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.portletbridge.portlet.PortletBridgePortlet;
import org.portletbridge.portlet.PortletBridgeServlet;

@Component(immediate=true, property={"com.liferay.portlet.css-class-wrapper=portlet-web-proxy", "com.liferay.portlet.display-category=category.hidden", "com.liferay.portlet.instanceable=true", "com.liferay.portlet.preferences-owned-by-group=true", "com.liferay.portlet.private-request-attributes=false", "com.liferay.portlet.private-session-attributes=true", "com.liferay.portlet.render-weight=50", "javax.portlet.display-name=Web Proxy", "javax.portlet.expiration-cache=0", "javax.portlet.init-param.authenticatorClassName=org.portletbridge.portlet.DefaultBridgeAuthenticator", "javax.portlet.init-param.cssRegex=(?:url\\((?:'|\")?(.*?)(?:'|\")?\\))|(?:@import\\s+[^url](?:'|\")?(.*?)(?:'|\")|;|\\s+|$)", "javax.portlet.init-param.editStylesheet=classpath:/org/portletbridge/xsl/pages/edit.xsl", "javax.portlet.init-param.errorStylesheet=classpath:/org/portletbridge/xsl/pages/error.xsl", "javax.portlet.init-param.helpStylesheet=classpath:/org/portletbridge/xsl/pages/help.xsl", "javax.portlet.init-param.idParamKey=id", "javax.portlet.init-param.jsRegex=open\\('([^']*)'|open\\(\"([^\\\"]*)\"", "javax.portlet.init-param.mementoSessionKey=mementoSessionKey", "javax.portlet.init-param.parserClassName=org.cyberneko.html.parsers.SAXParser", "javax.portlet.init-param.servletName=pbhs", "javax.portlet.init-param.stylesheetUrl=classpath:/org/portletbridge/xsl/default.xsl", "javax.portlet.name=com_liferay_web_proxy_web_portlet_WebProxyPortlet", "javax.portlet.preferences=classpath:/META-INF/portlet-preferences/default-portlet-preferences.xml", "javax.portlet.resource-bundle=content.Language", "javax.portlet.security-role-ref=administrator"}, service={Portlet.class})
public class WebProxyPortlet
extends PortletBridgePortlet {
    private static final Log _log = LogFactoryUtil.getLog(WebProxyPortlet.class);
    private ComponentContext _componentContext;
    private boolean _enabled;
    private ServiceRegistration<?> _serviceRegistration;

    public void destroy() {
        if (this._serviceRegistration != null) {
            this._serviceRegistration.unregister();
        }
        super.destroy();
    }

    public void doView(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        if (!this._enabled) {
            this.printError(renderResponse);
            return;
        }
        PortletPreferences portletPreferences = renderRequest.getPreferences();
        String initUrl = portletPreferences.getValue("initUrl", "");
        if (Validator.isNull((String)initUrl)) {
            PortletContext portletContext = this.getPortletContext();
            PortletRequestDispatcher portletRequestDispatcher = portletContext.getRequestDispatcher("/portlet_not_setup.jsp");
            portletRequestDispatcher.include(renderRequest, renderResponse);
        } else {
            super.doView(renderRequest, renderResponse);
            LiferayPortletResponse liferayPortletResponse = LiferayPortletUtil.getLiferayPortletResponse((PortletResponse)renderResponse);
            BufferCacheServletResponse bufferCacheServletResponse = (BufferCacheServletResponse)liferayPortletResponse.getHttpServletResponse();
            String output = bufferCacheServletResponse.getString();
            output = StringUtil.replace((String)output, (String)"//pbhs/", (String)(renderRequest.getContextPath() + "/pbhs/"));
            bufferCacheServletResponse.setString(output);
        }
    }

    public void init() {
        block2: {
            try {
                super.init();
                this.doInit();
                this._enabled = true;
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)e.getMessage());
            }
        }
    }

    @Activate
    protected void activate(ComponentContext componentContext) {
        this._componentContext = componentContext;
    }

    @Deactivate
    protected void deactivate() {
        this._componentContext = null;
    }

    protected void doInit() {
        BundleContext bundleContext = this._componentContext.getBundleContext();
        HashMapDictionary properties = new HashMapDictionary();
        PortletConfig portletConfig = this.getPortletConfig();
        PortletContext portletContext = this.getPortletContext();
        properties.put("osgi.http.whiteboard.context.select", portletContext.getPortletContextName());
        properties.put("osgi.http.whiteboard.servlet.name", PortletBridgeServlet.class.getName());
        properties.put("osgi.http.whiteboard.servlet.pattern", "/pbhs/*");
        properties.put("servlet.init.cssRegex", portletConfig.getInitParameter("cssRegex"));
        properties.put("servlet.init.ignorePostToGetRequestHeaders", "content-type,content-length");
        properties.put("servlet.init.ignoreRequestHeaders", "accept-encoding,connection,keep-alive");
        properties.put("servlet.init.jsRegex", portletConfig.getInitParameter("jsRegex"));
        properties.put("servlet.init.mementoSessionKey", portletConfig.getInitParameter("mementoSessionKey"));
        this._serviceRegistration = bundleContext.registerService(Servlet.class, (Object)new PortletBridgeServlet(), (Dictionary)properties);
    }

    protected void printError(RenderResponse renderResponse) throws IOException {
        renderResponse.setContentType("text/html; charset=UTF-8");
        try (PrintWriter writer = renderResponse.getWriter();){
            writer.print("WebProxyPortlet will not be enabled unless Liferay's serializer.jar and xalan.jar files are copied to the JDK's endorsed directory");
        }
    }

    @Reference(target="(&(release.bundle.symbolic.name=com.liferay.web.proxy.web)(release.schema.version=1.0.0))", unbind="-")
    protected void setRelease(Release release) {
    }
}

