/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.web.form.web.internal.portlet;

import com.liferay.captcha.util.CaptchaUtil;
import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.expando.kernel.model.ExpandoRow;
import com.liferay.expando.kernel.service.ExpandoRowLocalService;
import com.liferay.expando.kernel.service.ExpandoTableLocalService;
import com.liferay.expando.kernel.service.ExpandoValueLocalService;
import com.liferay.mail.kernel.model.MailMessage;
import com.liferay.mail.kernel.service.MailService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.captcha.CaptchaTextException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletResponseUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCPortlet;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.web.form.web.configuration.WebFormServiceConfiguration;
import com.liferay.web.form.web.internal.util.WebFormUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.mail.internet.InternetAddress;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.MimeResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"com.liferay.portlet.css-class-wrapper=web-form-portlet", "com.liferay.portlet.display-category=category.tools", "com.liferay.portlet.header-portlet-css=/css/main.css", "com.liferay.portlet.icon=/icons/web_form.png", "com.liferay.portlet.use-default-template=true", "javax.portlet.display-name=Web Form", "javax.portlet.expiration-cache=0", "javax.portlet.init-param.copy-request-parameters=true", "javax.portlet.init-param.template-path=/META-INF/resources/", "javax.portlet.init-param.view-template=/view.jsp", "javax.portlet.name=com_liferay_web_form_web_portlet_WebFormPortlet", "javax.portlet.portlet-info.keywords=Web Form", "javax.portlet.portlet-info.short-title=Web Form", "javax.portlet.portlet-info.title=Web Form", "javax.portlet.preferences=classpath:/META-INF/portlet-preferences/default-portlet-preferences.xml", "javax.portlet.resource-bundle=content.Language", "javax.portlet.security-role-ref=administrator,guest,power-user,user", "javax.portlet.supports.mime-type=text/html"}, service={Portlet.class})
public class WebFormPortlet
extends MVCPortlet {
    private static final Log _log = LogFactoryUtil.getLog(WebFormPortlet.class);
    private static CounterLocalService _counterLocalService;
    private static ExpandoRowLocalService _expandoRowLocalService;
    private static ExpandoTableLocalService _expandoTableLocalService;
    private static ExpandoValueLocalService _expandoValueLocalService;
    private static MailService _mailService;
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private Portal _portal;

    public void deleteData(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String portletId = this._portal.getPortletId((PortletRequest)actionRequest);
        PortletPermissionUtil.check((PermissionChecker)themeDisplay.getPermissionChecker(), (long)themeDisplay.getPlid(), (String)portletId, (String)"CONFIGURATION");
        PortletPreferences preferences = PortletPreferencesFactoryUtil.getPortletSetup((PortletRequest)actionRequest);
        String databaseTableName = preferences.getValue("databaseTableName", "");
        if (Validator.isNotNull((String)databaseTableName)) {
            _expandoTableLocalService.deleteTable(themeDisplay.getCompanyId(), WebFormUtil.class.getName(), databaseTableName);
        }
    }

    public void saveData(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String fieldLabel;
        String portletId = this._portal.getPortletId((PortletRequest)actionRequest);
        PortletPreferences preferences = PortletPreferencesFactoryUtil.getPortletSetup((PortletRequest)actionRequest, (String)portletId);
        boolean requireCaptcha = GetterUtil.getBoolean((String)preferences.getValue("requireCaptcha", ""));
        if (requireCaptcha) {
            try {
                CaptchaUtil.check((PortletRequest)actionRequest);
            }
            catch (CaptchaTextException cte) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)cte, (Throwable)cte);
                }
                SessionErrors.add((PortletRequest)actionRequest, (String)CaptchaTextException.class.getName());
                return;
            }
        }
        LinkedHashMap<String, String> fieldsMap = new LinkedHashMap<String, String>();
        int i = 1;
        while (!Validator.isNull((String)(fieldLabel = preferences.getValue("fieldLabel" + i, "")))) {
            String fieldType = preferences.getValue("fieldType" + i, "");
            if (!StringUtil.equalsIgnoreCase((String)fieldType, (String)"paragraph")) {
                fieldsMap.put(fieldLabel, actionRequest.getParameter("field" + i));
            }
            ++i;
        }
        Set<String> validationErrors = null;
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        WebFormServiceConfiguration webFormServiceConfiguration = this.getWebFormServiceConfiguration(themeDisplay.getCompanyId());
        try {
            validationErrors = this.validate(fieldsMap, webFormServiceConfiguration.validationScriptEnable(), preferences);
        }
        catch (Exception e) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"validationScriptError", (Object)StringUtil.trim((String)e.getMessage()));
            return;
        }
        String successURL = GetterUtil.getString((String)preferences.getValue("successURL", ""));
        if (validationErrors.isEmpty()) {
            boolean saveToFile;
            boolean saveToDatabase;
            boolean emailSuccess = true;
            boolean databaseSuccess = true;
            boolean fileSuccess = true;
            boolean sendAsEmail = GetterUtil.getBoolean((String)preferences.getValue("sendAsEmail", ""));
            if (sendAsEmail) {
                emailSuccess = this.sendEmail(fieldsMap, preferences, webFormServiceConfiguration);
            }
            if (saveToDatabase = GetterUtil.getBoolean((String)preferences.getValue("saveToDatabase", ""))) {
                String databaseTableName = GetterUtil.getString((String)preferences.getValue("databaseTableName", ""));
                if (Validator.isNull((String)databaseTableName)) {
                    databaseTableName = WebFormUtil.getNewDatabaseTableName(portletId);
                    preferences.setValue("databaseTableName", databaseTableName);
                    preferences.store();
                }
                databaseSuccess = this.saveDatabase(themeDisplay.getCompanyId(), fieldsMap, preferences, databaseTableName);
            }
            if (saveToFile = GetterUtil.getBoolean((String)preferences.getValue("saveToFile", ""))) {
                String fileName = WebFormUtil.getFileName(themeDisplay, portletId, webFormServiceConfiguration.dataRootDir());
                fileSuccess = this.saveFile(fieldsMap, webFormServiceConfiguration.csvSeparator(), fileName);
            }
            if (emailSuccess && databaseSuccess && fileSuccess) {
                if (Validator.isNull((String)successURL)) {
                    SessionMessages.add((PortletRequest)actionRequest, (String)"success");
                } else {
                    SessionMessages.add((PortletRequest)actionRequest, (String)(portletId + ".hideDefaultSuccessMessage"));
                }
            } else {
                SessionErrors.add((PortletRequest)actionRequest, (String)"error");
            }
        } else {
            for (String badField : validationErrors) {
                SessionErrors.add((PortletRequest)actionRequest, (String)("error" + badField));
            }
        }
        if (SessionErrors.isEmpty((PortletRequest)actionRequest) && Validator.isNotNull((String)successURL)) {
            actionResponse.sendRedirect(successURL);
        }
    }

    public void serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) {
        String cmd = ParamUtil.getString((PortletRequest)resourceRequest, (String)"cmd");
        try {
            if (cmd.equals("captcha")) {
                this.serveCaptcha(resourceRequest, resourceResponse);
            } else if (cmd.equals("export")) {
                this.exportData(resourceRequest, resourceResponse);
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    protected void appendFieldLabels(Map<String, String> fieldsMap, String csvSeparator, StringBundler sb) {
        for (String fieldLabel : fieldsMap.keySet()) {
            sb.append(this.getCSVFormattedValue(fieldLabel));
            sb.append(csvSeparator);
        }
        sb.setIndex(sb.index() - 1);
        sb.append('\n');
    }

    protected void appendFieldValues(Map<String, String> fieldsMap, String csvSeparator, StringBundler sb) {
        for (Map.Entry<String, String> entry : fieldsMap.entrySet()) {
            sb.append(this.getCSVFormattedValue(entry.getValue()));
            sb.append(csvSeparator);
        }
        sb.setIndex(sb.index() - 1);
        sb.append('\n');
    }

    protected void exportData(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        Object fieldLabel;
        ThemeDisplay themeDisplay = (ThemeDisplay)resourceRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String portletId = this._portal.getPortletId((PortletRequest)resourceRequest);
        PortletPermissionUtil.check((PermissionChecker)themeDisplay.getPermissionChecker(), (long)themeDisplay.getPlid(), (String)portletId, (String)"CONFIGURATION");
        PortletPreferences preferences = PortletPreferencesFactoryUtil.getPortletSetup((PortletRequest)resourceRequest);
        String databaseTableName = preferences.getValue("databaseTableName", "");
        String title = preferences.getValue("title", "no-title");
        StringBundler sb = new StringBundler();
        ArrayList<String> fieldLabels = new ArrayList<String>();
        WebFormServiceConfiguration webFormServiceConfiguration = this.getWebFormServiceConfiguration(themeDisplay.getCompanyId());
        String csvSeparator = webFormServiceConfiguration.csvSeparator();
        int i = 1;
        while (!Validator.isNull((String)(fieldLabel = preferences.getValue("fieldLabel" + i, "")))) {
            fieldLabels.add((String)fieldLabel);
            String localizedfieldLabel = LocalizationUtil.getPreferencesValue((PortletPreferences)preferences, (String)("fieldLabel" + i), (String)themeDisplay.getLanguageId());
            sb.append(this.getCSVFormattedValue(localizedfieldLabel));
            sb.append(csvSeparator);
            ++i;
        }
        sb.setIndex(sb.index() - 1);
        sb.append('\n');
        if (Validator.isNotNull((String)databaseTableName)) {
            List rows = _expandoRowLocalService.getRows(themeDisplay.getCompanyId(), WebFormUtil.class.getName(), databaseTableName, -1, -1);
            for (ExpandoRow row : rows) {
                for (String fieldName : fieldLabels) {
                    String data = _expandoValueLocalService.getData(themeDisplay.getCompanyId(), WebFormUtil.class.getName(), databaseTableName, fieldName, row.getClassPK(), "");
                    sb.append(this.getCSVFormattedValue(data));
                    sb.append(csvSeparator);
                }
                sb.setIndex(sb.index() - 1);
                sb.append('\n');
            }
        }
        String fileName = title + ".csv";
        String s = sb.toString();
        byte[] bytes = s.getBytes();
        String contentType = "application/text";
        PortletResponseUtil.sendFile((PortletRequest)resourceRequest, (MimeResponse)resourceResponse, (String)fileName, (byte[])bytes, (String)contentType);
    }

    protected String getCSVFormattedValue(String value) {
        StringBundler sb = new StringBundler(3);
        sb.append('\"');
        sb.append(StringUtil.replace((String)value, (char)'\"', (String)"\"\""));
        sb.append('\"');
        return sb.toString();
    }

    protected String getMailBody(Map<String, String> fieldsMap) {
        StringBundler sb = new StringBundler();
        for (Map.Entry<String, String> entry : fieldsMap.entrySet()) {
            sb.append(entry.getKey());
            sb.append(" : ");
            sb.append(entry.getValue());
            sb.append('\n');
        }
        return sb.toString();
    }

    protected WebFormServiceConfiguration getWebFormServiceConfiguration(long companyId) throws PortalException {
        return (WebFormServiceConfiguration)this._configurationProvider.getCompanyConfiguration(WebFormServiceConfiguration.class, companyId);
    }

    protected boolean saveDatabase(long companyId, Map<String, String> fieldsMap, PortletPreferences preferences, String databaseTableName) throws Exception {
        WebFormUtil.checkTable(companyId, databaseTableName, preferences);
        long classPK = _counterLocalService.increment(WebFormUtil.class.getName());
        try {
            for (Map.Entry<String, String> entry : fieldsMap.entrySet()) {
                _expandoValueLocalService.addValue(companyId, WebFormUtil.class.getName(), databaseTableName, entry.getKey(), classPK, entry.getValue());
            }
            return true;
        }
        catch (Exception e) {
            _log.error((Object)"The web form data could not be saved to the database", (Throwable)e);
            return false;
        }
    }

    protected boolean saveFile(Map<String, String> fieldsMap, String csvSeparator, String fileName) throws PortalException {
        StringBundler sb = new StringBundler();
        if (!FileUtil.exists((String)fileName)) {
            this.appendFieldLabels(fieldsMap, csvSeparator, sb);
        }
        this.appendFieldValues(fieldsMap, csvSeparator, sb);
        try {
            FileUtil.write((String)fileName, (String)sb.toString(), (boolean)false, (boolean)true);
            return true;
        }
        catch (Exception e) {
            _log.error((Object)"The web form data could not be saved to a file", (Throwable)e);
            return false;
        }
    }

    protected boolean sendEmail(Map<String, String> fieldsMap, PortletPreferences preferences, WebFormServiceConfiguration webFormServiceConfiguration) {
        try {
            String emailAddresses = preferences.getValue("emailAddress", "");
            if (Validator.isNull((String)emailAddresses)) {
                _log.error((Object)"The web form email cannot be sent because no email address is configured");
                return false;
            }
            String emailFromAddress = preferences.getValue("emailFromAddress", webFormServiceConfiguration.emailFromAddress());
            String emailFromName = preferences.getValue("emailFromName", webFormServiceConfiguration.emailFromName());
            InternetAddress fromAddress = new InternetAddress(emailFromAddress, emailFromName);
            String subject = preferences.getValue("subject", "");
            String body = this.getMailBody(fieldsMap);
            MailMessage mailMessage = new MailMessage(fromAddress, subject, body, false);
            InternetAddress[] toAddresses = InternetAddress.parse((String)emailAddresses);
            mailMessage.setTo(toAddresses);
            _mailService.sendEmail(mailMessage);
            return true;
        }
        catch (Exception e) {
            _log.error((Object)"The web form email could not be sent", (Throwable)e);
            return false;
        }
    }

    protected void serveCaptcha(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        CaptchaUtil.serveImage((ResourceRequest)resourceRequest, (ResourceResponse)resourceResponse);
    }

    @Reference(unbind="-")
    protected void setCounterLocalService(CounterLocalService counterLocalService) {
        _counterLocalService = counterLocalService;
    }

    @Reference(unbind="-")
    protected void setExpandoRowLocalService(ExpandoRowLocalService expandoRowLocalService) {
        _expandoRowLocalService = expandoRowLocalService;
    }

    @Reference(unbind="-")
    protected void setExpandoTableLocalService(ExpandoTableLocalService expandoTableLocalService) {
        _expandoTableLocalService = expandoTableLocalService;
    }

    @Reference(unbind="-")
    protected void setExpandoValueLocalService(ExpandoValueLocalService expandoValueLocalService) {
        _expandoValueLocalService = expandoValueLocalService;
    }

    @Reference(unbind="-")
    protected void setMailService(MailService mailService) {
        _mailService = mailService;
    }

    protected Set<String> validate(Map<String, String> fieldsMap, boolean validationScriptEnable, PortletPreferences preferences) throws Exception {
        HashSet<String> validationErrors = new HashSet<String>();
        for (int i = 0; i < fieldsMap.size(); ++i) {
            String validationScript;
            String fieldType = preferences.getValue("fieldType" + (i + 1), "");
            if (Objects.equals(fieldType, "paragraph")) continue;
            String fieldLabel = preferences.getValue("fieldLabel" + (i + 1), "");
            String fieldValue = fieldsMap.get(fieldLabel);
            boolean fieldOptional = GetterUtil.getBoolean((String)preferences.getValue("fieldOptional" + (i + 1), ""));
            if (!fieldOptional && Validator.isNotNull((String)fieldLabel) && Validator.isNull((String)fieldValue)) {
                validationErrors.add(fieldLabel);
                continue;
            }
            if (!validationScriptEnable || !Validator.isNotNull((String)(validationScript = GetterUtil.getString((String)preferences.getValue("fieldValidationScript" + (i + 1), "")))) || WebFormUtil.validate(fieldValue, fieldsMap, validationScript)) continue;
            validationErrors.add(fieldLabel);
        }
        return validationErrors;
    }
}

