/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.web.form.web.internal.util;

import com.liferay.counter.kernel.service.CounterLocalServiceUtil;
import com.liferay.expando.kernel.exception.NoSuchTableException;
import com.liferay.expando.kernel.model.ExpandoTable;
import com.liferay.expando.kernel.service.ExpandoColumnLocalServiceUtil;
import com.liferay.expando.kernel.service.ExpandoRowLocalServiceUtil;
import com.liferay.expando.kernel.service.ExpandoTableLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Map;
import javax.portlet.PortletPreferences;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class WebFormUtil {
    private static final Log _log = LogFactoryUtil.getLog(WebFormUtil.class);

    public static ExpandoTable addTable(long companyId, String tableName) throws PortalException {
        block2: {
            try {
                ExpandoTableLocalServiceUtil.deleteTable((long)companyId, (String)WebFormUtil.class.getName(), (String)tableName);
            }
            catch (NoSuchTableException nste) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Object)nste, (Throwable)nste);
            }
        }
        return ExpandoTableLocalServiceUtil.addTable((long)companyId, (String)WebFormUtil.class.getName(), (String)tableName);
    }

    public static ExpandoTable checkTable(long companyId, String tableName, PortletPreferences preferences) throws Exception {
        ExpandoTable expandoTable = null;
        try {
            expandoTable = ExpandoTableLocalServiceUtil.getTable((long)companyId, (String)WebFormUtil.class.getName(), (String)tableName);
        }
        catch (NoSuchTableException nste) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)nste, (Throwable)nste);
            }
            expandoTable = WebFormUtil.addTable(companyId, tableName);
            int i = 1;
            String fieldLabel = preferences.getValue("fieldLabel" + i, "");
            String fieldType = preferences.getValue("fieldType" + i, "");
            while (i == 1 || Validator.isNotNull((String)fieldLabel)) {
                if (!StringUtil.equalsIgnoreCase((String)fieldType, (String)"paragraph")) {
                    ExpandoColumnLocalServiceUtil.addColumn((long)expandoTable.getTableId(), (String)fieldLabel, (int)15);
                }
                fieldLabel = preferences.getValue("fieldLabel" + ++i, "");
                fieldType = preferences.getValue("fieldType" + i, "");
            }
        }
        return expandoTable;
    }

    public static String getFileName(ThemeDisplay themeDisplay, String portletId, String dataRootDir) {
        StringBuffer sb = new StringBuffer(8);
        sb.append(dataRootDir);
        sb.append("/");
        sb.append(themeDisplay.getScopeGroupId());
        sb.append("/");
        sb.append(themeDisplay.getPlid());
        sb.append("/");
        sb.append(portletId);
        sb.append(".csv");
        return sb.toString();
    }

    public static String getNewDatabaseTableName(String portletId) {
        long formId = CounterLocalServiceUtil.increment((String)WebFormUtil.class.getName());
        return portletId + "_" + formId;
    }

    public static int getTableRowsCount(long companyId, String tableName) {
        return ExpandoRowLocalServiceUtil.getRowsCount((long)companyId, (String)WebFormUtil.class.getName(), (String)tableName);
    }

    public static String[] split(String s) {
        return WebFormUtil.split(s, ",");
    }

    public static String[] split(String s, String delimiter) {
        if (s == null || delimiter == null) {
            return new String[0];
        }
        if (!(s = s.trim()).endsWith(delimiter)) {
            s = s.concat(delimiter);
        }
        if (s.equals(delimiter)) {
            return new String[0];
        }
        ArrayList<String> nodeValues = new ArrayList<String>();
        if (delimiter.equals("\n") || delimiter.equals("\r")) {
            try {
                BufferedReader br = new BufferedReader(new StringReader(s));
                String line = null;
                while ((line = br.readLine()) != null) {
                    nodeValues.add(line);
                }
                br.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        } else {
            int offset = 0;
            int pos = s.indexOf(delimiter, offset);
            while (pos != -1) {
                nodeValues.add(new String(s.substring(offset, pos)));
                offset = pos + delimiter.length();
                pos = s.indexOf(delimiter, offset);
            }
        }
        return nodeValues.toArray(new String[nodeValues.size()]);
    }

    public static boolean validate(String currentFieldValue, Map<String, String> fieldsMap, String validationScript) throws Exception {
        boolean validationResult;
        block7: {
            validationResult = false;
            Context context = Context.enter();
            StringBundler sb = new StringBundler();
            sb.append("currentFieldValue = String('");
            sb.append(HtmlUtil.escapeJS((String)currentFieldValue));
            sb.append("');\n");
            sb.append("var fieldsMap = {};\n");
            for (String key : fieldsMap.keySet()) {
                sb.append("fieldsMap['");
                sb.append(key);
                sb.append("'] = '");
                String value = StringUtil.replace((String)fieldsMap.get(key), (String[])new String[]{"\r\n", "\r", "\n"}, (String[])new String[]{"\\n", "\\n", "\\n"});
                sb.append(HtmlUtil.escapeJS((String)value));
                sb.append("';\n");
            }
            sb.append("function validation(currentFieldValue, fieldsMap) {\n");
            sb.append(validationScript);
            sb.append("}\n");
            sb.append("internalValidationResult = ");
            sb.append("validation(currentFieldValue, fieldsMap);");
            String script = sb.toString();
            try {
                ScriptableObject scope = context.initStandardObjects();
                Object jsFieldsMap = Context.javaToJS(fieldsMap, (Scriptable)scope);
                ScriptableObject.putProperty((Scriptable)scope, (String)"jsFieldsMap", (Object)jsFieldsMap);
                context.evaluateString((Scriptable)scope, script, "Validation Script", 1, null);
                Object obj = ScriptableObject.getProperty((Scriptable)scope, (String)"internalValidationResult");
                if (obj instanceof Boolean) {
                    validationResult = (Boolean)obj;
                    break block7;
                }
                throw new Exception("The script must return a boolean value");
            }
            catch (Exception e) {
                String msg = StringBundler.concat((String[])new String[]{"The following script has execution errors:\n", validationScript, "\n", e.getMessage()});
                _log.error((Object)msg);
                throw new Exception(msg, e);
            }
            finally {
                Context.exit();
            }
        }
        return validationResult;
    }
}

