/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.web.form.web.internal.portlet.action;

import com.liferay.expando.kernel.exception.ColumnNameException;
import com.liferay.expando.kernel.exception.DuplicateColumnNameException;
import com.liferay.portal.kernel.portlet.ConfigurationAction;
import com.liferay.portal.kernel.portlet.DefaultConfigurationAction;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.web.form.web.internal.util.WebFormUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_web_form_web_portlet_WebFormPortlet"}, service={ConfigurationAction.class})
public class WebFormConfigurationAction
extends DefaultConfigurationAction {
    public String getJspPath(HttpServletRequest request) {
        String cmd = ParamUtil.getString((HttpServletRequest)request, (String)"cmd");
        if (cmd.equals("add")) {
            return "/edit_field.jsp";
        }
        return "/configuration.jsp";
    }

    public void processAction(PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        this.validateFields(actionRequest);
        if (!SessionErrors.isEmpty((PortletRequest)actionRequest)) {
            return;
        }
        Locale defaultLocale = LocaleUtil.getSiteDefault();
        String defaultLanguageId = LocaleUtil.toLanguageId((Locale)defaultLocale);
        boolean updateFields = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"updateFields");
        String portletResource = ParamUtil.getString((PortletRequest)actionRequest, (String)"portletResource");
        PortletPreferences preferences = actionRequest.getPreferences();
        LocalizationUtil.setLocalizedPreferencesValues((PortletRequest)actionRequest, (PortletPreferences)preferences, (String)"title");
        Map titleMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"title");
        preferences.setValue("title", (String)titleMap.get(defaultLocale));
        LocalizationUtil.setLocalizedPreferencesValues((PortletRequest)actionRequest, (PortletPreferences)preferences, (String)"description");
        Map descriptionMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"description");
        preferences.setValue("description", (String)descriptionMap.get(defaultLocale));
        if (updateFields) {
            int[] formFieldsIndexes;
            int i = 1;
            String databaseTableName = WebFormUtil.getNewDatabaseTableName(portletResource);
            preferences.setValue("databaseTableName", databaseTableName);
            for (int formFieldsIndex : formFieldsIndexes = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"formFieldsIndexes"), (int)0)) {
                Map fieldLabelMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)("fieldLabel" + formFieldsIndex));
                if (Validator.isNull((String)((String)fieldLabelMap.get(defaultLocale)))) continue;
                String fieldType = ParamUtil.getString((PortletRequest)actionRequest, (String)("fieldType" + formFieldsIndex));
                boolean fieldOptional = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)("fieldOptional" + formFieldsIndex));
                Map fieldOptionsMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)("fieldOptions" + formFieldsIndex));
                Map fieldParagraphMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)("fieldParagraph" + formFieldsIndex));
                String fieldValidationScript = ParamUtil.getString((PortletRequest)actionRequest, (String)("fieldValidationScript" + formFieldsIndex));
                String fieldValidationErrorMessage = ParamUtil.getString((PortletRequest)actionRequest, (String)("fieldValidationErrorMessage" + formFieldsIndex));
                if (Validator.isNotNull((String)fieldValidationScript) ^ Validator.isNotNull((String)fieldValidationErrorMessage)) {
                    SessionErrors.add((PortletRequest)actionRequest, (String)("validationDefinitionInvalid" + i));
                }
                this.updateModifiedLocales("fieldLabel" + i, fieldLabelMap, preferences);
                this.updateModifiedLocales("fieldOptions" + i, fieldOptionsMap, preferences);
                this.updateModifiedLocales("fieldParagraph" + i, fieldParagraphMap, preferences);
                preferences.setValue("fieldLabel" + i, (String)fieldLabelMap.get(defaultLocale));
                preferences.setValue("fieldType" + i, fieldType);
                preferences.setValue("fieldOptional" + i, String.valueOf(fieldOptional));
                preferences.setValue("fieldOptions" + i, "");
                preferences.setValue("fieldParagraph" + i, "");
                preferences.setValue("fieldValidationScript" + i, fieldValidationScript);
                preferences.setValue("fieldValidationErrorMessage" + i, fieldValidationErrorMessage);
                ++i;
            }
            if (!SessionErrors.isEmpty((PortletRequest)actionRequest)) {
                return;
            }
            String fieldLabel = LocalizationUtil.getPreferencesValue((PortletPreferences)preferences, (String)("fieldLabel" + i), (String)defaultLanguageId);
            while (Validator.isNotNull((String)fieldLabel)) {
                Map fieldLabelMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)("fieldLabel" + i));
                for (Locale locale : fieldLabelMap.keySet()) {
                    String languageId = LocaleUtil.toLanguageId((Locale)locale);
                    LocalizationUtil.setPreferencesValue((PortletPreferences)preferences, (String)("fieldLabel" + i), (String)languageId, (String)"");
                    LocalizationUtil.setPreferencesValue((PortletPreferences)preferences, (String)("fieldOptions" + i), (String)languageId, (String)"");
                    LocalizationUtil.setPreferencesValue((PortletPreferences)preferences, (String)("fieldParagraph" + i), (String)languageId, (String)"");
                }
                preferences.setValue("fieldLabel" + i, "");
                preferences.setValue("fieldType" + i, "");
                preferences.setValue("fieldOptional" + i, "");
                preferences.setValue("fieldValidationScript" + i, "");
                preferences.setValue("fieldValidationErrorMessage" + i, "");
                fieldLabel = LocalizationUtil.getPreferencesValue((PortletPreferences)preferences, (String)("fieldLabel" + ++i), (String)defaultLanguageId);
            }
        }
        if (SessionErrors.isEmpty((PortletRequest)actionRequest)) {
            preferences.store();
        }
        super.processAction(portletConfig, actionRequest, actionResponse);
    }

    protected void updateModifiedLocales(String parameter, Map<Locale, String> newLocalizationMap, PortletPreferences preferences) throws Exception {
        Map oldLocalizationMap = LocalizationUtil.getLocalizationMap((PortletPreferences)preferences, (String)parameter);
        List modifiedLocales = LocalizationUtil.getModifiedLocales((Map)oldLocalizationMap, newLocalizationMap);
        for (Locale locale : modifiedLocales) {
            String languageId = LocaleUtil.toLanguageId((Locale)locale);
            String value = newLocalizationMap.get(locale);
            LocalizationUtil.setPreferencesValue((PortletPreferences)preferences, (String)parameter, (String)languageId, (String)value);
        }
    }

    protected void validateEmailFields(ActionRequest actionRequest) {
        String subject = this.getParameter((PortletRequest)actionRequest, "subject");
        if (Validator.isNull((String)subject)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"subjectRequired");
        }
        String[] emailAdresses = WebFormUtil.split(this.getParameter((PortletRequest)actionRequest, "emailAddress"));
        String emailFromAddress = GetterUtil.getString((String)this.getParameter((PortletRequest)actionRequest, "emailFromAddress"));
        if (emailAdresses.length == 0 || Validator.isNull((String)emailFromAddress)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"emailAddressRequired");
        }
        if (Validator.isNotNull((String)emailFromAddress) && !Validator.isEmailAddress((String)emailFromAddress)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"emailAddressInvalid");
        } else {
            for (String emailAdress : emailAdresses) {
                if (Validator.isEmailAddress((String)(emailAdress = emailAdress.trim()))) continue;
                SessionErrors.add((PortletRequest)actionRequest, (String)"emailAddressInvalid");
                break;
            }
        }
    }

    protected void validateFieldNameLength(ActionRequest actionRequest) {
        Locale defaultLocale = LocaleUtil.getSiteDefault();
        int[] formFieldsIndexes = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"formFieldsIndexes"), (int)0);
        boolean saveToDatabase = GetterUtil.getBoolean((String)this.getParameter((PortletRequest)actionRequest, "saveToDatabase"));
        for (int formFieldsIndex : formFieldsIndexes) {
            Map fieldLabelMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)("fieldLabel" + formFieldsIndex));
            for (Locale locale : fieldLabelMap.keySet()) {
                String fieldLabelValue = (String)fieldLabelMap.get(locale);
                if (locale.equals(defaultLocale) && Validator.isNull((String)fieldLabelValue)) {
                    SessionErrors.add((PortletRequest)actionRequest, (String)ColumnNameException.class.getName());
                    return;
                }
                if (!Validator.isNotNull((String)fieldLabelValue) || !saveToDatabase || fieldLabelValue.length() <= 75) continue;
                SessionErrors.add((PortletRequest)actionRequest, (String)("fieldSizeInvalid" + formFieldsIndex));
                return;
            }
        }
    }

    protected void validateFields(ActionRequest actionRequest) throws Exception {
        String successURL;
        boolean saveToDatabase = GetterUtil.getBoolean((String)this.getParameter((PortletRequest)actionRequest, "saveToDatabase"));
        boolean saveToFile = GetterUtil.getBoolean((String)this.getParameter((PortletRequest)actionRequest, "saveToFile"));
        boolean sendAsEmail = GetterUtil.getBoolean((String)this.getParameter((PortletRequest)actionRequest, "sendAsEmail"));
        if (!(saveToDatabase || saveToFile || sendAsEmail)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"handlingRequired");
        }
        if (sendAsEmail) {
            this.validateEmailFields(actionRequest);
        }
        if (Validator.isNotNull((String)(successURL = this.getParameter((PortletRequest)actionRequest, "successURL"))) && !Validator.isUrl((String)successURL)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"successURLInvalid");
        }
        this.validateFieldNameLength(actionRequest);
        this.validateUniqueFieldNames(actionRequest);
    }

    protected void validateUniqueFieldNames(ActionRequest actionRequest) {
        int[] formFieldsIndexes;
        Locale defaultLocale = LocaleUtil.getSiteDefault();
        HashSet<String> localizedUniqueFieldNames = new HashSet<String>();
        for (int formFieldsIndex : formFieldsIndexes = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"formFieldsIndexes"), (int)0)) {
            Map fieldLabelMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)("fieldLabel" + formFieldsIndex));
            if (Validator.isNull((String)((String)fieldLabelMap.get(defaultLocale)))) continue;
            for (Locale locale : fieldLabelMap.keySet()) {
                String languageId;
                String fieldLabelValue = (String)fieldLabelMap.get(locale);
                if (Validator.isNull((String)fieldLabelValue) || localizedUniqueFieldNames.add((languageId = LocaleUtil.toLanguageId((Locale)locale)) + "_" + fieldLabelValue)) continue;
                SessionErrors.add((PortletRequest)actionRequest, (String)DuplicateColumnNameException.class.getName());
                return;
            }
        }
    }
}

