/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.web.internal.util;

import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CSSClassNames {
    public static Builder builder(String ... cssClassNames) {
        Builder builder = new Builder();
        builder.add(cssClassNames);
        return builder;
    }

    private CSSClassNames() {
    }

    public static class Builder {
        private final Stream.Builder<String> _streamBuilder = Stream.builder();

        public Builder add(String cssClassName) {
            return this._add(cssClassName, true);
        }

        public Builder add(String ... cssClassNames) {
            for (String cssClassName : cssClassNames) {
                this._add(cssClassName, true);
            }
            return this;
        }

        public Builder add(String cssClassName, boolean condition) {
            return this._add(cssClassName, condition);
        }

        public String build() {
            return this._build();
        }

        private Builder() {
        }

        private Builder _add(String cssClassName, boolean condition) {
            if (condition) {
                this._streamBuilder.accept(cssClassName);
            }
            return this;
        }

        private String _build() {
            return this._streamBuilder.build().distinct().sorted().collect(Collectors.joining(" "));
        }
    }
}

