/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.web.internal.portlet.action;

import com.liferay.portal.kernel.exception.NoSuchUserException;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.membershippolicy.MembershipPolicyException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.service.UserService;
import com.liferay.portal.kernel.service.permission.OrganizationPermissionUtil;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.users.admin.kernel.util.UsersAdmin;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_my_account_web_portlet_MyAccountPortlet", "javax.portlet.name=com_liferay_users_admin_web_portlet_MyOrganizationsPortlet", "javax.portlet.name=com_liferay_users_admin_web_portlet_UsersAdminPortlet", "mvc.command.name=/users_admin/update_user_roles"}, service={MVCActionCommand.class})
public class UpdateUserRolesMVCActionCommand
extends BaseMVCActionCommand {
    @Reference
    private Http _http;
    @Reference
    private Portal _portal;
    @Reference
    private UsersAdmin _usersAdmin;
    @Reference
    private UserService _userService;

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        try {
            String redirect;
            User user = this._portal.getSelectedUser((PortletRequest)actionRequest);
            Contact contact = user.getContact();
            Calendar birthdayCal = CalendarFactoryUtil.getCalendar();
            birthdayCal.setTime(user.getBirthday());
            long[] roleIds = this._usersAdmin.getRoleIds((PortletRequest)actionRequest);
            List userGroupRoles = null;
            String addGroupRolesGroupIds = actionRequest.getParameter("addGroupRolesGroupIds");
            String addGroupRolesRoleIds = actionRequest.getParameter("addGroupRolesRoleIds");
            String deleteGroupRolesGroupIds = actionRequest.getParameter("deleteGroupRolesGroupIds");
            String deleteGroupRolesRoleIds = actionRequest.getParameter("deleteGroupRolesRoleIds");
            if (addGroupRolesGroupIds != null || addGroupRolesRoleIds != null || deleteGroupRolesGroupIds != null || deleteGroupRolesRoleIds != null) {
                userGroupRoles = this._usersAdmin.getUserGroupRoles((PortletRequest)actionRequest);
            }
            ServiceContext serviceContext = ServiceContextFactory.getInstance((String)User.class.getName(), (PortletRequest)actionRequest);
            user = this._userService.updateUser(user.getUserId(), user.getPassword(), null, null, user.isPasswordReset(), null, null, user.getScreenName(), user.getEmailAddress(), user.getFacebookId(), user.getOpenId(), user.getLanguageId(), user.getTimeZoneId(), user.getGreeting(), user.getComments(), user.getFirstName(), user.getMiddleName(), user.getLastName(), contact.getPrefixId(), contact.getSuffixId(), user.isMale(), birthdayCal.get(2), birthdayCal.get(5), birthdayCal.get(1), contact.getSmsSn(), contact.getFacebookSn(), contact.getJabberSn(), contact.getSkypeSn(), contact.getTwitterSn(), user.getJobTitle(), null, user.getOrganizationIds(), roleIds, userGroupRoles, user.getUserGroupIds(), serviceContext);
            User currentUser = this._userService.getCurrentUser();
            if (currentUser.getUserId() == user.getUserId() && Validator.isNotNull((String)(redirect = this._getRedirect(actionRequest, currentUser)))) {
                this.sendRedirect(actionRequest, actionResponse, redirect);
            }
        }
        catch (Exception e) {
            if (e instanceof NoSuchUserException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                actionResponse.setRenderParameter("mvcPath", "/error.jsp");
            }
            if (e instanceof MembershipPolicyException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass(), (Object)e);
                actionResponse.setRenderParameter("mvcPath", "/edit_user.jsp");
            }
            throw e;
        }
    }

    private String _getRedirect(ActionRequest actionRequest, User currentUser) throws Exception {
        PortletConfig portletConfig = (PortletConfig)actionRequest.getAttribute("javax.portlet.config");
        String portletName = portletConfig.getPortletName();
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)currentUser);
        if (!PortletPermissionUtil.contains((PermissionChecker)permissionChecker, (String)portletName, (String)"ACCESS_IN_CONTROL_PANEL")) {
            HttpServletRequest httpServletRequest = this._portal.getHttpServletRequest((PortletRequest)actionRequest);
            return this._portal.getHomeURL(httpServletRequest);
        }
        if (portletName.equals("com_liferay_users_admin_web_portlet_MyOrganizationsPortlet")) {
            Map parameterMap;
            HttpServletRequest httpServletRequest = this._portal.getHttpServletRequest((PortletRequest)actionRequest);
            String backURL = null;
            long organizationId = 0L;
            String portletNameSpace = this._portal.getPortletNamespace("com_liferay_users_admin_web_portlet_MyOrganizationsPortlet");
            String redirect = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"redirect");
            if (Validator.isNotNull((String)redirect)) {
                parameterMap = this._http.getParameterMap(redirect);
                backURL = ((String[])parameterMap.get(portletNameSpace + "backURL"))[0];
            }
            if (Validator.isNotNull(backURL)) {
                parameterMap = this._http.getParameterMap(backURL);
                organizationId = GetterUtil.getLong((String)((String[])parameterMap.get(portletNameSpace + "organizationId"))[0]);
            }
            if (organizationId > 0L && !OrganizationPermissionUtil.contains((PermissionChecker)permissionChecker, (long)organizationId, (String)"VIEW")) {
                PortletURL portletURL = this._portal.getControlPanelPortletURL(httpServletRequest, portletName, "RENDER_PHASE");
                return portletURL.toString();
            }
        }
        return "";
    }
}

