/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.web.internal.portlet.action;

import com.liferay.asset.kernel.exception.AssetCategoryException;
import com.liferay.asset.kernel.exception.AssetTagException;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.portal.kernel.exception.DuplicateOrganizationException;
import com.liferay.portal.kernel.exception.NoSuchCountryException;
import com.liferay.portal.kernel.exception.NoSuchListTypeException;
import com.liferay.portal.kernel.exception.NoSuchOrganizationException;
import com.liferay.portal.kernel.exception.OrganizationNameException;
import com.liferay.portal.kernel.exception.OrganizationParentException;
import com.liferay.portal.kernel.exception.RequiredOrganizationException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.AddressService;
import com.liferay.portal.kernel.service.EmailAddressService;
import com.liferay.portal.kernel.service.OrgLaborService;
import com.liferay.portal.kernel.service.OrganizationService;
import com.liferay.portal.kernel.service.PhoneService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.service.WebsiteService;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_users_admin_web_portlet_MyOrganizationsPortlet", "javax.portlet.name=com_liferay_users_admin_web_portlet_UsersAdminPortlet", "mvc.command.name=/users_admin/edit_organization"}, service={MVCActionCommand.class})
public class EditOrganizationMVCActionCommand
extends BaseMVCActionCommand {
    @Reference
    private AddressService _addressService;
    private DLAppLocalService _dlAppLocalService;
    @Reference
    private EmailAddressService _emailAddressService;
    @Reference
    private Http _http;
    private OrganizationService _organizationService;
    @Reference
    private OrgLaborService _orgLaborService;
    @Reference
    private PhoneService _phoneService;
    @Reference
    private Portal _portal;
    @Reference
    private WebsiteService _websiteService;

    protected void deleteOrganizations(ActionRequest actionRequest) throws Exception {
        long[] deleteOrganizationIds;
        for (long deleteOrganizationId : deleteOrganizationIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"deleteOrganizationIds"), (long)0L)) {
            this._organizationService.deleteOrganization(deleteOrganizationId);
        }
    }

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            Organization organization = null;
            if (cmd.equals("add") || cmd.equals("update")) {
                organization = this.updateOrganization(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteOrganizations(actionRequest);
            }
            String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
            if (organization != null) {
                redirect = this._http.setParameter(redirect, actionResponse.getNamespace() + "organizationId", organization.getOrganizationId());
            }
            this.sendRedirect(actionRequest, actionResponse, redirect);
        }
        catch (Exception e) {
            String mvcPath = "/edit_organization.jsp";
            if (e instanceof NoSuchOrganizationException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                mvcPath = "/error.jsp";
            } else if (e instanceof AssetCategoryException || e instanceof AssetTagException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass(), (Object)e);
            } else if (e instanceof DuplicateOrganizationException || e instanceof NoSuchCountryException || e instanceof NoSuchListTypeException || e instanceof OrganizationNameException || e instanceof OrganizationParentException || e instanceof RequiredOrganizationException) {
                if (e instanceof NoSuchListTypeException) {
                    NoSuchListTypeException nslte = (NoSuchListTypeException)e;
                    Class<?> clazz = e.getClass();
                    SessionErrors.add((PortletRequest)actionRequest, (String)(clazz.getName() + nslte.getType()));
                } else {
                    SessionErrors.add((PortletRequest)actionRequest, e.getClass(), (Object)e);
                }
                if (e instanceof RequiredOrganizationException) {
                    String redirect = this._portal.escapeRedirect(ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"));
                    long organizationId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"organizationId");
                    if (organizationId > 0L) {
                        redirect = this._http.setParameter(redirect, actionResponse.getNamespace() + "organizationId", organizationId);
                    }
                    if (Validator.isNotNull((String)redirect)) {
                        this.sendRedirect(actionRequest, actionResponse, redirect);
                        return;
                    }
                }
            } else {
                throw e;
            }
            actionResponse.setRenderParameter("mvcPath", mvcPath);
        }
    }

    @Reference(unbind="-")
    protected void setDLAppLocalService(DLAppLocalService dlAppLocalService) {
        this._dlAppLocalService = dlAppLocalService;
    }

    @Reference(unbind="-")
    protected void setOrganizationService(OrganizationService organizationService) {
        this._organizationService = organizationService;
    }

    protected Organization updateOrganization(ActionRequest actionRequest) throws Exception {
        long organizationId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"organizationId");
        long parentOrganizationId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"parentOrganizationSearchContainerPrimaryKeys", (long)0L);
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        long statusId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"statusId");
        String type = ParamUtil.getString((PortletRequest)actionRequest, (String)"type");
        long regionId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"regionId");
        long countryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"countryId");
        String comments = ParamUtil.getString((PortletRequest)actionRequest, (String)"comments");
        byte[] logoBytes = null;
        long fileEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"fileEntryId");
        if (fileEntryId > 0L) {
            FileEntry fileEntry = this._dlAppLocalService.getFileEntry(fileEntryId);
            logoBytes = FileUtil.getBytes((InputStream)fileEntry.getContentStream());
        }
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)Organization.class.getName(), (PortletRequest)actionRequest);
        Organization organization = null;
        if (organizationId <= 0L) {
            organization = this._organizationService.addOrganization(parentOrganizationId, name, type, regionId, countryId, statusId, comments, false, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), serviceContext);
        } else {
            boolean deleteLogo = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"deleteLogo");
            organization = this._organizationService.getOrganization(organizationId);
            Group organizationGroup = organization.getGroup();
            boolean site = organizationGroup.isSite();
            List addresses = this._addressService.getAddresses(Organization.class.getName(), organizationId);
            List emailAddresses = this._emailAddressService.getEmailAddresses(Organization.class.getName(), organizationId);
            List orgLabors = this._orgLaborService.getOrgLabors(organizationId);
            List phones = this._phoneService.getPhones(Organization.class.getName(), organizationId);
            List websites = this._websiteService.getWebsites(Organization.class.getName(), organizationId);
            organization = this._organizationService.updateOrganization(organizationId, parentOrganizationId, name, type, regionId, countryId, statusId, comments, !deleteLogo, logoBytes, site, addresses, emailAddresses, orgLabors, phones, websites, serviceContext);
        }
        return organization;
    }
}

