/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.web.internal.manager;

import com.liferay.portal.kernel.model.EmailAddress;
import com.liferay.portal.kernel.service.EmailAddressLocalService;
import com.liferay.portal.kernel.service.EmailAddressService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.users.admin.kernel.util.UsersAdmin;
import com.liferay.users.admin.web.internal.manager.BaseContactInfoManager;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.PortletRequest;

public class EmailAddressContactInfoManager
extends BaseContactInfoManager<EmailAddress> {
    private final String _className;
    private final long _classPK;
    private final EmailAddressLocalService _emailAddressLocalService;
    private final EmailAddressService _emailAddressService;
    private final UsersAdmin _usersAdmin;

    public EmailAddressContactInfoManager(String className, long classPK, EmailAddressLocalService emailAddressLocalService, EmailAddressService emailAddressService, UsersAdmin usersAdmin) {
        this._className = className;
        this._classPK = classPK;
        this._emailAddressLocalService = emailAddressLocalService;
        this._emailAddressService = emailAddressService;
        this._usersAdmin = usersAdmin;
    }

    @Override
    protected EmailAddress construct(ActionRequest actionRequest) throws Exception {
        long emailAddressId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"primaryKey");
        String address = ParamUtil.getString((PortletRequest)actionRequest, (String)"emailAddressAddress");
        long typeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"emailAddressTypeId");
        boolean primary = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"emailAddressPrimary");
        EmailAddress emailAddress = this._emailAddressLocalService.createEmailAddress(emailAddressId);
        emailAddress.setAddress(address);
        emailAddress.setTypeId(typeId);
        emailAddress.setPrimary(primary);
        return emailAddress;
    }

    @Override
    protected EmailAddress doAdd(EmailAddress emailAddress) throws Exception {
        return this._emailAddressService.addEmailAddress(this._className, this._classPK, emailAddress.getAddress(), emailAddress.getTypeId(), emailAddress.isPrimary(), new ServiceContext());
    }

    @Override
    protected void doDelete(long emailAddressId) throws Exception {
        this._emailAddressService.deleteEmailAddress(emailAddressId);
    }

    @Override
    protected void doUpdate(EmailAddress emailAddress) throws Exception {
        this._emailAddressService.updateEmailAddress(emailAddress.getEmailAddressId(), emailAddress.getAddress(), emailAddress.getTypeId(), emailAddress.isPrimary());
    }

    @Override
    protected EmailAddress get(long emailAddressId) throws Exception {
        return this._emailAddressService.getEmailAddress(emailAddressId);
    }

    @Override
    protected List<EmailAddress> getAll() throws Exception {
        return this._emailAddressService.getEmailAddresses(this._className, this._classPK);
    }

    @Override
    protected long getPrimaryKey(EmailAddress emailAddress) {
        return emailAddress.getEmailAddressId();
    }

    @Override
    protected boolean isPrimary(EmailAddress emailAddress) {
        return emailAddress.isPrimary();
    }

    @Override
    protected void setPrimary(EmailAddress emailAddress, boolean primary) {
        emailAddress.setPrimary(primary);
    }
}

