/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.web.internal.manager;

import com.liferay.portal.kernel.model.Address;
import com.liferay.portal.kernel.service.AddressLocalService;
import com.liferay.portal.kernel.service.AddressService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.users.admin.web.internal.manager.BaseContactInfoManager;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.PortletRequest;

public class AddressContactInfoManager
extends BaseContactInfoManager<Address> {
    private final AddressLocalService _addressLocalService;
    private final AddressService _addressService;
    private final String _className;
    private final long _classPK;

    public AddressContactInfoManager(String className, long classPK, AddressLocalService addressLocalService, AddressService addressService) {
        this._className = className;
        this._classPK = classPK;
        this._addressLocalService = addressLocalService;
        this._addressService = addressService;
    }

    @Override
    protected Address construct(ActionRequest actionRequest) throws Exception {
        String street1 = ParamUtil.getString((PortletRequest)actionRequest, (String)"addressStreet1");
        String street2 = ParamUtil.getString((PortletRequest)actionRequest, (String)"addressStreet2");
        String street3 = ParamUtil.getString((PortletRequest)actionRequest, (String)"addressStreet3");
        String city = ParamUtil.getString((PortletRequest)actionRequest, (String)"addressCity");
        String zip = ParamUtil.getString((PortletRequest)actionRequest, (String)"addressZip");
        long countryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"addressCountryId");
        if (Validator.isNull((String)street1) && Validator.isNull((String)street2) && Validator.isNull((String)street3) && Validator.isNull((String)city) && Validator.isNull((String)zip) && countryId == 0L) {
            return null;
        }
        long addressId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"primaryKey");
        Address address = this._addressLocalService.createAddress(addressId);
        long regionId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"addressRegionId");
        long typeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"addressTypeId");
        boolean mailing = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"addressMailing");
        boolean primary = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"addressPrimary");
        address.setStreet1(street1);
        address.setStreet2(street2);
        address.setStreet3(street3);
        address.setCity(city);
        address.setZip(zip);
        address.setRegionId(regionId);
        address.setCountryId(countryId);
        address.setTypeId(typeId);
        address.setMailing(mailing);
        address.setPrimary(primary);
        return address;
    }

    @Override
    protected Address doAdd(Address address) throws Exception {
        return this._addressService.addAddress(this._className, this._classPK, address.getStreet1(), address.getStreet2(), address.getStreet3(), address.getCity(), address.getZip(), address.getRegionId(), address.getCountryId(), address.getTypeId(), address.isMailing(), address.isPrimary(), new ServiceContext());
    }

    @Override
    protected void doDelete(long addressId) throws Exception {
        this._addressService.deleteAddress(addressId);
    }

    @Override
    protected void doUpdate(Address address) throws Exception {
        this._addressService.updateAddress(address.getAddressId(), address.getStreet1(), address.getStreet2(), address.getStreet3(), address.getCity(), address.getZip(), address.getRegionId(), address.getCountryId(), address.getTypeId(), address.isMailing(), address.isPrimary());
    }

    @Override
    protected Address get(long addressId) throws Exception {
        return this._addressService.getAddress(addressId);
    }

    @Override
    protected List<Address> getAll() throws Exception {
        return this._addressService.getAddresses(this._className, this._classPK);
    }

    @Override
    protected long getPrimaryKey(Address address) {
        return address.getAddressId();
    }

    @Override
    protected boolean isPrimary(Address address) {
        return address.isPrimary();
    }

    @Override
    protected void setPrimary(Address address, boolean primary) {
        address.setPrimary(primary);
    }
}

