/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.web.internal.display.context;

import com.liferay.frontend.taglib.clay.servlet.taglib.util.CreationMenu;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.ViewTypeItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.ViewTypeItemList;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.search.RowChecker;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.portlet.PortletURLUtil;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.SortFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.OrganizationLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.PortalPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.usersadmin.search.OrganizationSearch;
import com.liferay.portlet.usersadmin.search.OrganizationSearchTerms;
import com.liferay.users.admin.web.internal.search.OrganizationChecker;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import javax.portlet.MimeResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class ViewOrganizationsManagementToolbarDisplayContext {
    private static final Log _log = LogFactoryUtil.getLog(ViewOrganizationsManagementToolbarDisplayContext.class);
    private final PortletURL _currentURL;
    private final String _displayStyle;
    private final HttpServletRequest _httpServletRequest;
    private OrganizationSearch _organizationSearch;
    private final RenderRequest _renderRequest;
    private final RenderResponse _renderResponse;

    public ViewOrganizationsManagementToolbarDisplayContext(HttpServletRequest httpServletRequest, RenderRequest renderRequest, RenderResponse renderResponse, String displayStyle) {
        this._httpServletRequest = httpServletRequest;
        this._renderRequest = renderRequest;
        this._renderResponse = renderResponse;
        this._displayStyle = displayStyle;
        this._currentURL = PortletURLUtil.getCurrent((PortletRequest)this._renderRequest, (MimeResponse)this._renderResponse);
    }

    public List<DropdownItem> getActionDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.setHref((Object)StringBundler.concat((String[])new String[]{"javascript:", ViewOrganizationsManagementToolbarDisplayContext.this._renderResponse.getNamespace(), "deleteOrganizations();"}));
                    dropdownItem.setIcon("times-circle");
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)ViewOrganizationsManagementToolbarDisplayContext.this._httpServletRequest, (String)"delete"));
                    dropdownItem.setQuickAction(true);
                });
            }
        };
    }

    public String getClearResultsURL() {
        PortletURL clearResultsURL = this.getPortletURL();
        clearResultsURL.setParameter("keywords", "");
        return clearResultsURL.toString();
    }

    public CreationMenu getCreationMenu() throws PortalException {
        return new CreationMenu(){
            {
                for (String organizationType : OrganizationLocalServiceUtil.getTypes()) {
                    this.addDropdownItem(dropdownItem -> {
                        dropdownItem.setHref(ViewOrganizationsManagementToolbarDisplayContext.this._renderResponse.createRenderURL(), new Object[]{"mvcRenderCommandName", "/users_admin/edit_organization", "redirect", ViewOrganizationsManagementToolbarDisplayContext.this._getViewUsersURL(), "type", organizationType});
                        dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)ViewOrganizationsManagementToolbarDisplayContext.this._httpServletRequest, (String)organizationType));
                    });
                }
            }
        };
    }

    public List<DropdownItem> getFilterDropdownItems() {
        return new DropdownItemList(){
            {
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(ViewOrganizationsManagementToolbarDisplayContext.this._getFilterNavigationDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)ViewOrganizationsManagementToolbarDisplayContext.this._httpServletRequest, (String)"filter-by-navigation"));
                });
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(ViewOrganizationsManagementToolbarDisplayContext.this._getOrderByDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)ViewOrganizationsManagementToolbarDisplayContext.this._httpServletRequest, (String)"order-by"));
                });
            }
        };
    }

    public String getOrderByCol() {
        return this._organizationSearch.getOrderByCol();
    }

    public String getOrderByType() {
        return this._organizationSearch.getOrderByType();
    }

    public PortletURL getPortletURL() {
        try {
            PortletURL portletURL = PortletURLUtil.clone((PortletURL)this._currentURL, (MimeResponse)this._renderResponse);
            portletURL.setParameter("orderByCol", this.getOrderByCol());
            portletURL.setParameter("orderByType", this.getOrderByType());
            return portletURL;
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)e, (Throwable)e);
            }
            return this._renderResponse.createRenderURL();
        }
    }

    public String getSearchActionURL() {
        PortletURL searchActionURL = this.getPortletURL();
        return searchActionURL.toString();
    }

    public SearchContainer getSearchContainer(LinkedHashMap<String, Object> organizationParams, boolean filterManageableOrganizations) throws Exception {
        if (this._organizationSearch != null) {
            return this._organizationSearch;
        }
        PortletURL portletURL = (PortletURL)this._httpServletRequest.getAttribute("view.jsp-portletURL");
        OrganizationSearch organizationSearch = new OrganizationSearch((PortletRequest)this._renderRequest, portletURL);
        OrganizationChecker rowChecker = new OrganizationChecker(this._renderResponse);
        rowChecker.setRowIds("rowIdsOrganization");
        organizationSearch.setRowChecker((RowChecker)rowChecker);
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long parentOrganizationId = 0L;
        OrganizationSearchTerms organizationSearchTerms = (OrganizationSearchTerms)organizationSearch.getSearchTerms();
        String keywords = organizationSearchTerms.getKeywords();
        parentOrganizationId = Validator.isNotNull((String)keywords) || filterManageableOrganizations ? -1L : ParamUtil.getLong((HttpServletRequest)this._httpServletRequest, (String)"parentOrganizationId", (long)0L);
        List results = null;
        int total = 0;
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(Organization.class);
        if (indexer.isIndexerEnabled() && PropsValues.ORGANIZATIONS_SEARCH_WITH_INDEX) {
            organizationParams.put("expandoAttributes", keywords);
            Sort sort = SortFactoryUtil.getSort(Organization.class, (String)organizationSearch.getOrderByCol(), (String)organizationSearch.getOrderByType());
            BaseModelSearchResult baseModelSearchResult = OrganizationLocalServiceUtil.searchOrganizations((long)themeDisplay.getCompanyId(), (long)parentOrganizationId, (String)keywords, organizationParams, (int)organizationSearch.getStart(), (int)organizationSearch.getEnd(), (Sort)sort);
            results = baseModelSearchResult.getBaseModels();
            total = baseModelSearchResult.getLength();
        } else {
            total = OrganizationLocalServiceUtil.searchCount((long)themeDisplay.getCompanyId(), (long)parentOrganizationId, (String)keywords, (String)organizationSearchTerms.getType(), (Long)organizationSearchTerms.getRegionIdObj(), (Long)organizationSearchTerms.getCountryIdObj(), organizationParams);
            results = OrganizationLocalServiceUtil.search((long)themeDisplay.getCompanyId(), (long)parentOrganizationId, (String)keywords, (String)organizationSearchTerms.getType(), (Long)organizationSearchTerms.getRegionIdObj(), (Long)organizationSearchTerms.getCountryIdObj(), organizationParams, (int)organizationSearch.getStart(), (int)organizationSearch.getEnd(), (OrderByComparator)organizationSearch.getOrderByComparator());
        }
        organizationSearch.setResults(results);
        organizationSearch.setTotal(total);
        this._organizationSearch = organizationSearch;
        return this._organizationSearch;
    }

    public String getSortingURL() {
        PortletURL sortingURL = this.getPortletURL();
        sortingURL.setParameter("orderByType", Objects.equals(this.getOrderByType(), "asc") ? "desc" : "asc");
        return sortingURL.toString();
    }

    public List<ViewTypeItem> getViewTypeItems() {
        return new ViewTypeItemList(this.getPortletURL(), this._displayStyle){
            {
                this.addCardViewTypeItem();
                this.addListViewTypeItem();
                this.addTableViewTypeItem();
            }
        };
    }

    public boolean showCreationMenu() throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return PortalPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (String)"ADD_ORGANIZATION");
    }

    private List<DropdownItem> _getFilterNavigationDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.setActive(true);
                    dropdownItem.setHref((Object)"");
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)ViewOrganizationsManagementToolbarDisplayContext.this._httpServletRequest, (String)"all"));
                });
            }
        };
    }

    private List<DropdownItem> _getOrderByDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.setActive(Objects.equals(ViewOrganizationsManagementToolbarDisplayContext.this.getOrderByCol(), "name"));
                    dropdownItem.setHref(ViewOrganizationsManagementToolbarDisplayContext.this.getPortletURL(), new Object[]{"orderByCol", "name"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)ViewOrganizationsManagementToolbarDisplayContext.this._httpServletRequest, (String)"name"));
                });
                this.add(dropdownItem -> {
                    dropdownItem.setActive(Objects.equals(ViewOrganizationsManagementToolbarDisplayContext.this.getOrderByCol(), "type"));
                    dropdownItem.setHref(ViewOrganizationsManagementToolbarDisplayContext.this.getPortletURL(), new Object[]{"orderByCol", "type"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)ViewOrganizationsManagementToolbarDisplayContext.this._httpServletRequest, (String)"type"));
                });
            }
        };
    }

    private String _getViewUsersURL() {
        String toolbarItem = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"toolbarItem", (String)"view-all-organizations");
        String usersListView = (String)this._httpServletRequest.getAttribute("view.jsp-usersListView");
        PortletURL viewUsersURL = this._renderResponse.createRenderURL();
        viewUsersURL.setParameter("toolbarItem", toolbarItem);
        viewUsersURL.setParameter("usersListView", usersListView);
        return viewUsersURL.toString();
    }
}

