/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.web.internal.display.context;

import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.SortFactoryUtil;
import com.liferay.portal.kernel.service.OrganizationLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.usersadmin.search.OrganizationSearch;
import com.liferay.portlet.usersadmin.search.OrganizationSearchTerms;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class SelectOrganizationManagementToolbarDisplayContext {
    private static final Log _log = LogFactoryUtil.getLog(SelectOrganizationManagementToolbarDisplayContext.class);
    private final HttpServletRequest _httpServletRequest;
    private OrganizationSearch _organizationSearch;
    private final RenderRequest _renderRequest;
    private final RenderResponse _renderResponse;

    public SelectOrganizationManagementToolbarDisplayContext(HttpServletRequest httpServletRequest, RenderRequest renderRequest, RenderResponse renderResponse) {
        this._httpServletRequest = httpServletRequest;
        this._renderRequest = renderRequest;
        this._renderResponse = renderResponse;
    }

    public String getClearResultsURL() {
        PortletURL clearResultsURL = this.getPortletURL();
        clearResultsURL.setParameter("keywords", "");
        return clearResultsURL.toString();
    }

    public int getCur() {
        if (this._organizationSearch != null) {
            return this._organizationSearch.getCur();
        }
        return 1;
    }

    public int getDelta() {
        if (this._organizationSearch != null) {
            return this._organizationSearch.getDelta();
        }
        return SearchContainer.DEFAULT_DELTA;
    }

    public List<DropdownItem> getFilterDropdownItems() {
        return new DropdownItemList(){
            {
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(SelectOrganizationManagementToolbarDisplayContext.this._getFilterNavigationDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)SelectOrganizationManagementToolbarDisplayContext.this._httpServletRequest, (String)"filter-by-navigation"));
                });
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(SelectOrganizationManagementToolbarDisplayContext.this._getOrderByDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)SelectOrganizationManagementToolbarDisplayContext.this._httpServletRequest, (String)"order-by"));
                });
            }
        };
    }

    public String getOrderByCol() {
        if (this._organizationSearch != null) {
            return this._organizationSearch.getOrderByCol();
        }
        return "name";
    }

    public String getOrderByType() {
        if (this._organizationSearch != null) {
            return this._organizationSearch.getOrderByType();
        }
        return "asc";
    }

    public PortletURL getPortletURL() {
        PortletURL portletURL = this._renderResponse.createRenderURL();
        portletURL.setParameter("mvcPath", "/select_organization.jsp");
        User selUser = this._getSelectedUser();
        if (selUser != null) {
            portletURL.setParameter("p_u_i_d", String.valueOf(selUser.getUserId()));
        }
        String eventName = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"eventName", (String)(this._renderResponse.getNamespace() + "selectOrganization"));
        portletURL.setParameter("eventName", eventName);
        Object[] keywords = ParamUtil.getStringValues((HttpServletRequest)this._httpServletRequest, (String)"keywords");
        if (ArrayUtil.isNotEmpty((Object[])keywords)) {
            portletURL.setParameter("keywords", (String)keywords[keywords.length - 1]);
        }
        portletURL.setParameter("cur", String.valueOf(this.getCur()));
        portletURL.setParameter("delta", String.valueOf(this.getDelta()));
        portletURL.setParameter("orderByCol", this.getOrderByCol());
        portletURL.setParameter("orderByType", this.getOrderByType());
        String target = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"target");
        if (Validator.isNotNull((String)target)) {
            portletURL.setParameter("target", target);
        }
        return portletURL;
    }

    public String getSearchActionURL() {
        PortletURL searchActionURL = this.getPortletURL();
        return searchActionURL.toString();
    }

    public SearchContainer getSearchContainer(LinkedHashMap<String, Object> organizationParams) throws Exception {
        int total;
        List results;
        if (this._organizationSearch != null) {
            return this._organizationSearch;
        }
        OrganizationSearch organizationSearch = new OrganizationSearch((PortletRequest)this._renderRequest, this.getPortletURL());
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long parentOrganizationId = -1L;
        OrganizationSearchTerms organizationSearchTerms = (OrganizationSearchTerms)organizationSearch.getSearchTerms();
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(Organization.class);
        if (indexer.isIndexerEnabled() && PropsValues.ORGANIZATIONS_SEARCH_WITH_INDEX) {
            organizationParams.put("expandoAttributes", organizationSearchTerms.getKeywords());
            Sort sort = SortFactoryUtil.getSort(Organization.class, (String)organizationSearch.getOrderByCol(), (String)organizationSearch.getOrderByType());
            BaseModelSearchResult baseModelSearchResult = OrganizationLocalServiceUtil.searchOrganizations((long)themeDisplay.getCompanyId(), (long)parentOrganizationId, (String)organizationSearchTerms.getKeywords(), organizationParams, (int)organizationSearch.getStart(), (int)organizationSearch.getEnd(), (Sort)sort);
            results = baseModelSearchResult.getBaseModels();
            total = baseModelSearchResult.getLength();
        } else {
            total = OrganizationLocalServiceUtil.searchCount((long)themeDisplay.getCompanyId(), (long)parentOrganizationId, (String)organizationSearchTerms.getKeywords(), (String)organizationSearchTerms.getType(), (Long)organizationSearchTerms.getRegionIdObj(), (Long)organizationSearchTerms.getCountryIdObj(), organizationParams);
            results = OrganizationLocalServiceUtil.search((long)themeDisplay.getCompanyId(), (long)parentOrganizationId, (String)organizationSearchTerms.getKeywords(), (String)organizationSearchTerms.getType(), (Long)organizationSearchTerms.getRegionIdObj(), (Long)organizationSearchTerms.getCountryIdObj(), organizationParams, (int)organizationSearch.getStart(), (int)organizationSearch.getEnd(), (OrderByComparator)organizationSearch.getOrderByComparator());
        }
        organizationSearch.setResults(results);
        organizationSearch.setTotal(total);
        this._organizationSearch = organizationSearch;
        return this._organizationSearch;
    }

    public String getSortingURL() {
        PortletURL sortingURL = this.getPortletURL();
        sortingURL.setParameter("orderByType", Objects.equals(this.getOrderByType(), "asc") ? "desc" : "asc");
        return sortingURL.toString();
    }

    private List<DropdownItem> _getFilterNavigationDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.setActive(true);
                    dropdownItem.setHref((Object)"");
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)SelectOrganizationManagementToolbarDisplayContext.this._httpServletRequest, (String)"all"));
                });
            }
        };
    }

    private List<DropdownItem> _getOrderByDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.setActive(Objects.equals(SelectOrganizationManagementToolbarDisplayContext.this.getOrderByCol(), "name"));
                    dropdownItem.setHref(SelectOrganizationManagementToolbarDisplayContext.this.getPortletURL(), new Object[]{"orderByCol", "name"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)SelectOrganizationManagementToolbarDisplayContext.this._httpServletRequest, (String)"name"));
                });
                this.add(dropdownItem -> {
                    dropdownItem.setActive(Objects.equals(SelectOrganizationManagementToolbarDisplayContext.this.getOrderByCol(), "type"));
                    dropdownItem.setHref(SelectOrganizationManagementToolbarDisplayContext.this.getPortletURL(), new Object[]{"orderByCol", "type"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)SelectOrganizationManagementToolbarDisplayContext.this._httpServletRequest, (String)"type"));
                });
            }
        };
    }

    private User _getSelectedUser() {
        try {
            return PortalUtil.getSelectedUser((HttpServletRequest)this._httpServletRequest);
        }
        catch (PortalException pe) {
            _log.error((Object)pe, (Throwable)pe);
            return null;
        }
    }
}

