/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.web.internal.display.context;

import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import javax.servlet.http.HttpServletRequest;

public class InitDisplayContext {
    private final boolean _filterManageableGroups;
    private final boolean _filterManageableOrganizations;
    private final boolean _filterManageableRoles;
    private final boolean _filterManageableUserGroupRoles;
    private final boolean _filterManageableUserGroups;

    public InitDisplayContext(HttpServletRequest httpServletRequest, String portletName) {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        String myAccountPortletId = PortletProviderUtil.getPortletId((String)"com.liferay.admin.kernel.util.PortalMyAccountApplicationType$MyAccount", (PortletProvider.Action)PortletProvider.Action.VIEW);
        if (portletName.equals(myAccountPortletId)) {
            this._filterManageableGroups = false;
            this._filterManageableOrganizations = false;
            this._filterManageableRoles = false;
            this._filterManageableUserGroupRoles = false;
            this._filterManageableUserGroups = false;
        } else if (permissionChecker.isCompanyAdmin()) {
            this._filterManageableGroups = false;
            this._filterManageableOrganizations = false;
            this._filterManageableRoles = true;
            this._filterManageableUserGroups = false;
            this._filterManageableUserGroupRoles = true;
        } else {
            this._filterManageableOrganizations = !permissionChecker.hasPermission(null, Organization.class.getName(), Organization.class.getName(), "VIEW");
            this._filterManageableGroups = true;
            this._filterManageableRoles = true;
            this._filterManageableUserGroupRoles = true;
            this._filterManageableUserGroups = true;
        }
    }

    public boolean isFilterManageableGroups() {
        return this._filterManageableGroups;
    }

    public boolean isFilterManageableOrganizations() {
        return this._filterManageableOrganizations;
    }

    public boolean isFilterManageableRoles() {
        return this._filterManageableRoles;
    }

    public boolean isFilterManageableUserGroupRoles() {
        return this._filterManageableUserGroupRoles;
    }

    public boolean isFilterManageableUserGroups() {
        return this._filterManageableUserGroups;
    }
}

