/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.web.internal.portlet.action;

import com.liferay.portal.kernel.bean.BeanParamUtil;
import com.liferay.portal.kernel.exception.NoSuchUserException;
import com.liferay.portal.kernel.exception.UserPasswordException;
import com.liferay.portal.kernel.model.PasswordPolicy;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.ldap.LDAPSettingsUtil;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.UserService;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_users_admin_web_portlet_MyOrganizationsPortlet", "javax.portlet.name=com_liferay_users_admin_web_portlet_UsersAdminPortlet", "mvc.command.name=/users_admin/update_password"}, service={MVCActionCommand.class})
public class UpdatePasswordMVCActionCommand
extends BaseMVCActionCommand {
    @Reference
    private Portal _portal;
    @Reference
    private UserLocalService _userLocalService;
    @Reference
    private UserService _userService;

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        try {
            String reminderQueryQuestion;
            User user = this._portal.getSelectedUser((PortletRequest)actionRequest);
            String newPassword1 = actionRequest.getParameter("password1");
            String newPassword2 = actionRequest.getParameter("password2");
            boolean passwordReset = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"passwordReset");
            PasswordPolicy passwordPolicy = user.getPasswordPolicy();
            boolean ldapPasswordPolicyEnabled = LDAPSettingsUtil.isPasswordPolicyEnabled((long)user.getCompanyId());
            if (user.getLastLoginDate() == null && (passwordPolicy == null && !ldapPasswordPolicyEnabled || passwordPolicy != null && passwordPolicy.isChangeable() && passwordPolicy.isChangeRequired())) {
                passwordReset = true;
            }
            if ((reminderQueryQuestion = BeanParamUtil.getString((Object)user, (PortletRequest)actionRequest, (String)"reminderQueryQuestion")).equals("write-my-own-question")) {
                reminderQueryQuestion = BeanParamUtil.getStringSilent((Object)user, (PortletRequest)actionRequest, (String)"reminderQueryCustomQuestion");
            }
            String reminderQueryAnswer = BeanParamUtil.getString((Object)user, (PortletRequest)actionRequest, (String)"reminderQueryAnswer");
            if (Validator.isNotNull((String)newPassword1) || Validator.isNotNull((String)newPassword2)) {
                this._userLocalService.updatePassword(user.getUserId(), newPassword1, newPassword2, passwordReset);
            }
            this._userLocalService.updatePasswordReset(user.getUserId(), passwordReset);
            if (Validator.isNotNull((String)reminderQueryQuestion) && Validator.isNotNull((String)reminderQueryAnswer)) {
                this._userLocalService.updateReminderQuery(user.getUserId(), reminderQueryQuestion, reminderQueryAnswer);
            }
            ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            if (user.getUserId() == themeDisplay.getUserId() && PropsValues.SESSION_STORE_PASSWORD && Validator.isNotNull((String)newPassword1)) {
                PortletSession portletSession = actionRequest.getPortletSession();
                portletSession.setAttribute("USER_PASSWORD", (Object)newPassword1, 1);
            }
        }
        catch (Exception e) {
            if (e instanceof NoSuchUserException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                actionResponse.setRenderParameter("mvcPath", "/error.jsp");
            }
            if (e instanceof UserPasswordException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass(), (Object)e);
                String redirect = this._portal.escapeRedirect(ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"));
                if (Validator.isNotNull((String)redirect)) {
                    this.sendRedirect(actionRequest, actionResponse, redirect);
                }
            }
            throw e;
        }
    }
}

