/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.web.internal.portlet.action;

import com.liferay.portal.kernel.exception.AddressCityException;
import com.liferay.portal.kernel.exception.AddressStreetException;
import com.liferay.portal.kernel.exception.AddressZipException;
import com.liferay.portal.kernel.exception.NoSuchCountryException;
import com.liferay.portal.kernel.exception.NoSuchListTypeException;
import com.liferay.portal.kernel.exception.NoSuchRegionException;
import com.liferay.portal.kernel.exception.NoSuchUserException;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.users.admin.kernel.util.UsersAdmin;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_my_account_web_portlet_MyAccountPortlet", "javax.portlet.name=com_liferay_users_admin_web_portlet_MyOrganizationsPortlet", "javax.portlet.name=com_liferay_users_admin_web_portlet_UsersAdminPortlet", "mvc.command.name=/users_admin/update_addresses"}, service={MVCActionCommand.class})
public class UpdateAddressesMVCActionCommand
extends BaseMVCActionCommand {
    @Reference
    private Portal _portal;
    @Reference
    private UsersAdmin _usersAdmin;

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        try {
            User user = this._portal.getSelectedUser((PortletRequest)actionRequest);
            List addresses = this._usersAdmin.getAddresses(actionRequest, user.getAddresses());
            if (addresses != null) {
                this._usersAdmin.updateAddresses(Contact.class.getName(), user.getContactId(), addresses);
            }
            String redirect = this._portal.escapeRedirect(ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"));
            this.sendRedirect(actionRequest, actionResponse, redirect);
        }
        catch (Exception e) {
            if (e instanceof NoSuchUserException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                actionResponse.setRenderParameter("mvcPath", "/error.jsp");
            }
            if (e instanceof AddressCityException || e instanceof AddressStreetException || e instanceof AddressZipException || e instanceof NoSuchCountryException || e instanceof NoSuchListTypeException || e instanceof NoSuchRegionException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass(), (Object)e);
                actionResponse.setRenderParameter("mvcPath", "/edit_user.jsp");
            }
            throw e;
        }
    }
}

