/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.web.internal.portlet.action;

import com.liferay.portal.kernel.exception.NoSuchUserException;
import com.liferay.portal.kernel.exception.UserPasswordException;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashMap;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_my_account_web_portlet_MyAccountPortlet", "mvc.command.name=/users_admin/update_password"}, service={MVCActionCommand.class})
public class UpdatePasswordMyAccountMVCActionCommand
extends BaseMVCActionCommand {
    @Reference(target="(component.name=com.liferay.users.admin.web.internal.portlet.action.UpdatePasswordMVCActionCommand)")
    private MVCActionCommand _mvcActionCommand;
    @Reference
    private Portal _portal;
    @Reference
    private UserLocalService _userLocalService;

    protected void authenticateUser(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String currentPassword = actionRequest.getParameter("password0");
        String newPassword = actionRequest.getParameter("password1");
        User user = this._portal.getSelectedUser((PortletRequest)actionRequest);
        if (Validator.isNotNull((String)currentPassword)) {
            if (Validator.isNull((String)newPassword)) {
                throw new UserPasswordException.MustNotBeNull(user.getUserId());
            }
            Company company = this._portal.getCompany((PortletRequest)actionRequest);
            String authType = company.getAuthType();
            HashMap headerMap = new HashMap();
            HashMap parameterMap = new HashMap();
            HashMap resultsMap = new HashMap();
            int authResult = -1;
            if (authType.equals("emailAddress")) {
                authResult = this._userLocalService.authenticateByEmailAddress(company.getCompanyId(), user.getEmailAddress(), currentPassword, headerMap, parameterMap, resultsMap);
            } else if (authType.equals("userId")) {
                authResult = this._userLocalService.authenticateByUserId(company.getCompanyId(), user.getUserId(), currentPassword, headerMap, parameterMap, resultsMap);
            } else if (authType.equals("screenName")) {
                authResult = this._userLocalService.authenticateByScreenName(company.getCompanyId(), user.getScreenName(), currentPassword, headerMap, parameterMap, resultsMap);
            }
            if (authResult == -1) {
                throw new UserPasswordException.MustMatchCurrentPassword(user.getUserId());
            }
        } else if (Validator.isNotNull((String)newPassword)) {
            throw new UserPasswordException.MustNotBeNull(user.getUserId());
        }
    }

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        try {
            this.authenticateUser(actionRequest, actionResponse);
            this._mvcActionCommand.processAction(actionRequest, actionResponse);
        }
        catch (Exception e) {
            if (e instanceof NoSuchUserException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                actionResponse.setRenderParameter("mvcPath", "/error.jsp");
            }
            if (e instanceof UserPasswordException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass(), (Object)e);
                String redirect = this._portal.escapeRedirect(ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"));
                if (Validator.isNotNull((String)redirect)) {
                    this.sendRedirect(actionRequest, actionResponse, redirect);
                }
            }
            throw e;
        }
    }
}

