/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.web.internal.portlet.action;

import com.liferay.portal.kernel.exception.NoSuchOrganizationException;
import com.liferay.portal.kernel.messaging.proxy.ProxyModeThreadLocal;
import com.liferay.portal.kernel.messaging.proxy.ProxyModeThreadLocalCloseable;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.membershippolicy.MembershipPolicyException;
import com.liferay.portal.kernel.service.UserService;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_users_admin_web_portlet_MyOrganizationsPortlet", "javax.portlet.name=com_liferay_users_admin_web_portlet_UsersAdminPortlet", "mvc.command.name=/users_admin/edit_organization_assignments"}, service={MVCActionCommand.class})
public class EditOrganizationAssignmentsMVCActionCommand
extends BaseMVCActionCommand {
    private UserService _userService;

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        try {
            this.updateOrganizationUsers(actionRequest);
            String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"assignmentsRedirect");
            this.sendRedirect(actionRequest, actionResponse, redirect);
        }
        catch (Exception e) {
            if (e instanceof MembershipPolicyException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass(), (Object)e);
            }
            if (e instanceof NoSuchOrganizationException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                actionResponse.setRenderParameter("mvcPath", "/error.jsp");
            }
            throw e;
        }
    }

    @Reference(unbind="-")
    protected void setUserService(UserService userService) {
        this._userService = userService;
    }

    protected void updateOrganizationUsers(ActionRequest actionRequest) throws Exception {
        long organizationId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"organizationId");
        long[] addUserIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"addUserIds"), (long)0L);
        long[] removeUserIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"removeUserIds"), (long)0L);
        try (ProxyModeThreadLocalCloseable proxyModeThreadLocalCloseable = new ProxyModeThreadLocalCloseable();){
            ProxyModeThreadLocal.setForceSync((boolean)true);
            this._userService.addOrganizationUsers(organizationId, addUserIds);
            this._userService.unsetOrganizationUsers(organizationId, removeUserIds);
        }
    }
}

