/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.web.internal.display.context;

import com.liferay.frontend.taglib.clay.servlet.taglib.util.CreationMenu;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.ViewTypeItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.ViewTypeItemList;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.search.EmptyOnClickRowChecker;
import com.liferay.portal.kernel.dao.search.RowChecker;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletURLUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.PortalPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.usersadmin.search.UserSearch;
import com.liferay.portlet.usersadmin.search.UserSearchTerms;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import javax.portlet.MimeResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class ViewUsersManagementToolbarDisplayContext {
    private static final Log _log = LogFactoryUtil.getLog(ViewUsersManagementToolbarDisplayContext.class);
    private final PortletURL _currentURL;
    private final String _displayStyle;
    private final String _navigation;
    private final RenderRequest _renderRequest;
    private final RenderResponse _renderResponse;
    private final HttpServletRequest _request;
    private final int _status;
    private UserSearch _userSearch;

    public ViewUsersManagementToolbarDisplayContext(HttpServletRequest request, RenderRequest renderRequest, RenderResponse renderResponse, String displayStyle, String navigation, int status) {
        this._request = request;
        this._renderRequest = renderRequest;
        this._renderResponse = renderResponse;
        this._displayStyle = displayStyle;
        this._navigation = navigation;
        this._status = status;
        this._currentURL = PortletURLUtil.getCurrent((PortletRequest)this._renderRequest, (MimeResponse)this._renderResponse);
    }

    public List<DropdownItem> getActionDropdownItems() {
        return new DropdownItemList(){
            {
                if (ViewUsersManagementToolbarDisplayContext.this.isShowRestoreButton()) {
                    this.add(dropdownItem -> {
                        dropdownItem.setHref((Object)StringBundler.concat((String[])new String[]{"javascript:", ViewUsersManagementToolbarDisplayContext.this._renderResponse.getNamespace(), "deleteUsers('", "restore", "');"}));
                        dropdownItem.setIcon("icon-undo");
                        dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)ViewUsersManagementToolbarDisplayContext.this._request, (String)"restore"));
                        dropdownItem.setQuickAction(true);
                    });
                }
                if (ViewUsersManagementToolbarDisplayContext.this.isShowDeleteButton()) {
                    this.add(dropdownItem -> {
                        UserSearchTerms userSearchTerms = (UserSearchTerms)ViewUsersManagementToolbarDisplayContext.this._userSearch.getSearchTerms();
                        String action = "delete";
                        if (userSearchTerms.isActive()) {
                            action = "deactivate";
                        }
                        dropdownItem.setHref((Object)StringBundler.concat((String[])new String[]{"javascript:", ViewUsersManagementToolbarDisplayContext.this._renderResponse.getNamespace(), "deleteUsers('", action, "');"}));
                        dropdownItem.setIcon("trash");
                        dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)ViewUsersManagementToolbarDisplayContext.this._request, (String)action));
                        dropdownItem.setQuickAction(true);
                    });
                }
            }
        };
    }

    public String getClearResultsURL() {
        PortletURL clearResultsURL = this.getPortletURL();
        clearResultsURL.setParameter("keywords", "");
        return clearResultsURL.toString();
    }

    public CreationMenu getCreationMenu() throws PortalException {
        return new CreationMenu(){
            {
                this.addPrimaryDropdownItem(dropdownItem -> {
                    dropdownItem.setHref(ViewUsersManagementToolbarDisplayContext.this._renderResponse.createRenderURL(), new Object[]{"mvcRenderCommandName", "/users_admin/edit_user"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)ViewUsersManagementToolbarDisplayContext.this._request, (String)"add-user"));
                });
            }
        };
    }

    public List<DropdownItem> getFilterDropdownItems() {
        return new DropdownItemList(){
            {
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(ViewUsersManagementToolbarDisplayContext.this._getFilterNavigationDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)ViewUsersManagementToolbarDisplayContext.this._request, (String)"filter-by-navigation"));
                });
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(ViewUsersManagementToolbarDisplayContext.this._getOrderByDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)ViewUsersManagementToolbarDisplayContext.this._request, (String)"order-by"));
                });
            }
        };
    }

    public String getOrderByCol() {
        return this._userSearch.getOrderByCol();
    }

    public String getOrderByType() {
        return this._userSearch.getOrderByType();
    }

    public PortletURL getPortletURL() {
        try {
            PortletURL portletURL = PortletURLUtil.clone((PortletURL)this._currentURL, (MimeResponse)this._renderResponse);
            portletURL.setParameter("orderByCol", this.getOrderByCol());
            portletURL.setParameter("orderByType", this.getOrderByType());
            return portletURL;
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)e, (Throwable)e);
            }
            return this._renderResponse.createRenderURL();
        }
    }

    public String getSearchActionURL() {
        PortletURL searchActionURL = this.getPortletURL();
        return searchActionURL.toString();
    }

    public SearchContainer getSearchContainer() {
        if (this._userSearch != null) {
            return this._userSearch;
        }
        PortletURL portletURL = (PortletURL)this._request.getAttribute("view.jsp-portletURL");
        UserSearch userSearch = new UserSearch((PortletRequest)this._renderRequest, "cur2", portletURL);
        EmptyOnClickRowChecker rowChecker = new EmptyOnClickRowChecker((PortletResponse)this._renderResponse);
        rowChecker.setRowIds("rowIdsUser");
        userSearch.setRowChecker((RowChecker)rowChecker);
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        UserSearchTerms searchTerms = (UserSearchTerms)userSearch.getSearchTerms();
        if (this._navigation.equals("active")) {
            searchTerms.setStatus(0);
        } else if (this._navigation.equals("inactive")) {
            searchTerms.setStatus(5);
        }
        int total = UserLocalServiceUtil.searchCount((long)themeDisplay.getCompanyId(), (String)searchTerms.getKeywords(), (int)searchTerms.getStatus(), new LinkedHashMap());
        userSearch.setTotal(total);
        List results = UserLocalServiceUtil.search((long)themeDisplay.getCompanyId(), (String)searchTerms.getKeywords(), (int)searchTerms.getStatus(), new LinkedHashMap(), (int)userSearch.getStart(), (int)userSearch.getEnd(), (OrderByComparator)userSearch.getOrderByComparator());
        userSearch.setResults(results);
        this._userSearch = userSearch;
        return this._userSearch;
    }

    public String getSortingURL() {
        PortletURL sortingURL = this.getPortletURL();
        sortingURL.setParameter("orderByType", Objects.equals(this.getOrderByType(), "asc") ? "desc" : "asc");
        return sortingURL.toString();
    }

    public List<ViewTypeItem> getViewTypeItems() {
        return new ViewTypeItemList(this.getPortletURL(), this._displayStyle){
            {
                this.addCardViewTypeItem();
                this.addListViewTypeItem();
                this.addTableViewTypeItem();
            }
        };
    }

    public boolean isShowDeleteButton() {
        UserSearchTerms searchTerms = (UserSearchTerms)this.getSearchContainer().getSearchTerms();
        return searchTerms.getStatus() != -1 && (searchTerms.isActive() || !searchTerms.isActive() && PropsValues.USERS_DELETE);
    }

    public boolean isShowRestoreButton() {
        UserSearchTerms searchTerms = (UserSearchTerms)this.getSearchContainer().getSearchTerms();
        return searchTerms.getStatus() != -1 && !searchTerms.isActive();
    }

    public boolean showCreationMenu() throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return PortalPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (String)"ADD_USER");
    }

    private List<DropdownItem> _getFilterNavigationDropdownItems() {
        DropdownItemList navigationDropdownitems = new DropdownItemList();
        for (String navigation : new String[]{"active", "inactive"}) {
            navigationDropdownitems.add(dropdownItem -> {
                dropdownItem.setActive(navigation.equals(this._navigation));
                dropdownItem.setHref(this.getPortletURL(), new Object[]{"navigation", navigation});
                dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._request, (String)navigation));
            });
        }
        return navigationDropdownitems;
    }

    private List<DropdownItem> _getOrderByDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.setActive(Objects.equals(ViewUsersManagementToolbarDisplayContext.this.getOrderByCol(), "first-name"));
                    dropdownItem.setHref(ViewUsersManagementToolbarDisplayContext.this.getPortletURL(), new Object[]{"orderByCol", "first-name"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)ViewUsersManagementToolbarDisplayContext.this._request, (String)"first-name"));
                });
                this.add(dropdownItem -> {
                    dropdownItem.setActive(Objects.equals(ViewUsersManagementToolbarDisplayContext.this.getOrderByCol(), "last-name"));
                    dropdownItem.setHref(ViewUsersManagementToolbarDisplayContext.this.getPortletURL(), new Object[]{"orderByCol", "last-name"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)ViewUsersManagementToolbarDisplayContext.this._request, (String)"last-name"));
                });
                this.add(dropdownItem -> {
                    dropdownItem.setActive(Objects.equals(ViewUsersManagementToolbarDisplayContext.this.getOrderByCol(), "screen-name"));
                    dropdownItem.setHref(ViewUsersManagementToolbarDisplayContext.this.getPortletURL(), new Object[]{"orderByCol", "screen-name"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)ViewUsersManagementToolbarDisplayContext.this._request, (String)"screen-name"));
                });
            }
        };
    }
}

