/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.web.portlet;

import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.UserGroupRole;
import com.liferay.portal.kernel.portlet.BaseControlPanelEntry;
import com.liferay.portal.kernel.portlet.ControlPanelEntry;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.service.UserGroupRoleLocalService;
import com.liferay.portal.kernel.service.permission.OrganizationPermissionUtil;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"javax.portlet.name=com_liferay_users_admin_web_portlet_MyOrganizationsPortlet", "javax.portlet.name=com_liferay_users_admin_web_portlet_UsersAdminPortlet"}, service={ControlPanelEntry.class})
public class UsersControlPanelEntry
extends BaseControlPanelEntry {
    private OrganizationLocalService _organizationLocalService;
    private UserGroupRoleLocalService _userGroupRoleLocalService;

    protected boolean hasPermissionImplicitlyGranted(PermissionChecker permissionChecker, Group group, Portlet portlet) throws Exception {
        List userGroupRoles = this._userGroupRoleLocalService.getUserGroupRoles(permissionChecker.getUserId());
        for (UserGroupRole userGroupRole : userGroupRoles) {
            Role role = userGroupRole.getRole();
            String roleName = role.getName();
            if (!roleName.equals("Organization Administrator") && !roleName.equals("Organization Owner")) continue;
            return true;
        }
        List organizations = this._organizationLocalService.getUserOrganizations(permissionChecker.getUserId());
        for (Organization organization : organizations) {
            if (OrganizationPermissionUtil.contains((PermissionChecker)permissionChecker, (Organization)organization, (String)"MANAGE_USERS")) {
                return true;
            }
            if (!OrganizationPermissionUtil.contains((PermissionChecker)permissionChecker, (Organization)organization, (String)"MANAGE_SUBORGANIZATIONS")) continue;
            return true;
        }
        return super.hasPermissionImplicitlyGranted(permissionChecker, group, portlet);
    }

    @Reference(unbind="-")
    protected void setOrganizationLocalService(OrganizationLocalService organizationLocalService) {
        this._organizationLocalService = organizationLocalService;
    }

    @Reference(unbind="-")
    protected void setUserGroupRoleLocalService(UserGroupRoleLocalService userGroupRoleLocalService) {
        this._userGroupRoleLocalService = userGroupRoleLocalService;
    }
}

