/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.test.util.search;

import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.service.AssetTagLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Address;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.ListType;
import com.liferay.portal.kernel.model.ListTypeConstants;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Region;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.AddressLocalServiceUtil;
import com.liferay.portal.kernel.service.CountryServiceUtil;
import com.liferay.portal.kernel.service.ListTypeServiceUtil;
import com.liferay.portal.kernel.service.OrganizationLocalServiceUtil;
import com.liferay.portal.kernel.service.RegionServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserGroupLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.test.randomizerbumpers.NumericStringRandomizerBumper;
import com.liferay.portal.kernel.test.randomizerbumpers.RandomizerBumper;
import com.liferay.portal.kernel.test.randomizerbumpers.UniqueStringRandomizerBumper;
import com.liferay.portal.kernel.test.util.RandomTestUtil;
import com.liferay.portal.kernel.test.util.ServiceContextTestUtil;
import com.liferay.portal.kernel.test.util.TestPropsValues;
import com.liferay.portal.kernel.test.util.UserTestUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.users.admin.test.util.search.DummyPermissionChecker;
import com.liferay.users.admin.test.util.search.GroupBlueprint;
import com.liferay.users.admin.test.util.search.GroupSearchFixture;
import com.liferay.users.admin.test.util.search.OrganizationBlueprint;
import com.liferay.users.admin.test.util.search.OrganizationSearchFixture;
import com.liferay.users.admin.test.util.search.UserBlueprint;
import com.liferay.users.admin.test.util.search.UserBlueprintImpl;
import com.liferay.users.admin.test.util.search.UserGroupSearchFixture;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class UserSearchFixture {
    private final List<Address> _addresses = new ArrayList<Address>();
    private final List<AssetTag> _assetTags = new ArrayList<AssetTag>();
    private long _companyId;
    private final GroupSearchFixture _groupSearchFixture;
    private final OrganizationSearchFixture _organizationSearchFixture;
    private PermissionChecker _permissionChecker;
    private String _principal;
    private final UserGroupSearchFixture _userGroupSearchFixture;
    private final UserLocalService _userLocalService;
    private final List<User> _users = new ArrayList<User>();

    public UserSearchFixture() {
        this(UserLocalServiceUtil.getService(), new GroupSearchFixture(), new OrganizationSearchFixture(OrganizationLocalServiceUtil.getService()), new UserGroupSearchFixture(UserGroupLocalServiceUtil.getService()));
    }

    public UserSearchFixture(UserLocalService userLocalService, GroupSearchFixture groupSearchFixture, OrganizationSearchFixture organizationSearchFixture, UserGroupSearchFixture userGroupSearchFixture) {
        this._userLocalService = userLocalService;
        this._groupSearchFixture = groupSearchFixture;
        this._organizationSearchFixture = organizationSearchFixture;
        this._userGroupSearchFixture = userGroupSearchFixture;
    }

    public Address addAddress(User user) throws PortalException {
        List listTypes = ListTypeServiceUtil.getListTypes((String)ListTypeConstants.CONTACT_ADDRESS);
        ListType listType = (ListType)listTypes.get(0);
        long listTypeId = listType.getListTypeId();
        long contactId = user.getContactId();
        Contact contact = user.getContact();
        String modelClassName = contact.getModelClassName();
        Country country = CountryServiceUtil.getCountryByName((String)"united-states");
        long countryId = country.getCountryId();
        List regions = RegionServiceUtil.getRegions((long)countryId);
        Region region = (Region)regions.get(0);
        Address address = AddressLocalServiceUtil.addAddress((long)user.getUserId(), (String)modelClassName, (long)contactId, (String)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), (String)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), (String)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), (String)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), (String)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), (long)region.getRegionId(), (long)countryId, (long)listTypeId, (boolean)false, (boolean)false, (ServiceContext)new ServiceContext());
        this._addresses.add(address);
        return address;
    }

    @Deprecated
    public Group addGroup() throws Exception {
        return this.addGroup(new GroupBlueprint());
    }

    @Deprecated
    public Group addGroup(GroupBlueprint groupBlueprint) throws Exception {
        return this._groupSearchFixture.addGroup(groupBlueprint);
    }

    @Deprecated
    public Organization addOrganization() throws Exception {
        OrganizationBlueprint.OrganizationBlueprintBuilder organizationBlueprintBuilder = OrganizationSearchFixture.getTestOrganizationBlueprintBuilder();
        return this._organizationSearchFixture.addOrganization(organizationBlueprintBuilder.build());
    }

    @Deprecated
    public Organization addOrganization(OrganizationBlueprint organizationBlueprint) throws Exception {
        return this._organizationSearchFixture.addOrganization(organizationBlueprint);
    }

    public User addUser(String screenName, Group group, String ... assetTagNames) throws Exception {
        return this.addUser(screenName, RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), LocaleUtil.getDefault(), group, assetTagNames);
    }

    public User addUser(String screenName, String firstName, String lastName, Locale locale, Group group, String ... assetTagNames) throws Exception {
        ServiceContext serviceContext = UserSearchFixture.getServiceContext(group);
        serviceContext.setAssetTagNames(assetTagNames);
        User user = this._addUser(screenName, firstName, lastName, new long[]{group.getGroupId()}, locale, serviceContext);
        this._users.add(user);
        List assetTags = AssetTagLocalServiceUtil.getTags((String)user.getModelClassName(), (long)user.getPrimaryKey());
        this._assetTags.addAll(assetTags);
        return user;
    }

    public User addUser(UserBlueprint.UserBlueprintBuilder userBlueprintBuilder) {
        User user = this._addUser(userBlueprintBuilder);
        this._users.add(user);
        return user;
    }

    @Deprecated
    public UserGroup addUserGroup() throws Exception {
        return this._userGroupSearchFixture.addUserGroup(UserGroupSearchFixture.getTestUserGroupBlueprintBuilder());
    }

    @Deprecated
    public User addUserWithAddress(String screenName, Group group, String ... assetTagNames) throws Exception {
        User user = this.addUser(screenName, group, assetTagNames);
        this.addAddress(user);
        UserLocalServiceUtil.updateUser((User)user);
        return user;
    }

    @Deprecated
    public User addUserWithJobTitle(String screenName, Group group, String ... assetTagNames) throws Exception {
        User user = this.addUser(screenName, group, assetTagNames);
        user.setJobTitle(RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]));
        return UserLocalServiceUtil.updateUser((User)user);
    }

    @Deprecated
    public User addUserWithOrganization(String screenName, Group group, String ... assetTagNames) throws Exception {
        Organization organization = this.addOrganization();
        User user = this.addUser(screenName, group, assetTagNames);
        UserLocalServiceUtil.addOrganizationUser((long)organization.getOrganizationId(), (long)user.getUserId());
        return user;
    }

    @Deprecated
    public User addUserWithUserGroup(String screenName, Group group, String ... assetTagNames) throws Exception {
        User user = this.addUser(screenName, group, assetTagNames);
        UserGroup userGroup = this.addUserGroup();
        UserGroupLocalServiceUtil.addUserUserGroup((long)user.getUserId(), (UserGroup)userGroup);
        UserGroupLocalServiceUtil.addGroupUserGroup((long)group.getGroupId(), (UserGroup)userGroup);
        return user;
    }

    public List<Address> getAddresses() {
        return this._addresses;
    }

    public List<AssetTag> getAssetTags() {
        return this._assetTags;
    }

    @Deprecated
    public List<Group> getGroups() {
        return this._groupSearchFixture.getGroups();
    }

    @Deprecated
    public List<Organization> getOrganizations() {
        return this._organizationSearchFixture.getOrganizations();
    }

    public SearchContext getSearchContext(String keywords) throws Exception {
        SearchContext searchContext = new SearchContext();
        searchContext.setCompanyId(TestPropsValues.getCompanyId());
        searchContext.setKeywords(keywords);
        searchContext.setUserId(TestPropsValues.getUserId());
        return searchContext;
    }

    public UserBlueprint.UserBlueprintBuilder getTestUserBlueprintBuilder() {
        UserBlueprintImpl.UserBlueprintBuilderImpl userBlueprintBuilder = new UserBlueprintImpl.UserBlueprintBuilderImpl();
        final long companyId = UserSearchFixture.getTestCompanyId();
        final long groupId = UserSearchFixture.getTestGroupId();
        final long userId = UserSearchFixture.getTestUserId();
        ServiceContext serviceContext = new ServiceContext(){
            {
                this.setAddGroupPermissions(true);
                this.setAddGuestPermissions(true);
                this.setCompanyId(companyId);
                this.setScopeGroupId(groupId);
                this.setUserId(userId);
            }
        };
        return userBlueprintBuilder.autoPassword(true).birthdayMonth(0).birthdayDay(1).birthdayYear(1970).companyId(companyId).emailAddress(RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]) + RandomTestUtil.nextLong() + "@liferay.com").userId(userId).screenName(RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[]{NumericStringRandomizerBumper.INSTANCE, UniqueStringRandomizerBumper.INSTANCE})).locale(LocaleUtil.getDefault()).firstName(RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0])).lastName(RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0])).serviceContext(serviceContext);
    }

    @Deprecated
    public List<UserGroup> getUserGroups() {
        return this._userGroupSearchFixture.getUserGroups();
    }

    public List<User> getUsers() {
        return this._users;
    }

    public void setUp() throws Exception {
        this._companyId = TestPropsValues.getCompanyId();
        this._permissionChecker = PermissionThreadLocal.getPermissionChecker();
        PermissionThreadLocal.setPermissionChecker((PermissionChecker)new DummyPermissionChecker(){

            @Override
            public long getCompanyId() {
                return UserSearchFixture.this._companyId;
            }

            @Override
            public boolean hasPermission(Group group, String name, long primKey, String actionId) {
                return true;
            }

            @Override
            public boolean hasPermission(Group group, String name, String primKey, String actionId) {
                return true;
            }

            @Override
            public boolean hasPermission(long groupId, String name, long primKey, String actionId) {
                return true;
            }

            @Override
            public boolean hasPermission(long groupId, String name, String primKey, String actionId) {
                return true;
            }

            @Override
            public boolean isCompanyAdmin(long companyId) {
                return true;
            }
        });
        this._principal = PrincipalThreadLocal.getName();
        PrincipalThreadLocal.setName((long)TestPropsValues.getUserId());
    }

    public void tearDown() {
        PermissionThreadLocal.setPermissionChecker((PermissionChecker)this._permissionChecker);
        PrincipalThreadLocal.setName((String)this._principal);
    }

    public Map<String, String> toMap(List<Document> list) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Document document : list) {
            Object[] values = document.getValues("assetTagNames");
            Arrays.sort(values);
            map.put(document.get("screenName"), StringUtil.merge((Object[])values));
        }
        return map;
    }

    public Map<String, String> toMap(User user, String ... tags) {
        return Collections.singletonMap(user.getScreenName(), this.toStringTags(tags));
    }

    public String toStringTags(String[] tags) {
        ArrayList<String> list = new ArrayList<String>(tags.length);
        for (String tag : tags) {
            list.add(StringUtil.toLowerCase((String)tag));
        }
        Collections.sort(list);
        return StringUtil.merge(list);
    }

    protected static ServiceContext getServiceContext(Group group) throws Exception {
        return ServiceContextTestUtil.getServiceContext((long)group.getGroupId(), (long)TestPropsValues.getUserId());
    }

    protected static long getTestCompanyId() {
        try {
            return TestPropsValues.getCompanyId();
        }
        catch (PortalException portalException) {
            throw new RuntimeException(portalException);
        }
    }

    protected static long getTestGroupId() {
        try {
            return TestPropsValues.getGroupId();
        }
        catch (PortalException portalException) {
            throw new RuntimeException(portalException);
        }
    }

    protected static long getTestUserId() {
        try {
            return TestPropsValues.getUserId();
        }
        catch (PortalException portalException) {
            throw new RuntimeException(portalException);
        }
    }

    private User _addUser(String screenName, String firstName, String lastName, long[] groupIds, Locale locale, ServiceContext serviceContext) throws Exception {
        return UserTestUtil.addUser((long)this._companyId, (long)TestPropsValues.getUserId(), (String)screenName, (Locale)locale, (String)firstName, (String)lastName, (long[])groupIds, (ServiceContext)serviceContext);
    }

    private User _addUser(UserBlueprint.UserBlueprintBuilder userBlueprintBuilder) {
        UserBlueprint userBlueprint = userBlueprintBuilder.build();
        try {
            return this._userLocalService.addUserWithWorkflow(userBlueprint.getCreatorUserId(), userBlueprint.getCompanyId(), userBlueprint.isAutoPassword(), userBlueprint.getPassword1(), userBlueprint.getPassword2(), userBlueprint.isAutoScreenName(), userBlueprint.getScreenName(), userBlueprint.getEmailAddress(), userBlueprint.getLocale(), userBlueprint.getFirstName(), userBlueprint.getMiddleName(), userBlueprint.getLastName(), userBlueprint.getPrefixId(), userBlueprint.getSuffixId(), userBlueprint.isMale(), userBlueprint.getBirthdayMonth(), userBlueprint.getBirthdayDay(), userBlueprint.getBirthdayYear(), userBlueprint.getJobTitle(), userBlueprint.getGroupIds(), userBlueprint.getOrganizationIds(), userBlueprint.getRoleIds(), userBlueprint.getUserGroupIds(), userBlueprint.isSendMail(), userBlueprint.getServiceContext());
        }
        catch (PortalException portalException) {
            throw new RuntimeException(portalException);
        }
    }
}

