/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.item.selector.web.internal.display.context;

import com.liferay.portal.kernel.dao.search.RowChecker;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portlet.usersadmin.search.UserSearch;
import com.liferay.portlet.usersadmin.search.UserSearchTerms;
import com.liferay.users.admin.item.selector.web.internal.search.UserItemSelectorChecker;
import com.liferay.users.admin.kernel.util.UsersAdmin;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class UserItemSelectorViewDisplayContext {
    private final HttpServletRequest _httpServletRequest;
    private final String _itemSelectedEventName;
    private final PortletRequest _portletRequest;
    private final PortletURL _portletURL;
    private final RenderResponse _renderResponse;
    private SearchContainer<User> _searchContainer;
    private final UserLocalService _userLocalService;
    private final UsersAdmin _usersAdmin;

    public UserItemSelectorViewDisplayContext(UserLocalService userLocalService, UsersAdmin usersAdmin, HttpServletRequest httpServletRequest, PortletURL portletURL, String itemSelectedEventName) {
        this._userLocalService = userLocalService;
        this._usersAdmin = usersAdmin;
        this._httpServletRequest = httpServletRequest;
        this._portletURL = portletURL;
        this._itemSelectedEventName = itemSelectedEventName;
        this._portletRequest = (PortletRequest)httpServletRequest.getAttribute("javax.portlet.request");
        this._renderResponse = (RenderResponse)httpServletRequest.getAttribute("javax.portlet.response");
    }

    public String getItemSelectedEventName() {
        return this._itemSelectedEventName;
    }

    public String getOrderByCol() {
        return ParamUtil.getString((PortletRequest)this._portletRequest, (String)"orderByCol", (String)"first-name");
    }

    public String getOrderByType() {
        return ParamUtil.getString((PortletRequest)this._portletRequest, (String)"orderByType", (String)"asc");
    }

    public PortletURL getPortletURL() {
        return this._portletURL;
    }

    public SearchContainer<User> getSearchContainer() throws PortalException {
        if (this._searchContainer != null) {
            return this._searchContainer;
        }
        this._searchContainer = new UserSearch(this._portletRequest, this.getPortletURL());
        this._searchContainer.setEmptyResultsMessage("no-users-were-found");
        OrderByComparator orderByComparator = this._usersAdmin.getUserOrderByComparator(this.getOrderByCol(), this.getOrderByType());
        UserItemSelectorChecker rowChecker = new UserItemSelectorChecker(this._renderResponse, this.getCheckedUserIds());
        this._searchContainer.setOrderByCol(this.getOrderByCol());
        this._searchContainer.setOrderByComparator(orderByComparator);
        this._searchContainer.setOrderByType(this.getOrderByType());
        this._searchContainer.setRowChecker((RowChecker)rowChecker);
        UserSearchTerms userSearchTerms = (UserSearchTerms)this._searchContainer.getSearchTerms();
        long companyId = CompanyThreadLocal.getCompanyId();
        String keywords = userSearchTerms.getKeywords();
        int status = userSearchTerms.getStatus();
        int total = this._userLocalService.searchCount(companyId, keywords, status, null);
        this._searchContainer.setTotal(total);
        List results = this._userLocalService.search(companyId, keywords, status, null, this._searchContainer.getStart(), this._searchContainer.getEnd(), orderByComparator);
        this._searchContainer.setResults(results);
        return this._searchContainer;
    }

    protected long[] getCheckedUserIds() {
        return ParamUtil.getLongValues((PortletRequest)this._portletRequest, (String)"checkedUserIds");
    }
}

