/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.demo.internal;

import com.liferay.portal.instance.lifecycle.BasePortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.roles.admin.demo.data.creator.RoleDemoDataCreator;
import com.liferay.site.demo.data.creator.SiteDemoDataCreator;
import com.liferay.users.admin.demo.data.creator.BasicUserDemoDataCreator;
import com.liferay.users.admin.demo.data.creator.CompanyAdminUserDemoDataCreator;
import com.liferay.users.admin.demo.data.creator.SiteAdminUserDemoDataCreator;
import com.liferay.users.admin.demo.data.creator.SiteMemberUserDemoDataCreator;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={PortalInstanceLifecycleListener.class})
public class UsersDemo
extends BasePortalInstanceLifecycleListener {
    @Reference
    private BasicUserDemoDataCreator _basicUserDemoDataCreator;
    @Reference
    private CompanyAdminUserDemoDataCreator _companyAdminUserDemoDataCreator;
    @Reference(target="(javax.portlet.name=com_liferay_journal_content_web_portlet_JournalContentPortlet)")
    private Portlet _journalContentPortlet;
    @Reference(target="(javax.portlet.name=com_liferay_journal_web_portlet_JournalPortlet)")
    private Portlet _journalPortlet;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private SiteAdminUserDemoDataCreator _siteAdminUserDemoDataCreator;
    @Reference
    private SiteDemoDataCreator _siteDemoDataCreator;
    @Reference
    private SiteMemberUserDemoDataCreator _siteMemberUserDemoDataCreator;
    @Reference(target="(role.type=site)")
    private RoleDemoDataCreator _siteRoleDemoDataCreator;

    public void portalInstanceRegistered(Company company) throws Exception {
        this._basicUserDemoDataCreator.create(company.getCompanyId(), "usersn", "userea@liferay.com", "userfn", "userln");
        this._companyAdminUserDemoDataCreator.create(company.getCompanyId(), "bruno.admin@liferay.com");
        Group acmeCorpGroup = this._siteDemoDataCreator.create(company.getCompanyId(), "Acme\u2019s Corporation");
        this._siteAdminUserDemoDataCreator.create(acmeCorpGroup.getGroupId(), "helen@liferay.com");
        String webContentAuthorPermissionsXML = StringUtil.read(UsersDemo.class, (String)"dependencies/permissions-web-content-author.xml");
        Role webContentAuthorRole = this._siteRoleDemoDataCreator.create(company.getCompanyId(), "Web Content Author", webContentAuthorPermissionsXML);
        this._siteMemberUserDemoDataCreator.create(acmeCorpGroup.getGroupId(), "joe@liferay.com", new long[]{webContentAuthorRole.getRoleId()});
        Group petLoversGroup = this._siteDemoDataCreator.create(company.getCompanyId(), "Pet Lovers");
        String forumModeratorPermissionsXML = StringUtil.read(UsersDemo.class, (String)"dependencies/permissions-forum-moderator.xml");
        Role forumModeratorRole = this._siteRoleDemoDataCreator.create(company.getCompanyId(), "Forum Moderator", forumModeratorPermissionsXML);
        this._siteMemberUserDemoDataCreator.create(petLoversGroup.getGroupId(), "maria@liferay.com", new long[]{forumModeratorRole.getRoleId()});
        Role portalContentReviewerRole = this._roleLocalService.getRole(company.getCompanyId(), "Portal Content Reviewer");
        User portalContentReviewerUser = this._basicUserDemoDataCreator.create(company.getCompanyId(), "reviewersn", "reviewerea@liferay.com", "reviewerfn", "reviewerln");
        this._roleLocalService.addUserRole(portalContentReviewerUser.getUserId(), portalContentReviewerRole);
    }

    @Deactivate
    protected void deactivate() throws PortalException {
        this._basicUserDemoDataCreator.delete();
        this._companyAdminUserDemoDataCreator.delete();
        this._siteAdminUserDemoDataCreator.delete();
        this._siteMemberUserDemoDataCreator.delete();
        this._siteDemoDataCreator.delete();
        this._siteRoleDemoDataCreator.delete();
    }
}

