/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.demo.data.creator.internal;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.users.admin.demo.data.creator.BasicUserDemoDataCreator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseUserDemoDataCreator
implements BasicUserDemoDataCreator {
    protected UserLocalService userLocalService;
    private final List<Long> _userIds = new ArrayList<Long>();

    public User createBaseUser(long companyId, String emailAddress) throws PortalException {
        User user = this.userLocalService.fetchUserByEmailAddress(companyId, emailAddress);
        if (user != null) {
            return user;
        }
        String[] fullNameArray = this.getFullNameArray(emailAddress);
        String firstName = fullNameArray[0];
        String lastName = fullNameArray[1];
        boolean autoPassword = true;
        String password1 = "test";
        String password2 = "test";
        long facebookId = 0L;
        String openId = "";
        Locale locale = LocaleUtil.SPAIN;
        String middleName = "";
        long prefixId = 0L;
        long suffixId = 0L;
        boolean male = true;
        int birthdayMonth = 0;
        int birthdayDay = 1;
        int birthdayYear = 1970;
        String jobTitle = StringUtil.randomString();
        long[] groupIds = null;
        long[] organizationIds = null;
        long[] roleIds = null;
        long[] userGroupIds = null;
        boolean sendMail = false;
        user = this.userLocalService.addUser(0L, companyId, autoPassword, password1, password2, true, "", emailAddress, facebookId, openId, locale, firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, jobTitle, groupIds, organizationIds, roleIds, userGroupIds, sendMail, new ServiceContext());
        this._userIds.add(user.getUserId());
        return user;
    }

    public void delete() throws PortalException {
        for (long userId : this._userIds) {
            this.userLocalService.deleteUser(userId);
        }
    }

    protected String[] getFullNameArray(String emailAddress) {
        String emailAccountName = emailAddress.substring(0, emailAddress.indexOf("@"));
        String[] fullNameArray = StringUtil.split((String)emailAccountName, (String)".");
        String firstName = StringUtil.randomString();
        String lastName = StringUtil.randomString();
        if (fullNameArray.length > 0) {
            firstName = StringUtil.upperCaseFirstLetter((String)fullNameArray[0]);
        }
        if (fullNameArray.length > 1) {
            lastName = StringUtil.upperCaseFirstLetter((String)fullNameArray[1]);
        }
        return new String[]{firstName, lastName};
    }

    @Reference(unbind="-")
    protected void setUserLocalService(UserLocalService userLocalService) {
        this.userLocalService = userLocalService;
    }
}

