/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.search;

import com.liferay.portal.kernel.dao.search.RowChecker;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.membershippolicy.OrganizationMembershipPolicyUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.UserPermissionUtil;
import com.liferay.portal.util.PropsValues;
import javax.portlet.PortletResponse;
import javax.portlet.RenderResponse;

public class UserOrganizationChecker
extends RowChecker {
    private static final Log _log = LogFactoryUtil.getLog(UserOrganizationChecker.class);
    private final Organization _organization;

    public UserOrganizationChecker(RenderResponse renderResponse, Organization organization) {
        super((PortletResponse)renderResponse);
        this._organization = organization;
    }

    public boolean isChecked(Object object) {
        User user = (User)object;
        try {
            return UserLocalServiceUtil.hasOrganizationUser((long)this._organization.getOrganizationId(), (long)user.getUserId());
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            return false;
        }
    }

    public boolean isDisabled(Object object) {
        if (!PropsValues.ORGANIZATIONS_ASSIGNMENT_STRICT) {
            return false;
        }
        User user = (User)object;
        try {
            PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
            if (this.isChecked(user) ? OrganizationMembershipPolicyUtil.isMembershipProtected((PermissionChecker)permissionChecker, (long)user.getUserId(), (long)this._organization.getOrganizationId()) || OrganizationMembershipPolicyUtil.isMembershipRequired((long)user.getUserId(), (long)this._organization.getOrganizationId()) : !OrganizationMembershipPolicyUtil.isMembershipAllowed((long)user.getUserId(), (long)this._organization.getOrganizationId())) {
                return true;
            }
            return !UserPermissionUtil.contains((PermissionChecker)permissionChecker, (long)user.getUserId(), (String)"UPDATE");
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            return super.isDisabled(object);
        }
    }
}

