/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.user.groups.admin.web.internal.portlet;

import com.liferay.portal.kernel.exception.DuplicateUserGroupException;
import com.liferay.portal.kernel.exception.NoSuchUserGroupException;
import com.liferay.portal.kernel.exception.RequiredUserGroupException;
import com.liferay.portal.kernel.exception.UserGroupNameException;
import com.liferay.portal.kernel.messaging.proxy.ProxyModeThreadLocal;
import com.liferay.portal.kernel.messaging.proxy.ProxyModeThreadLocalCloseable;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCPortlet;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.membershippolicy.MembershipPolicyException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.service.UserGroupService;
import com.liferay.portal.kernel.service.UserService;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.sites.kernel.util.SitesUtil;
import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"com.liferay.portlet.css-class-wrapper=portlet-users-admin", "com.liferay.portlet.display-category=category.hidden", "com.liferay.portlet.header-portlet-css=/css/main.css", "com.liferay.portlet.icon=/icons/user_groups_admin.png", "com.liferay.portlet.private-request-attributes=false", "com.liferay.portlet.private-session-attributes=false", "com.liferay.portlet.render-weight=50", "com.liferay.portlet.use-default-template=true", "javax.portlet.display-name=User Groups Admin", "javax.portlet.expiration-cache=0", "javax.portlet.init-param.template-path=/META-INF/resources/", "javax.portlet.init-param.view-template=/view.jsp", "javax.portlet.name=com_liferay_user_groups_admin_web_portlet_UserGroupsAdminPortlet", "javax.portlet.resource-bundle=content.Language", "javax.portlet.security-role-ref=administrator", "javax.portlet.supports.mime-type=text/html"}, service={Portlet.class})
public class UserGroupsAdminPortlet
extends MVCPortlet {
    private UserGroupService _userGroupService;
    private UserService _userService;

    public void deleteUserGroups(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long[] deleteUserGroupIds;
        for (long deleteUserGroupId : deleteUserGroupIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"deleteUserGroupIds"), (long)0L)) {
            this._userGroupService.deleteUserGroup(deleteUserGroupId);
        }
    }

    public void editUserGroup(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long userGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"userGroupId");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        String description = ParamUtil.getString((PortletRequest)actionRequest, (String)"description");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)UserGroup.class.getName(), (PortletRequest)actionRequest);
        UserGroup userGroup = null;
        try (ProxyModeThreadLocalCloseable proxyModeThreadLocalCloseable = new ProxyModeThreadLocalCloseable();){
            ProxyModeThreadLocal.setForceSync((boolean)true);
            userGroup = userGroupId <= 0L ? this._userGroupService.addUserGroup(name, description, serviceContext) : this._userGroupService.updateUserGroup(userGroupId, name, description, serviceContext);
        }
        long publicLayoutSetPrototypeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"publicLayoutSetPrototypeId");
        long privateLayoutSetPrototypeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"privateLayoutSetPrototypeId");
        if (privateLayoutSetPrototypeId > 0L || publicLayoutSetPrototypeId > 0L) {
            boolean publicLayoutSetPrototypeLinkEnabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"publicLayoutSetPrototypeLinkEnabled");
            boolean privateLayoutSetPrototypeLinkEnabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"privateLayoutSetPrototypeLinkEnabled");
            SitesUtil.updateLayoutSetPrototypesLinks((Group)userGroup.getGroup(), (long)publicLayoutSetPrototypeId, (long)privateLayoutSetPrototypeId, (boolean)publicLayoutSetPrototypeLinkEnabled, (boolean)privateLayoutSetPrototypeLinkEnabled);
        }
    }

    public void editUserGroupAssignments(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long userGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"userGroupId");
        long[] addUserIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"addUserIds"), (long)0L);
        long[] removeUserIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"removeUserIds"), (long)0L);
        try (ProxyModeThreadLocalCloseable proxyModeThreadLocalCloseable = new ProxyModeThreadLocalCloseable();){
            ProxyModeThreadLocal.setForceSync((boolean)true);
            this._userService.addUserGroupUsers(userGroupId, addUserIds);
            this._userService.unsetUserGroupUsers(userGroupId, removeUserIds);
        }
    }

    protected void doDispatch(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        if (SessionErrors.contains((PortletRequest)renderRequest, (String)NoSuchUserGroupException.class.getName()) || SessionErrors.contains((PortletRequest)renderRequest, (Class[])PrincipalException.getNestedClasses())) {
            this.include("/error.jsp", renderRequest, renderResponse);
        } else if (SessionErrors.contains((PortletRequest)renderRequest, (String)RequiredUserGroupException.class.getName())) {
            this.include("/view.jsp", renderRequest, renderResponse);
        } else if (SessionErrors.contains((PortletRequest)renderRequest, (String)DuplicateUserGroupException.class.getName()) || SessionErrors.contains((PortletRequest)renderRequest, (String)UserGroupNameException.class.getName())) {
            this.include("/edit_user_group.jsp", renderRequest, renderResponse);
        } else {
            super.doDispatch(renderRequest, renderResponse);
        }
    }

    protected boolean isSessionErrorException(Throwable cause) {
        return cause instanceof DuplicateUserGroupException || cause instanceof MembershipPolicyException || cause instanceof NoSuchUserGroupException || cause instanceof PrincipalException || cause instanceof RequiredUserGroupException || cause instanceof UserGroupNameException;
    }

    @Reference(unbind="-")
    protected void setUserGroupService(UserGroupService userGroupService) {
        this._userGroupService = userGroupService;
    }

    @Reference(unbind="-")
    protected void setUserService(UserService userService) {
        this._userService = userService;
    }
}

