/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.user.associated.data.web.internal.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.search.DisplayTerms;
import com.liferay.portal.kernel.dao.search.EmptyOnClickRowChecker;
import com.liferay.portal.kernel.dao.search.RowChecker;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.PortletURLUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.user.associated.data.display.UADDisplay;
import com.liferay.user.associated.data.web.internal.display.UADApplicationSummaryDisplay;
import com.liferay.user.associated.data.web.internal.display.UADEntity;
import com.liferay.user.associated.data.web.internal.display.UADHierarchyDisplay;
import com.liferay.user.associated.data.web.internal.search.UADHierarchyChecker;
import com.liferay.user.associated.data.web.internal.util.SafeDisplayValueUtil;
import com.liferay.user.associated.data.web.internal.util.UADLanguageUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={UADSearchContainerBuilder.class})
public class UADSearchContainerBuilder {
    private static final Log _log = LogFactoryUtil.getLog(UADSearchContainerBuilder.class);
    @Reference
    private Portal _portal;

    public SearchContainer<UADEntity> getSearchContainer(RenderRequest renderRequest, LiferayPortletResponse liferayPortletResponse, PortletURL currentURL, List<UADApplicationSummaryDisplay> uadApplicationSummaryDisplays) throws PortletException {
        SearchContainer<UADEntity> searchContainer = this._constructSearchContainer(renderRequest, currentURL, "name", new String[]{"name", "count"});
        ArrayList uadEntities = new ArrayList();
        for (UADApplicationSummaryDisplay uadApplicationSummaryDisplay : uadApplicationSummaryDisplays) {
            String applicationKey = uadApplicationSummaryDisplay.getApplicationKey();
            if (applicationKey.equals("all-applications") || uadApplicationSummaryDisplay.getCount() == 0) continue;
            uadEntities.add(this._constructUADEntity(renderRequest, liferayPortletResponse, currentURL, uadApplicationSummaryDisplay));
        }
        Stream uadEntitiesStream = uadEntities.stream();
        List results = uadEntitiesStream.sorted(this._getComparator(searchContainer.getOrderByCol(), searchContainer.getOrderByType())).skip(searchContainer.getStart()).limit(searchContainer.getDelta()).collect(Collectors.toList());
        searchContainer.setResults(results);
        searchContainer.setRowChecker((RowChecker)new EmptyOnClickRowChecker((PortletResponse)liferayPortletResponse));
        searchContainer.setTotal(uadEntities.size());
        return searchContainer;
    }

    public SearchContainer<UADEntity> getSearchContainer(RenderRequest renderRequest, LiferayPortletResponse liferayPortletResponse, PortletURL currentURL, long[] groupIds, User selectedUser, UADDisplay uadDisplay) {
        SearchContainer<UADEntity> searchContainer = this._constructSearchContainer(renderRequest, currentURL, "modifiedDate", uadDisplay.getSortingFieldNames());
        try {
            DisplayTerms displayTerms = searchContainer.getDisplayTerms();
            List entities = uadDisplay.search(selectedUser.getUserId(), groupIds, displayTerms.getKeywords(), searchContainer.getOrderByCol(), searchContainer.getOrderByType(), searchContainer.getStart(), searchContainer.getEnd());
            LiferayPortletRequest liferayPortletRequest = this._portal.getLiferayPortletRequest((PortletRequest)renderRequest);
            ArrayList uadEntities = new ArrayList();
            for (Object entity : entities) {
                uadEntities.add(this._constructUADEntity(liferayPortletRequest, liferayPortletResponse, entity, uadDisplay));
            }
            searchContainer.setResults(uadEntities);
            searchContainer.setTotal((int)uadDisplay.searchCount(selectedUser.getUserId(), groupIds, displayTerms.getKeywords()));
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)e, (Throwable)e);
            }
            searchContainer.setResults(Collections.emptyList());
            searchContainer.setTotal(0);
        }
        UADHierarchyChecker rowChecker = new UADHierarchyChecker((PortletResponse)liferayPortletResponse, new UADDisplay[]{uadDisplay});
        searchContainer.setRowChecker((RowChecker)rowChecker);
        return searchContainer;
    }

    public SearchContainer<UADEntity> getSearchContainer(RenderRequest renderRequest, LiferayPortletResponse liferayPortletResponse, String applicationKey, PortletURL currentURL, long[] groupIds, Class<?> parentContainerClass, Serializable parentContainerId, User selectedUser, UADHierarchyDisplay uadHierarchyDisplay) {
        SearchContainer<UADEntity> searchContainer = this._constructSearchContainer(renderRequest, currentURL, "name", uadHierarchyDisplay.getSortingFieldNames());
        try {
            DisplayTerms displayTerms = searchContainer.getDisplayTerms();
            ArrayList<Object> entities = new ArrayList<Object>();
            entities.addAll(uadHierarchyDisplay.search(parentContainerClass, parentContainerId, selectedUser.getUserId(), groupIds, displayTerms.getKeywords(), null, null, -1, -1));
            String parentContainerIdString = String.valueOf(parentContainerId);
            if (parentContainerIdString.equals("0")) {
                entities.addAll(uadHierarchyDisplay.search(parentContainerClass, Long.valueOf(-1L), selectedUser.getUserId(), groupIds, displayTerms.getKeywords(), null, null, -1, -1));
            }
            LiferayPortletRequest liferayPortletRequest = this._portal.getLiferayPortletRequest((PortletRequest)renderRequest);
            ArrayList uadEntities = new ArrayList();
            for (Object e : entities) {
                uadEntities.add(this._constructUADEntity(liferayPortletRequest, liferayPortletResponse, applicationKey, e, selectedUser.getUserId(), uadHierarchyDisplay));
            }
            Stream uadEntitiesStream = uadEntities.stream();
            List list = uadEntitiesStream.sorted(this._getComparator(searchContainer.getOrderByCol(), searchContainer.getOrderByType())).skip(searchContainer.getStart()).limit(searchContainer.getDelta()).collect(Collectors.toList());
            searchContainer.setResults(list);
            searchContainer.setTotal(entities.size());
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)e, (Throwable)e);
            }
            searchContainer.setResults(Collections.emptyList());
            searchContainer.setTotal(0);
        }
        UADHierarchyChecker rowChecker = new UADHierarchyChecker((PortletResponse)liferayPortletResponse, uadHierarchyDisplay.getUADDisplays());
        searchContainer.setRowChecker((RowChecker)rowChecker);
        return searchContainer;
    }

    private SearchContainer<UADEntity> _constructSearchContainer(RenderRequest renderRequest, PortletURL currentURL, String defaultOrderByCol, String[] sortingFieldNames) {
        DisplayTerms displayTerms = new DisplayTerms((PortletRequest)renderRequest);
        int cur = ParamUtil.getInteger((PortletRequest)renderRequest, (String)"cur", (int)1);
        SearchContainer searchContainer = new SearchContainer((PortletRequest)renderRequest, displayTerms, displayTerms, "cur", cur, SearchContainer.DEFAULT_DELTA, currentURL, null, "no-entities-remain-of-this-type", null);
        searchContainer.setId(StringBundler.concat((String[])new String[]{"UADEntities", "_", StringUtil.randomId()}));
        String orderByCol = ParamUtil.getString((PortletRequest)renderRequest, (String)"orderByCol");
        if (!ArrayUtil.contains((Object[])sortingFieldNames, (Object)orderByCol)) {
            orderByCol = defaultOrderByCol;
        }
        searchContainer.setOrderByCol(orderByCol);
        String orderByType = ParamUtil.getString((PortletRequest)renderRequest, (String)"orderByType", (String)"asc");
        searchContainer.setOrderByType(orderByType);
        LinkedHashMap<String, String> orderableHeaders = new LinkedHashMap<String, String>();
        for (String orderByColumn : sortingFieldNames) {
            orderableHeaders.put(TextFormatter.format((String)orderByColumn, (int)10), orderByColumn);
        }
        searchContainer.setOrderableHeaders(orderableHeaders);
        return searchContainer;
    }

    private <T> UADEntity<T> _constructUADEntity(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, String applicationKey, T entity, long selectedUserId, UADHierarchyDisplay uadHierarchyDisplay) throws Exception {
        String editURL = uadHierarchyDisplay.getEditURL(liferayPortletRequest, liferayPortletResponse, entity);
        String viewURL = uadHierarchyDisplay.getViewURL(liferayPortletRequest, liferayPortletResponse, applicationKey, entity, selectedUserId);
        UADEntity uadEntity = new UADEntity(uadHierarchyDisplay.unwrap(entity), uadHierarchyDisplay.getPrimaryKey(entity), editURL, uadHierarchyDisplay.getTypeClass(entity), uadHierarchyDisplay.isUserOwned(entity, selectedUserId), viewURL);
        Map<String, Object> columnFieldValues = uadHierarchyDisplay.getFieldValues(entity, LocaleThreadLocal.getThemeDisplayLocale());
        for (Map.Entry<String, Object> entry : columnFieldValues.entrySet()) {
            uadEntity.addColumnEntry(entry.getKey(), SafeDisplayValueUtil.get(entry.getValue()));
        }
        return uadEntity;
    }

    private <T> UADEntity<T> _constructUADEntity(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, T entity, UADDisplay<T> uadDisplay) throws Exception {
        UADEntity<T> uadEntity = new UADEntity<T>(entity, uadDisplay.getPrimaryKey(entity), uadDisplay.getEditURL(entity, liferayPortletRequest, liferayPortletResponse), uadDisplay.getTypeClass(), true, null);
        Map columnFieldValues = uadDisplay.getFieldValues(entity, uadDisplay.getColumnFieldNames(), LocaleThreadLocal.getThemeDisplayLocale());
        for (String columnFieldName : uadDisplay.getColumnFieldNames()) {
            uadEntity.addColumnEntry(columnFieldName, SafeDisplayValueUtil.get(columnFieldValues.get(columnFieldName)));
        }
        return uadEntity;
    }

    private <T> UADEntity<T> _constructUADEntity(RenderRequest renderRequest, LiferayPortletResponse liferayPortletResponse, PortletURL currentURL, UADApplicationSummaryDisplay uadApplicationSummaryDisplay) throws PortletException {
        ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletURL viewURL = PortletURLUtil.clone((PortletURL)currentURL, (LiferayPortletResponse)liferayPortletResponse);
        viewURL.setParameter("applicationKey", uadApplicationSummaryDisplay.getApplicationKey());
        UADEntity<Object> uadEntity = new UADEntity<Object>(null, (Serializable)((Object)uadApplicationSummaryDisplay.getApplicationKey()), null, null, true, viewURL.toString());
        uadEntity.addColumnEntry("name", UADLanguageUtil.getApplicationName(uadApplicationSummaryDisplay.getApplicationKey(), themeDisplay.getLocale()));
        uadEntity.addColumnEntry("count", uadApplicationSummaryDisplay.getCount());
        return uadEntity;
    }

    private Comparator<UADEntity> _getComparator(String orderByColumn, String orderByType) {
        Comparator<UADEntity> comparator = Comparator.comparing(uadEntity -> {
            Object entry = uadEntity.getColumnEntry(orderByColumn);
            if (entry == null) {
                return "";
            }
            return (String)entry;
        });
        if (orderByColumn.equals("count")) {
            comparator = Comparator.comparingLong(uadEntity -> {
                Object entry = uadEntity.getColumnEntry(orderByColumn);
                try {
                    return Long.valueOf((String)entry);
                }
                catch (NumberFormatException nfe) {
                    return 0L;
                }
            });
        }
        if (orderByType.equals("desc")) {
            comparator = comparator.reversed();
        }
        return comparator;
    }
}

