/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.user.associated.data.web.internal.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.user.associated.data.anonymizer.UADAnonymizer;
import com.liferay.user.associated.data.component.UADComponent;
import com.liferay.user.associated.data.display.UADDisplay;
import com.liferay.user.associated.data.web.internal.display.UADApplicationSummaryDisplay;
import com.liferay.user.associated.data.web.internal.registry.UADRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={UADApplicationSummaryHelper.class})
public class UADApplicationSummaryHelper {
    @Reference
    private Portal _portal;
    @Reference
    private UADRegistry _uadRegistry;

    public List<UADAnonymizer> getApplicationUADAnonymizers(String applicationKey) {
        Stream<UADDisplay> uadDisplayStream = this._uadRegistry.getApplicationUADDisplayStream(applicationKey);
        return uadDisplayStream.map(UADComponent::getTypeClass).map(Class::getName).map(key -> this._uadRegistry.getUADAnonymizer((String)key)).collect(Collectors.toList());
    }

    public String getDefaultUADRegistryKey(String applicationKey) {
        List<UADDisplay> uadDisplays = this._uadRegistry.getApplicationUADDisplays(applicationKey);
        UADDisplay uadDisplay = uadDisplays.get(0);
        if (uadDisplay == null) {
            return null;
        }
        Class typeClass = uadDisplay.getTypeClass();
        return typeClass.getName();
    }

    public int getTotalNonreviewableUADEntitiesCount(long userId) {
        return this._getNonreviewableUADEntitiesCount(this._uadRegistry.getNonreviewableUADAnonymizerStream(), userId);
    }

    public int getTotalReviewableUADEntitiesCount(long userId) {
        return this._getReviewableUADEntitiesCount(this._uadRegistry.getUADDisplayStream(), userId);
    }

    public UADApplicationSummaryDisplay getUADApplicationSummaryDisplay(String applicationKey, List<UADDisplay> uadDisplayStream, long userId, long[] groupIds) {
        UADApplicationSummaryDisplay uadApplicationSummaryDisplay = new UADApplicationSummaryDisplay();
        int count = this._getReviewableUADEntitiesCount(uadDisplayStream.stream(), userId, groupIds);
        uadApplicationSummaryDisplay.setCount(count);
        uadApplicationSummaryDisplay.setApplicationKey(applicationKey);
        return uadApplicationSummaryDisplay;
    }

    public List<UADApplicationSummaryDisplay> getUADApplicationSummaryDisplays(long userId, long[] groupIds) {
        ArrayList<UADApplicationSummaryDisplay> uadApplicationSummaryDisplays = new ArrayList<UADApplicationSummaryDisplay>();
        UADApplicationSummaryDisplay allApplicationsUADApplicationSummaryDisplay = new UADApplicationSummaryDisplay();
        allApplicationsUADApplicationSummaryDisplay.setApplicationKey("all-applications");
        ArrayList<UADApplicationSummaryDisplay> generatedUADApplicationSummaryDisplays = new ArrayList<UADApplicationSummaryDisplay>();
        Set<String> applicationUADDisplayKeySet = this._uadRegistry.getApplicationUADDisplaysKeySet();
        int count = 0;
        for (String applicationKey : applicationUADDisplayKeySet) {
            Stream<UADDisplay> uadDisplayStream = this._uadRegistry.getApplicationUADDisplayStream(applicationKey);
            List<UADDisplay> applicationUADDisplays = uadDisplayStream.filter(uadDisplay -> ArrayUtil.isNotEmpty((long[])groupIds) == uadDisplay.isSiteScoped()).collect(Collectors.toList());
            if (ListUtil.isEmpty(applicationUADDisplays)) continue;
            UADApplicationSummaryDisplay uadApplicationSummaryDisplay3 = this.getUADApplicationSummaryDisplay(applicationKey, applicationUADDisplays, userId, groupIds);
            generatedUADApplicationSummaryDisplays.add(uadApplicationSummaryDisplay3);
            count += uadApplicationSummaryDisplay3.getCount();
        }
        allApplicationsUADApplicationSummaryDisplay.setCount(count);
        uadApplicationSummaryDisplays.add(allApplicationsUADApplicationSummaryDisplay);
        generatedUADApplicationSummaryDisplays.sort((uadApplicationSummaryDisplay, uadApplicationSummaryDisplay2) -> {
            String applicationKey1 = uadApplicationSummaryDisplay.getApplicationKey();
            return applicationKey1.compareTo(uadApplicationSummaryDisplay2.getApplicationKey());
        });
        uadApplicationSummaryDisplays.addAll(generatedUADApplicationSummaryDisplays);
        return uadApplicationSummaryDisplays;
    }

    private int _getNonreviewableUADEntitiesCount(Stream<UADAnonymizer> uadAnonymizerStream, long userId) {
        return uadAnonymizerStream.mapToInt(uadAnonymizer -> {
            try {
                return (int)uadAnonymizer.count(userId);
            }
            catch (PortalException pe) {
                throw new SystemException((Throwable)pe);
            }
        }).sum();
    }

    private int _getReviewableUADEntitiesCount(Stream<UADDisplay> uadDisplayStream, long userId) {
        return uadDisplayStream.mapToInt(uadDisplay -> (int)uadDisplay.count(userId)).sum();
    }

    private int _getReviewableUADEntitiesCount(Stream<UADDisplay> uadDisplayStream, long userId, long[] groupIds) {
        return uadDisplayStream.mapToInt(uadDisplay -> (int)uadDisplay.searchCount(userId, groupIds, null)).sum();
    }
}

