/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.user.associated.data.web.internal.registry;

import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapperFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.user.associated.data.anonymizer.UADAnonymizer;
import com.liferay.user.associated.data.component.UADComponent;
import com.liferay.user.associated.data.display.UADDisplay;
import com.liferay.user.associated.data.display.UADHierarchyDeclaration;
import com.liferay.user.associated.data.exporter.UADExporter;
import com.liferay.user.associated.data.web.internal.display.UADHierarchyDisplay;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(immediate=true, service={UADRegistry.class})
public class UADRegistry {
    private ServiceTrackerMap<String, List<UADAnonymizer>> _bundleUADAnonymizerServiceTrackerMap;
    private ServiceTrackerMap<String, List<UADDisplay>> _bundleUADDisplayServiceTrackerMap;
    private ServiceTrackerMap<String, List<UADExporter>> _bundleUADExporterServiceTrackerMap;
    private ServiceTrackerMap<String, UADHierarchyDeclaration> _bundleUADHierarchyDeclarationServiceTrackerMap;
    private ServiceTrackerMap<String, UADAnonymizer> _uadAnonymizerServiceTrackerMap;
    private ServiceTrackerMap<String, UADDisplay> _uadDisplayServiceTrackerMap;
    private ServiceTrackerMap<String, UADExporter> _uadExporterServiceTrackerMap;

    public List<UADAnonymizer> getApplicationUADAnonymizers(String applicationKey) {
        return (List)this._bundleUADAnonymizerServiceTrackerMap.getService((Object)applicationKey);
    }

    public Set<String> getApplicationUADAnonymizersKeySet() {
        return this._bundleUADAnonymizerServiceTrackerMap.keySet();
    }

    public Stream<UADAnonymizer> getApplicationUADAnonymizerStream(String applicationKey) {
        List<UADAnonymizer> uadAnonymizerList = this.getApplicationUADAnonymizers(applicationKey);
        return uadAnonymizerList.stream();
    }

    public List<UADDisplay> getApplicationUADDisplays(String applicationKey) {
        return (List)this._bundleUADDisplayServiceTrackerMap.getService((Object)applicationKey);
    }

    public Set<String> getApplicationUADDisplaysKeySet() {
        return this._bundleUADDisplayServiceTrackerMap.keySet();
    }

    public Stream<UADDisplay> getApplicationUADDisplayStream(String applicationKey) {
        List<UADDisplay> uadDisplayList = this.getApplicationUADDisplays(applicationKey);
        if (uadDisplayList == null) {
            return Stream.empty();
        }
        return uadDisplayList.stream();
    }

    public List<UADExporter> getApplicationUADExporters(String applicationKey) {
        return (List)this._bundleUADExporterServiceTrackerMap.getService((Object)applicationKey);
    }

    public Set<String> getApplicationUADExportersKeySet() {
        return this._bundleUADDisplayServiceTrackerMap.keySet();
    }

    public List<UADAnonymizer> getNonreviewableApplicationUADAnonymizers(String applicationKey) {
        List<UADAnonymizer> applicationUADAnonymizers = this.getApplicationUADAnonymizers(applicationKey);
        Stream<UADDisplay> applicationUADDisplayStream = this.getApplicationUADDisplayStream(applicationKey);
        return new ArrayList<UADAnonymizer>(this._getNonreviewableUADAnonymizers(applicationUADAnonymizers, applicationUADDisplayStream));
    }

    public Collection<UADAnonymizer> getNonreviewableUADAnonymizers() {
        Collection<UADAnonymizer> uadAnonymizers = this.getUADAnonymizers();
        Stream<UADDisplay> uadDisplayStream = this.getUADDisplayStream();
        return this._getNonreviewableUADAnonymizers(uadAnonymizers, uadDisplayStream);
    }

    public Stream<UADAnonymizer> getNonreviewableUADAnonymizerStream() {
        return this.getNonreviewableUADAnonymizers().stream();
    }

    public UADAnonymizer getUADAnonymizer(String key) {
        return (UADAnonymizer)this._uadAnonymizerServiceTrackerMap.getService((Object)key);
    }

    public Collection<UADAnonymizer> getUADAnonymizers() {
        return this._uadAnonymizerServiceTrackerMap.values();
    }

    public Stream<UADAnonymizer> getUADAnonymizerStream() {
        return this.getUADAnonymizers().stream();
    }

    public UADDisplay getUADDisplay(String key) {
        return (UADDisplay)this._uadDisplayServiceTrackerMap.getService((Object)key);
    }

    public Collection<UADDisplay> getUADDisplays() {
        return this._uadDisplayServiceTrackerMap.values();
    }

    public Stream<UADDisplay> getUADDisplayStream() {
        return this.getUADDisplays().stream();
    }

    public UADExporter getUADExporter(String key) {
        return (UADExporter)this._uadExporterServiceTrackerMap.getService((Object)key);
    }

    public UADHierarchyDisplay getUADHierarchyDisplay(String applicationKey) {
        UADHierarchyDeclaration uadHierarchyDeclaration = this._getUADHierarchyDeclaration(applicationKey);
        if (uadHierarchyDeclaration == null) {
            return null;
        }
        return new UADHierarchyDisplay(uadHierarchyDeclaration);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleUADAnonymizerServiceTrackerMap = this.getMultiValueServiceTrackerMap(bundleContext, UADAnonymizer.class);
        this._bundleUADDisplayServiceTrackerMap = this.getMultiValueServiceTrackerMap(bundleContext, UADDisplay.class);
        this._bundleUADExporterServiceTrackerMap = this.getMultiValueServiceTrackerMap(bundleContext, UADExporter.class);
        this._bundleUADHierarchyDeclarationServiceTrackerMap = this.getUADHierachyDeclarationServiceTrackerMap(bundleContext, UADHierarchyDeclaration.class);
        this._uadAnonymizerServiceTrackerMap = this.getSingleValueServiceTrackerMap(bundleContext, UADAnonymizer.class);
        this._uadDisplayServiceTrackerMap = this.getSingleValueServiceTrackerMap(bundleContext, UADDisplay.class);
        this._uadExporterServiceTrackerMap = this.getSingleValueServiceTrackerMap(bundleContext, UADExporter.class);
    }

    @Deactivate
    protected void deactivate() {
        this._bundleUADAnonymizerServiceTrackerMap.close();
        this._bundleUADDisplayServiceTrackerMap.close();
        this._bundleUADExporterServiceTrackerMap.close();
        this._bundleUADHierarchyDeclarationServiceTrackerMap.close();
        this._uadAnonymizerServiceTrackerMap.close();
        this._uadDisplayServiceTrackerMap.close();
        this._uadExporterServiceTrackerMap.close();
    }

    protected <T extends UADComponent> ServiceTrackerMap<String, List<T>> getMultiValueServiceTrackerMap(BundleContext bundleContext, Class<T> clazz) {
        return ServiceTrackerMapFactory.openMultiValueMap((BundleContext)bundleContext, clazz, null, (ServiceReferenceMapper)ServiceReferenceMapperFactory.create((BundleContext)bundleContext, (uadDisplay, emitter) -> {
            Bundle bundle = FrameworkUtil.getBundle(uadDisplay.getClass());
            emitter.emit((Object)bundle.getSymbolicName());
        }));
    }

    protected <T extends UADComponent> ServiceTrackerMap<String, T> getSingleValueServiceTrackerMap(BundleContext bundleContext, Class<T> clazz) {
        return ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, clazz, null, (ServiceReferenceMapper)ServiceReferenceMapperFactory.create((BundleContext)bundleContext, (uadComponent, emitter) -> {
            Class uadClass = uadComponent.getTypeClass();
            emitter.emit((Object)uadClass.getName());
        }));
    }

    protected <T> ServiceTrackerMap<String, T> getUADHierachyDeclarationServiceTrackerMap(BundleContext bundleContext, Class<T> clazz) {
        return ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, clazz, null, (ServiceReferenceMapper)ServiceReferenceMapperFactory.create((BundleContext)bundleContext, (uadHierachyDeclaration, emitter) -> {
            Bundle bundle = FrameworkUtil.getBundle(uadHierachyDeclaration.getClass());
            emitter.emit((Object)bundle.getSymbolicName());
        }));
    }

    private Collection<UADAnonymizer> _getNonreviewableUADAnonymizers(Collection<UADAnonymizer> uadAnonymizers, Stream<UADDisplay> uadDisplayStream) {
        Stream<Class> typeClassStream = uadDisplayStream.map(UADComponent::getTypeClass);
        List uadDisplayTypeClasses = typeClassStream.collect(Collectors.toList());
        ArrayList<UADAnonymizer> nonreviewableUADAnonymizers = new ArrayList<UADAnonymizer>(uadAnonymizers);
        for (UADAnonymizer uadAnonymizer : uadAnonymizers) {
            if (!uadDisplayTypeClasses.contains(uadAnonymizer.getTypeClass())) continue;
            nonreviewableUADAnonymizers.remove(uadAnonymizer);
        }
        return nonreviewableUADAnonymizers;
    }

    private UADHierarchyDeclaration _getUADHierarchyDeclaration(String applicationKey) {
        return (UADHierarchyDeclaration)this._bundleUADHierarchyDeclarationServiceTrackerMap.getService((Object)applicationKey);
    }
}

