/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.user.associated.data.web.internal.portlet.action;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.PortletURLUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCRenderCommand;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.user.associated.data.display.UADDisplay;
import com.liferay.user.associated.data.web.internal.constants.UADConstants;
import com.liferay.user.associated.data.web.internal.display.ScopeDisplay;
import com.liferay.user.associated.data.web.internal.display.UADApplicationSummaryDisplay;
import com.liferay.user.associated.data.web.internal.display.UADHierarchyDisplay;
import com.liferay.user.associated.data.web.internal.display.UADInfoPanelDisplay;
import com.liferay.user.associated.data.web.internal.display.ViewUADEntitiesDisplay;
import com.liferay.user.associated.data.web.internal.registry.UADRegistry;
import com.liferay.user.associated.data.web.internal.search.UADHierarchyResultRowSplitter;
import com.liferay.user.associated.data.web.internal.util.SelectedUserHelper;
import com.liferay.user.associated.data.web.internal.util.UADApplicationSummaryHelper;
import com.liferay.user.associated.data.web.internal.util.UADSearchContainerBuilder;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.MimeResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_user_associated_data_web_portlet_UserAssociatedData", "mvc.command.name=/review_uad_data"}, service={MVCRenderCommand.class})
public class ReviewUADDataMVCRenderCommand
implements MVCRenderCommand {
    private static final Log _log = LogFactoryUtil.getLog(ReviewUADDataMVCRenderCommand.class);
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private SelectedUserHelper _selectedUserHelper;
    @Reference
    private UADApplicationSummaryHelper _uadApplicationSummaryHelper;
    @Reference
    private UADRegistry _uadRegistry;
    @Reference
    private UADSearchContainerBuilder _uadSearchContainerBuilder;

    public String render(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException {
        try {
            User selectedUser = this._selectedUserHelper.getSelectedUser((PortletRequest)renderRequest);
            String scope = ParamUtil.getString((PortletRequest)renderRequest, (String)"scope", (String)"personal-site");
            ArrayList<ScopeDisplay> scopeDisplays = new ArrayList<ScopeDisplay>();
            ScopeDisplay scopeDisplay = null;
            for (String curScope : UADConstants.SCOPES) {
                long[] curGroupIds = this._getGroupIds(selectedUser, curScope);
                ScopeDisplay curScopeDisplay = new ScopeDisplay(curScope, curGroupIds, this._uadApplicationSummaryHelper.getUADApplicationSummaryDisplays(selectedUser.getUserId(), curGroupIds));
                scopeDisplays.add(curScopeDisplay);
                if (!scope.equals(curScope)) continue;
                scopeDisplay = curScopeDisplay;
            }
            if (!scopeDisplay.hasItems()) {
                for (ScopeDisplay curScopeDisplay : scopeDisplays) {
                    if (!curScopeDisplay.hasItems()) continue;
                    scopeDisplay = curScopeDisplay;
                }
            }
            scopeDisplay.setActive(true);
            String applicationKey = ParamUtil.getString((PortletRequest)renderRequest, (String)"applicationKey");
            if (Validator.isNull((String)applicationKey)) {
                applicationKey = scopeDisplay.getApplicationKey();
            } else {
                for (UADApplicationSummaryDisplay uadApplicationSummaryDisplay : scopeDisplay.getUADApplicationSummaryDisplays()) {
                    if (!applicationKey.equals(uadApplicationSummaryDisplay.getApplicationKey()) || uadApplicationSummaryDisplay.hasItems()) continue;
                    applicationKey = scopeDisplay.getApplicationKey();
                }
            }
            ViewUADEntitiesDisplay viewUADEntitiesDisplay = new ViewUADEntitiesDisplay();
            viewUADEntitiesDisplay.setApplicationKey(applicationKey);
            LiferayPortletResponse liferayPortletResponse = this._portal.getLiferayPortletResponse((PortletResponse)renderResponse);
            PortletURL currentURL = PortletURLUtil.getCurrent((PortletRequest)renderRequest, (MimeResponse)renderResponse);
            UADInfoPanelDisplay uadInfoPanelDisplay = new UADInfoPanelDisplay();
            UADHierarchyDisplay uadHierarchyDisplay = this._uadRegistry.getUADHierarchyDisplay(applicationKey);
            if (applicationKey.equals("all-applications")) {
                viewUADEntitiesDisplay.setSearchContainer(this._uadSearchContainerBuilder.getSearchContainer(renderRequest, liferayPortletResponse, currentURL, scopeDisplay.getUADApplicationSummaryDisplays()));
            } else if (uadHierarchyDisplay != null) {
                UADDisplay<?>[] uadDisplays = uadHierarchyDisplay.getUADDisplays();
                uadInfoPanelDisplay.setUADDisplay(uadDisplays[0]);
                uadInfoPanelDisplay.setHierarchyView(true);
                viewUADEntitiesDisplay.setHierarchy(true);
                viewUADEntitiesDisplay.setResultRowSplitter(new UADHierarchyResultRowSplitter(LocaleThreadLocal.getThemeDisplayLocale(), uadHierarchyDisplay.getUADDisplays()));
                viewUADEntitiesDisplay.setTypeClasses(uadHierarchyDisplay.getTypeClasses());
                Class<?> parentContainerClass = uadHierarchyDisplay.getFirstContainerTypeClass();
                viewUADEntitiesDisplay.setSearchContainer(this._uadSearchContainerBuilder.getSearchContainer(renderRequest, liferayPortletResponse, applicationKey, currentURL, scopeDisplay.getGroupIds(), parentContainerClass, Long.valueOf(0L), selectedUser, uadHierarchyDisplay));
                renderRequest.setAttribute("UAD_HIERARCHY_DISPLAY", (Object)uadHierarchyDisplay);
            } else {
                String uadRegistryKey = ParamUtil.getString((PortletRequest)renderRequest, (String)"uadRegistryKey");
                if (Validator.isNull((String)uadRegistryKey)) {
                    uadRegistryKey = this._uadApplicationSummaryHelper.getDefaultUADRegistryKey(applicationKey);
                }
                UADDisplay uadDisplay = this._uadRegistry.getUADDisplay(uadRegistryKey);
                uadInfoPanelDisplay.setUADDisplay(uadDisplay);
                viewUADEntitiesDisplay.setSearchContainer(this._uadSearchContainerBuilder.getSearchContainer(renderRequest, liferayPortletResponse, currentURL, scopeDisplay.getGroupIds(), selectedUser, uadDisplay));
                viewUADEntitiesDisplay.setTypeName(uadDisplay.getTypeName(LocaleThreadLocal.getThemeDisplayLocale()));
                viewUADEntitiesDisplay.setTypeClasses(new Class[]{uadDisplay.getTypeClass()});
                viewUADEntitiesDisplay.setUADRegistryKey(uadRegistryKey);
                renderRequest.setAttribute("APPLICATION_UAD_DISPLAYS", this._uadRegistry.getApplicationUADDisplays(applicationKey));
            }
            renderRequest.setAttribute("GROUP_IDS", (Object)scopeDisplay.getGroupIds());
            renderRequest.setAttribute("SCOPE_DISPLAYS", scopeDisplays);
            renderRequest.setAttribute("TOTAL_UAD_ENTITIES_COUNT", (Object)this._uadApplicationSummaryHelper.getTotalReviewableUADEntitiesCount(selectedUser.getUserId()));
            renderRequest.setAttribute("UAD_APPLICATION_SUMMARY_DISPLAY_LIST", scopeDisplay.getUADApplicationSummaryDisplays());
            renderRequest.setAttribute("UAD_INFO_PANEL_DISPLAY", (Object)uadInfoPanelDisplay);
            renderRequest.setAttribute("VIEW_UAD_ENTITIES_DISPLAY", (Object)viewUADEntitiesDisplay);
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
        return "/review_uad_data.jsp";
    }

    private long[] _getGroupIds(User user, String scope) {
        try {
            if (scope.equals("personal-site")) {
                Group userGroup = this._groupLocalService.getUserGroup(user.getCompanyId(), user.getUserId());
                return new long[]{userGroup.getGroupId()};
            }
            if (scope.equals("regular-sites")) {
                ArrayList<Group> allGroups = new ArrayList<Group>();
                List liveGroups = this._groupLocalService.getGroups(user.getCompanyId(), -1L, true);
                allGroups.addAll(liveGroups);
                for (Group group : liveGroups) {
                    Group stagingGroup = group.getStagingGroup();
                    if (stagingGroup == null) continue;
                    allGroups.add(stagingGroup);
                }
                return ListUtil.toLongArray(allGroups, (Accessor)Group.GROUP_ID_ACCESSOR);
            }
        }
        catch (PortalException pe) {
            _log.error((Object)pe, (Throwable)pe);
        }
        return null;
    }
}

