/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.user.associated.data.web.internal.portlet.action;

import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.portal.kernel.exception.NoSuchModelException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.user.associated.data.anonymizer.UADAnonymizer;
import com.liferay.user.associated.data.display.UADDisplay;
import com.liferay.user.associated.data.web.internal.display.UADHierarchyDisplay;
import com.liferay.user.associated.data.web.internal.portlet.action.BaseUADMVCActionCommand;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_user_associated_data_web_portlet_UserAssociatedData", "mvc.command.name=/delete_uad_entities"}, service={MVCActionCommand.class})
public class DeleteUADEntitiesMVCActionCommand
extends BaseUADMVCActionCommand {
    private static final Log _log = LogFactoryUtil.getLog(DeleteUADEntitiesMVCActionCommand.class);

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String applicationKey = ParamUtil.getString((PortletRequest)actionRequest, (String)"applicationKey");
        UADHierarchyDisplay uadHierarchyDisplay = this.uadRegistry.getUADHierarchyDisplay(applicationKey);
        for (String entityType : this.getEntityTypes(actionRequest)) {
            String[] primaryKeys = this.getPrimaryKeys(actionRequest, entityType);
            UADAnonymizer entityUADAnonymizer = this.getUADAnonymizer(actionRequest, entityType);
            UADDisplay entityUADDisplay = this.getUADDisplay(actionRequest, entityType);
            for (String primaryKey : primaryKeys) {
                this._delete(entityUADAnonymizer, entityUADDisplay, primaryKey, this.getSelectedUserId(actionRequest), uadHierarchyDisplay);
            }
        }
        this.doReviewableRedirect(actionRequest, actionResponse);
    }

    private void _delete(UADAnonymizer entityUADAnonymizer, UADDisplay<?> entityUADDisplay, String primaryKey, long selectedUserId, UADHierarchyDisplay uadHierarchyDisplay) throws Exception {
        Object entity = entityUADDisplay.get((Serializable)((Object)primaryKey));
        if (uadHierarchyDisplay != null) {
            if (uadHierarchyDisplay.isUserOwned(entity, selectedUserId)) {
                entityUADAnonymizer.delete(entity);
            } else {
                Map<Class<?>, List<Serializable>> containerItemPKsMap = uadHierarchyDisplay.getContainerItemPKsMap(entityUADDisplay.getTypeClass(), uadHierarchyDisplay.getPrimaryKey(entity), selectedUserId);
                for (Map.Entry<Class<?>, List<Serializable>> entry : containerItemPKsMap.entrySet()) {
                    Class<?> containerItemClass = entry.getKey();
                    UADAnonymizer containerItemUADAnonymizer = this.uadRegistry.getUADAnonymizer(containerItemClass.getName());
                    UADDisplay containerItemUADDisplay = this.uadRegistry.getUADDisplay(containerItemClass.getName());
                    this.doMultipleAction(entry.getValue(), (UnsafeConsumer<Serializable, Exception>)((UnsafeConsumer)containerItemPK -> {
                        block2: {
                            try {
                                Object containerItem = containerItemUADDisplay.get(containerItemPK);
                                containerItemUADAnonymizer.delete(containerItem);
                            }
                            catch (NoSuchModelException nsme) {
                                if (!_log.isDebugEnabled()) break block2;
                                _log.debug((Object)nsme, (Throwable)nsme);
                            }
                        }
                    }));
                }
            }
        } else {
            entityUADAnonymizer.delete(entity);
        }
    }
}

