/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.user.associated.data.web.internal.portlet.action;

import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.user.associated.data.anonymizer.UADAnonymizer;
import com.liferay.user.associated.data.display.UADDisplay;
import com.liferay.user.associated.data.web.internal.registry.UADRegistry;
import com.liferay.user.associated.data.web.internal.util.SelectedUserHelper;
import com.liferay.user.associated.data.web.internal.util.UADApplicationSummaryHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseUADMVCActionCommand
extends BaseMVCActionCommand {
    @Reference
    protected SelectedUserHelper selectedUserHelper;
    @Reference
    protected UADApplicationSummaryHelper uadApplicationSummaryHelper;
    @Reference
    protected UADRegistry uadRegistry;

    protected void doMultipleAction(List<Serializable> primaryKeys, UnsafeConsumer<Serializable, Exception> unsafeConsumer) throws Exception {
        for (Serializable primaryKey : primaryKeys) {
            unsafeConsumer.accept((Object)primaryKey);
        }
    }

    protected void doNonreviewableRedirect(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String mvcRenderCommandName = null;
        long selectedUserId = this.getSelectedUserId(actionRequest);
        if (this.uadApplicationSummaryHelper.getTotalNonreviewableUADEntitiesCount(selectedUserId) == 0) {
            mvcRenderCommandName = this.uadApplicationSummaryHelper.getTotalReviewableUADEntitiesCount(selectedUserId) == 0 ? "/completed_data_erasure" : "/review_uad_data";
        }
        if (Validator.isNull(mvcRenderCommandName)) {
            return;
        }
        LiferayPortletURL liferayPortletURL = PortletURLFactoryUtil.create((PortletRequest)actionRequest, (String)"com_liferay_user_associated_data_web_portlet_UserAssociatedData", (String)"RENDER_PHASE");
        liferayPortletURL.setParameter("p_u_i_d", String.valueOf(selectedUserId));
        liferayPortletURL.setParameter("mvcRenderCommandName", mvcRenderCommandName);
        this.sendRedirect(actionRequest, actionResponse, liferayPortletURL.toString());
    }

    protected void doReviewableRedirect(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String mvcRenderCommandName = null;
        long selectedUserId = this.getSelectedUserId(actionRequest);
        if (this.uadApplicationSummaryHelper.getTotalReviewableUADEntitiesCount(selectedUserId) == 0) {
            mvcRenderCommandName = this.uadApplicationSummaryHelper.getTotalNonreviewableUADEntitiesCount(selectedUserId) == 0 ? "/completed_data_erasure" : "/anonymize_nonreviewable_uad_data";
        }
        if (Validator.isNull(mvcRenderCommandName)) {
            return;
        }
        LiferayPortletURL liferayPortletURL = PortletURLFactoryUtil.create((PortletRequest)actionRequest, (String)"com_liferay_user_associated_data_web_portlet_UserAssociatedData", (String)"RENDER_PHASE");
        liferayPortletURL.setParameter("p_u_i_d", String.valueOf(selectedUserId));
        liferayPortletURL.setParameter("mvcRenderCommandName", mvcRenderCommandName);
        this.sendRedirect(actionRequest, actionResponse, liferayPortletURL.toString());
    }

    protected String[] getApplicationKeys(ActionRequest actionRequest) {
        String applicationKey = ParamUtil.getString((PortletRequest)actionRequest, (String)"applicationKey");
        if (Validator.isNotNull((String)applicationKey)) {
            return new String[]{applicationKey};
        }
        return ParamUtil.getStringValues((PortletRequest)actionRequest, (String)"applicationKeys");
    }

    protected List<String> getEntityTypes(ActionRequest actionRequest) {
        ArrayList<String> entityTypes = new ArrayList<String>();
        Map parameterMap = actionRequest.getParameterMap();
        for (String key : parameterMap.keySet()) {
            if (!key.startsWith("uadRegistryKey__")) continue;
            entityTypes.add(key.replace("uadRegistryKey__", ""));
        }
        return entityTypes;
    }

    protected String[] getPrimaryKeys(ActionRequest actionRequest, String entityType) {
        String primaryKey = ParamUtil.getString((PortletRequest)actionRequest, (String)("primaryKey__" + entityType));
        if (Validator.isNotNull((String)primaryKey)) {
            return new String[]{primaryKey};
        }
        return ParamUtil.getStringValues((PortletRequest)actionRequest, (String)("primaryKeys__" + entityType));
    }

    protected User getSelectedUser(ActionRequest actionRequest) throws PortalException {
        return this.selectedUserHelper.getSelectedUser((PortletRequest)actionRequest);
    }

    protected long getSelectedUserId(ActionRequest actionRequest) throws PortalException {
        return this.selectedUserHelper.getSelectedUserId((PortletRequest)actionRequest);
    }

    protected UADAnonymizer getUADAnonymizer(ActionRequest actionRequest, String entityType) {
        return this.uadRegistry.getUADAnonymizer(this.getUADRegistryKey(actionRequest, entityType));
    }

    protected UADDisplay getUADDisplay(ActionRequest actionRequest, String entityType) {
        return this.uadRegistry.getUADDisplay(this.getUADRegistryKey(actionRequest, entityType));
    }

    protected String getUADRegistryKey(ActionRequest actionRequest, String entityType) {
        return ParamUtil.getString((PortletRequest)actionRequest, (String)("uadRegistryKey__" + entityType));
    }
}

